/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.examples.extlibrary.presentation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.examples.extlibrary.presentation.EXTLibraryEditorPlugin;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ResourceLoadedListener
extends DemultiplexingListener {
    private static ResourceLoadedListener instance;
    private final Set ignoredResources = new HashSet();

    public ResourceLoadedListener() {
        super(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)4));
        instance = this;
    }

    public static ResourceLoadedListener getDefault() {
        return instance;
    }

    public void ignore(Resource res) {
        this.ignoredResources.add(res);
    }

    public void watch(Resource res) {
        this.ignoredResources.remove(res);
    }

    protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
        IFile file;
        if (this.ignoredResources.contains(notification.getNotifier())) {
            return;
        }
        if (notification.getNewBooleanValue() && !notification.getOldBooleanValue()) {
            final IFile file2 = WorkspaceSynchronizer.getFile((Resource)((Resource)notification.getNotifier()));
            if (file2 != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            IWorkbenchPage page = ResourceLoadedListener.this.getActivePage();
                            if (page != null) {
                                IEditorPart activeEditor = page.getActiveEditor();
                                page.openEditor((IEditorInput)new FileEditorInput(file2), "org.eclipse.emf.workspace.examples.extlibrary.presentation.EXTLibraryEditorID", false);
                                if (activeEditor != null) {
                                    page.activate((IWorkbenchPart)activeEditor);
                                }
                            }
                        }
                        catch (PartInitException e) {
                            EXTLibraryEditorPlugin.getPlugin().log(e.getStatus());
                        }
                    }
                });
            }
        } else if (!notification.getNewBooleanValue() && notification.getOldBooleanValue() && (file = WorkspaceSynchronizer.getFile((Resource)((Resource)notification.getNotifier()))) != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page = ResourceLoadedListener.this.getActivePage();
                    if (page != null) {
                        IEditorReference[] editors = page.findEditors((IEditorInput)new FileEditorInput(file), "org.eclipse.emf.workspace.examples.extlibrary.presentation.EXTLibraryEditorID", 3);
                        page.closeEditors(editors, false);
                    }
                }
            });
        }
    }

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow window;
        IWorkbenchPage result = null;
        IWorkbench bench = PlatformUI.getWorkbench();
        if (bench != null && (window = bench.getActiveWorkbenchWindow()) != null) {
            result = window.getActivePage();
        }
        return result;
    }
}

