/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.AbstractAnnotator;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.annotations.pannotation.FetchType;
import org.eclipse.emf.teneo.annotations.pannotation.ForeignKey;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.annotations.pannotation.Temporal;
import org.eclipse.emf.teneo.annotations.pannotation.TemporalType;
import org.eclipse.emf.teneo.util.EcoreDataTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEFeatureAnnotator
extends AbstractAnnotator {
    protected static final Log log = LogFactory.getLog(BaseEFeatureAnnotator.class);
    private int defaultVarCharLength = -1;

    protected ForeignKey createFK(PAnnotatedEStructuralFeature aFeature) {
        ForeignKey fk = this.getFactory().createForeignKey();
        fk.setName(this.getSqlNameStrategy().getForeignKeyName(aFeature));
        return fk;
    }

    protected FetchType getFetch(PAnnotatedEClass aClass) {
        return FetchType.EAGER;
    }

    @Override
    public void setPersistenceOptions(PersistenceOptions persistenceOptions) {
        super.setPersistenceOptions(persistenceOptions);
        this.defaultVarCharLength = persistenceOptions.getDefaultVarCharLength();
    }

    protected void addColumnConstraints(PAnnotatedEAttribute aAttribute) {
        if (aAttribute.getId() != null) {
            aAttribute.getModelEAttribute().setLowerBound(1);
        }
        EAttribute eAttribute = aAttribute.getModelEAttribute();
        if (aAttribute.getColumn() == null) {
            String maxLength = this.getExtendedMetaData(eAttribute, "maxLength");
            if (maxLength == null) {
                maxLength = this.getExtendedMetaData(eAttribute, "length");
            }
            if (maxLength == null && this.defaultVarCharLength > 0) {
                maxLength = "" + this.defaultVarCharLength;
            }
            String totalDigits = this.getExtendedMetaData(eAttribute, "totalDigits");
            String fractionDigits = this.getExtendedMetaData(eAttribute, "fractionDigits");
            boolean setUnique = false;
            if (this.getPersistenceOptions().isIDFeatureAsPrimaryKey() && eAttribute.isID() && aAttribute.getId() == null && aAttribute.getPaEClass().getPaSuperEntity() != null && aAttribute.getPaEClass().getPaSuperEntity().getMappedSuperclass() == null) {
                setUnique = true;
            }
            if (maxLength != null || setUnique || totalDigits != null || fractionDigits != null || this.defaultVarCharLength > -1) {
                Column column = this.getFactory().createColumn();
                if (maxLength != null && eAttribute.getEAttributeType().getInstanceClass() != null && eAttribute.getEAttributeType().getInstanceClass() == String.class) {
                    column.setLength(Integer.parseInt(maxLength));
                }
                if (totalDigits != null) {
                    column.setPrecision(Integer.parseInt(totalDigits));
                }
                if (fractionDigits != null) {
                    column.setScale(Integer.parseInt(fractionDigits));
                }
                if (aAttribute.getBasic() != null) {
                    column.setNullable(aAttribute.getBasic().isOptional());
                }
                if (setUnique) {
                    column.setUnique(true);
                }
                aAttribute.setColumn(column);
            }
        } else if (aAttribute.getBasic() != null && !aAttribute.getColumn().isSetNullable()) {
            aAttribute.getColumn().setNullable(aAttribute.getBasic().isOptional());
        }
        Column c = aAttribute.getColumn();
        if (this.isStringType(aAttribute.getModelEAttribute()) && c != null && this.defaultVarCharLength > 0 && !c.isSetLength()) {
            c.setLength(this.defaultVarCharLength);
        }
        if (c != null && aAttribute.getId() != null) {
            c.setUnique(false);
        }
    }

    private boolean isStringType(EAttribute eAttribute) {
        Class clz = eAttribute.getEAttributeType().getInstanceClass();
        if (clz != null && String.class.isAssignableFrom(clz)) {
            return true;
        }
        if (eAttribute.getEAttributeType() == XMLTypePackage.eINSTANCE.getString()) {
            return true;
        }
        if (eAttribute.getEAttributeType() == XMLTypePackage.eINSTANCE.getName_()) {
            return true;
        }
        if (eAttribute.getEAttributeType() == XMLTypePackage.eINSTANCE.getNCName()) {
            return true;
        }
        if (eAttribute.getEAttributeType() == XMLTypePackage.eINSTANCE.getToken()) {
            return true;
        }
        return eAttribute.getEAttributeType() == XMLTypePackage.eINSTANCE.getQName();
    }

    protected List<JoinColumn> getJoinColumns(List<String> names, boolean optional, boolean isUpdateInsertable, PAnnotation pAnnotation) {
        ArrayList<JoinColumn> result = new ArrayList<JoinColumn>();
        for (String name : names) {
            JoinColumn jc = this.getFactory().createJoinColumn();
            jc.setName(name);
            jc.setNullable(optional);
            jc.setUpdatable(isUpdateInsertable);
            jc.setInsertable(isUpdateInsertable);
            result.add(jc);
        }
        return result;
    }

    protected String getTargetTypeName(PAnnotatedEAttribute aAttribute) {
        return EcoreDataTypes.INSTANCE.getTargetTypeName(aAttribute);
    }

    protected String getExtendedMetaData(EAttribute eAttribute, String key) {
        String value = EcoreDataTypes.INSTANCE.getEAnnotationValue((EModelElement)eAttribute, "http:///org/eclipse/emf/ecore/util/ExtendedMetaData", key);
        if (value == null) {
            value = EcoreDataTypes.INSTANCE.getEAnnotationValue((EModelElement)eAttribute.getEAttributeType(), "http:///org/eclipse/emf/ecore/util/ExtendedMetaData", key);
        }
        return value;
    }

    protected boolean setMappedBy(EReference eReference) {
        EReference eOpposite = eReference.getEOpposite();
        if (eOpposite == null) {
            return false;
        }
        PAnnotatedEReference aOpposite = this.getAnnotatedModel().getPAnnotated(eOpposite);
        if (aOpposite.getOneToOne() != null && aOpposite.getOneToOne().getMappedBy() != null) {
            return false;
        }
        return this.compareNames(eReference, eOpposite);
    }

    protected boolean compareNames(EReference here, EReference there) {
        String nameHere = String.valueOf(here.eClass().getName()) + here.getName();
        String nameThere = String.valueOf(there.eClass().getName()) + there.getName();
        assert (nameHere.compareTo(nameThere) != 0);
        return nameHere.compareTo(nameThere) > 0;
    }

    protected void setCascade(List<CascadeType> cascadeList, boolean isContainment) {
        if (!cascadeList.isEmpty()) {
            return;
        }
        if (isContainment) {
            if (this.getPersistenceOptions().isSetCascadeAllOnContainment()) {
                cascadeList.add(CascadeType.ALL);
            } else {
                if (this.getPersistenceOptions().isSetCascadeRemoveOnContainment()) {
                    cascadeList.add(CascadeType.REMOVE);
                }
                if (this.getPersistenceOptions().isSetCascadeMergeOnContainment()) {
                    cascadeList.add(CascadeType.MERGE);
                }
                if (this.getPersistenceOptions().isSetCascadePersistOnContainment()) {
                    cascadeList.add(CascadeType.PERSIST);
                }
                if (this.getPersistenceOptions().isSetCascadeRefreshOnContainment()) {
                    cascadeList.add(CascadeType.REFRESH);
                }
            }
        } else if (this.getPersistenceOptions().isSetCascadePolicyForNonContainment()) {
            if (this.getPersistenceOptions().isSetCascadeMergeOnNonContainment()) {
                cascadeList.add(CascadeType.MERGE);
            }
            if (this.getPersistenceOptions().isSetCascadePersistOnNonContainment()) {
                cascadeList.add(CascadeType.PERSIST);
            }
            if (this.getPersistenceOptions().isSetCascadeRefreshOnNonContainment()) {
                cascadeList.add(CascadeType.REFRESH);
            }
        } else {
            cascadeList.add(CascadeType.MERGE);
            cascadeList.add(CascadeType.PERSIST);
            cascadeList.add(CascadeType.REFRESH);
        }
    }

    protected void setTemporal(PAnnotatedEAttribute aAttribute, TemporalType defaultTemporal) {
        Temporal temporal;
        EAttribute eAttribute = aAttribute.getModelEAttribute();
        Class clazz = eAttribute.getEAttributeType().getInstanceClass();
        if (clazz == null || Object.class.equals((Object)clazz)) {
            ArrayList<EClassifier> eclassifiers = EcoreDataTypes.INSTANCE.getItemTypes((EDataType)eAttribute.getEType());
            for (EClassifier eclassifier : eclassifiers) {
                if (eclassifier.getInstanceClass() == null) continue;
                clazz = eclassifier.getInstanceClass();
                break;
            }
        }
        EDataType eDataType = aAttribute.getModelEAttribute().getEAttributeType();
        if (clazz != null && (Date.class.isAssignableFrom(clazz) || eDataType == XMLTypePackage.eINSTANCE.getDate() || eDataType == XMLTypePackage.eINSTANCE.getDateTime())) {
            temporal = this.getFactory().createTemporal();
            if (eDataType == XMLTypePackage.eINSTANCE.getDate()) {
                temporal.setValue(TemporalType.DATE);
            } else if (eDataType == XMLTypePackage.eINSTANCE.getDateTime()) {
                temporal.setValue(TemporalType.TIMESTAMP);
            } else {
                temporal.setValue(defaultTemporal);
            }
            aAttribute.setTemporal(temporal);
            temporal.setEModelElement((EModelElement)eAttribute);
        } else if (clazz != null && (Calendar.class.isAssignableFrom(clazz) || eDataType == XMLTypePackage.eINSTANCE.getDate() || eDataType == XMLTypePackage.eINSTANCE.getDateTime())) {
            temporal = this.getFactory().createTemporal();
            if (eDataType == XMLTypePackage.eINSTANCE.getDate()) {
                temporal.setValue(TemporalType.DATE);
            } else if (eDataType == XMLTypePackage.eINSTANCE.getDateTime()) {
                temporal.setValue(TemporalType.TIMESTAMP);
            } else {
                temporal.setValue(defaultTemporal);
            }
            aAttribute.setTemporal(temporal);
            temporal.setEModelElement((EModelElement)eAttribute);
        }
    }
}

