/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapping;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.teneo.classloader.StoreClassLoadException;
import org.eclipse.emf.teneo.jpox.JpoxStoreException;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.PersistenceManager;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingManager;

public class ENumMapping
extends JavaTypeMapping {
    private Class enumType;
    private Method getMethod;
    private final HashMap localCache = new HashMap();

    public void initialize(DatastoreAdapter dba, String type) {
        super.initialize(dba, type);
        try {
            this.enumType = org.eclipse.emf.teneo.classloader.ClassLoaderResolver.classForName((String)type);
            this.getMethod = this.enumType.getMethod("get", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JpoxStoreException("The get method which returns an enum instance does not exist for the class: " + type);
        }
        catch (StoreClassLoadException storeClassLoadException) {
            throw new JpoxStoreException("The enum can not be found: " + type);
        }
    }

    public void initialize(DatastoreAdapter dba, AbstractPropertyMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        try {
            this.enumType = fmd.getType();
            this.getMethod = this.enumType.getMethod("get", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JpoxStoreException("The get method which returns an enum instance does not exist for the class: " + this.type);
        }
        catch (StoreClassLoadException storeClassLoadException) {
            throw new JpoxStoreException("The enum can not be found: " + this.type);
        }
        this.addDatastoreField(ClassNameConstants.JAVA_LANG_STRING);
    }

    protected void addDatastoreField(String typeName) {
        MappingManager mgr = this.dba.getMappingManager();
        DatastoreField column = mgr.createDatastoreField(this.fmd, this.datastoreContainer, this.dba, (JavaTypeMapping)this, typeName, this.getNumberOfDatastoreFields());
        mgr.createDatastoreMapping((JavaTypeMapping)this, this.datastoreContainer.getStoreManager(), column, typeName);
    }

    public Class getJavaType() {
        return this.enumType;
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        return String.class.getName();
    }

    public DatastoreContainerObject getDatastoreContainer() {
        return this.datastoreContainer;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        try {
            Method getIntMethod = this.enumType.getMethod("get", Integer.TYPE);
            return getIntMethod.invoke(null, new Integer(0));
        }
        catch (Exception e) {
            throw new JpoxStoreException("Exception when getting sample enum for class: " + this.enumType.getName(), e);
        }
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public boolean includeInUpdateStatement() {
        return true;
    }

    public boolean includeInInsertStatement() {
        return true;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        StringLiteral expr = new StringLiteral(qs, (JavaTypeMapping)this, ((Enumerator)value).getLiteral());
        return expr;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        StringExpression expr = new StringExpression(qs, (JavaTypeMapping)this, te);
        return expr;
    }

    public void setObject(PersistenceManager pm, Object preparedStatement, int[] exprIndex, Object value) {
        Enumerator enumValue = (Enumerator)value;
        if (enumValue == null) {
            this.getDataStoreMapping(0).setString(preparedStatement, exprIndex[0], null);
        } else {
            this.getDataStoreMapping(0).setString(preparedStatement, exprIndex[0], enumValue.getLiteral());
        }
    }

    public synchronized Object getObject(PersistenceManager pm, Object resultSet, int[] exprIndex) {
        String strVal = this.getDataStoreMapping(0).getString(resultSet, exprIndex[0]);
        Enumerator enumValue = (Enumerator)this.localCache.get(strVal);
        if (enumValue != null) {
            return enumValue;
        }
        try {
            enumValue = (Enumerator)this.getMethod.invoke(null, strVal);
            this.localCache.put(strVal, enumValue);
            return enumValue;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new JpoxStoreException("Exception when getting enum for class: " + this.enumType.getName() + " using value: " + strVal, e);
        }
    }
}

