/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.dependency.DependencyProviderDescriptor;
import org.eclipse.emf.compare.ide.ui.dependency.IDependencyProvider;
import org.eclipse.emf.compare.ide.ui.dependency.ModelDependencyProviderRegistry;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.tests.unit.AbstractGitLogicalModelTest;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.junit.Assert;
import org.junit.Test;

public class GitLogicalMergeWithCustomDependenciesTest
extends AbstractGitLogicalModelTest {
    private static final String DEPENDENT_FILE_NAME = "dependentFile.ecore";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        EPackage packageP1 = this.createPackage(null, "P1");
        EClass classC1 = this.createClass(packageP1, "C1");
        this.createClass(packageP1, "C2");
        this.resource1.getContents().add((Object)packageP1);
        EPackage packageP2 = this.createPackage(null, "P2");
        EClass classC3 = this.createClass(packageP2, "C3");
        this.createClass(packageP2, "C4");
        this.resource2.getContents().add((Object)packageP2);
        classC3.getESuperTypes().add((Object)classC1);
        this.save(new Resource[]{this.resource1, this.resource2});
    }

    @Override
    public void tearDown() throws Exception {
        this.getModelDependencyProviderRegistry().clear();
        super.tearDown();
    }

    private ModelDependencyProviderRegistry getModelDependencyProviderRegistry() {
        return EMFCompareIDEUIPlugin.getDefault().getModelDependencyProviderRegistry();
    }

    @Test
    public void testRemoteBranchAddsUnlinkedNonEmptyDependentFile() throws Exception {
        HashSet<EObject> contentsOfNewResource = new HashSet<EObject>();
        contentsOfNewResource.add((EObject)this.createPackage(null, "P3"));
        this.assertCorrectMergingIfRemoteBranchAddsUnlinkedButDependentFile(contentsOfNewResource);
    }

    @Test
    public void testRemoteBranchAddsUnlinkedEmptyDependentFile() throws Exception {
        this.assertCorrectMergingIfRemoteBranchAddsUnlinkedButDependentFile(new HashSet<EObject>());
    }

    private void assertCorrectMergingIfRemoteBranchAddsUnlinkedButDependentFile(Collection<EObject> contentsOfAddedFile) throws Exception, IOException, CoreException {
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        this.createClass((EPackage)this.findObject(this.resource1, "P1"), "C4");
        this.createClass((EPackage)this.findObject(this.resource2, "P2"), "C5");
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAndCommit(this.project, "master-commit", this.file1, this.file2);
        this.repository.checkoutBranch("refs/heads/branch");
        this.save(new Resource[]{this.createResourceWithContents(DEPENDENT_FILE_NAME, contentsOfAddedFile)});
        File dependentFile = this.getFile(DEPENDENT_FILE_NAME);
        Assert.assertTrue((boolean)dependentFile.exists());
        this.createClass((EPackage)this.findObject(this.resource1, "P1"), "C6");
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "branch-commit", dependentFile, this.file1);
        this.installMockModelDependencyProvider((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of((Object)this.file1.getName(), (Object)ImmutableSet.of((Object)DEPENDENT_FILE_NAME)));
        this.repository.checkoutBranch("refs/heads/master");
        Assert.assertFalse((boolean)this.iProject.exists((IPath)new Path(DEPENDENT_FILE_NAME)));
        this.repository.mergeLogical("refs/heads/branch");
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertTrue((boolean)this.iProject.exists((IPath)new Path(DEPENDENT_FILE_NAME)));
    }

    @Test
    public void testRemoteBranchDeletesUnlinkedNonEmptyDependentFile() throws Exception {
        HashSet<EObject> contentsOfDeletedResource = new HashSet<EObject>();
        contentsOfDeletedResource.add((EObject)this.createPackage(null, "P3"));
        this.assertCorrectMergingIfRemoteBranchDeletesUnlinkedButDependentFile(contentsOfDeletedResource);
    }

    @Test
    public void testRemoteBranchDeletesUnlinkedEmptyDependentFile() throws Exception {
        this.assertCorrectMergingIfRemoteBranchDeletesUnlinkedButDependentFile(new HashSet<EObject>());
    }

    private void assertCorrectMergingIfRemoteBranchDeletesUnlinkedButDependentFile(Collection<EObject> contentsOfDeletedResource) throws IOException, CoreException, Exception {
        this.save(new Resource[]{this.createResourceWithContents(DEPENDENT_FILE_NAME, contentsOfDeletedResource)});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        this.createClass((EPackage)this.findObject(this.resource1, "P1"), "C4");
        this.createClass((EPackage)this.findObject(this.resource2, "P2"), "C5");
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAndCommit(this.project, "master-commit", this.file1, this.file2);
        this.repository.checkoutBranch("refs/heads/branch");
        File dependentFile = this.getFile(DEPENDENT_FILE_NAME);
        this.iProject.getFile(DEPENDENT_FILE_NAME).delete(true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)this.iProject.exists((IPath)new Path(DEPENDENT_FILE_NAME)));
        this.createClass((EPackage)this.findObject(this.resource1, "P1"), "C6");
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "branch-commit", this.file1, dependentFile);
        this.installMockModelDependencyProvider((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of((Object)this.file1.getName(), (Object)ImmutableSet.of((Object)DEPENDENT_FILE_NAME)));
        this.repository.checkoutBranch("refs/heads/master");
        Assert.assertTrue((boolean)this.iProject.exists((IPath)new Path(DEPENDENT_FILE_NAME)));
        this.repository.mergeLogical("refs/heads/branch");
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertFalse((boolean)this.iProject.exists((IPath)new Path(DEPENDENT_FILE_NAME)));
    }

    private Resource createResourceWithContents(String fileName, Collection<EObject> contents) throws Exception {
        Resource newResource = this.createAndConnectResource(fileName);
        newResource.getContents().addAll(contents);
        return newResource;
    }

    private void installMockModelDependencyProvider(ImmutableMap<String, ImmutableSet<String>> dependencies) {
        this.getModelDependencyProviderRegistry().addProvider("mock", new DependencyProviderDescriptor(null, null, dependencies){
            private final IDependencyProvider mock;
            {
                this.mock = new MockDependencyProvider((ImmutableMap<String, ImmutableSet<String>>)immutableMap);
            }

            public IDependencyProvider getDependencyProvider() {
                return this.mock;
            }
        });
    }

    private class MockDependencyProvider
    implements IDependencyProvider {
        private ImmutableMap<String, ImmutableSet<String>> dependencies;

        public MockDependencyProvider(ImmutableMap<String, ImmutableSet<String>> dependencies) {
            this.dependencies = dependencies;
        }

        public boolean apply(URI uri) {
            return this.dependencies.containsKey((Object)uri.lastSegment());
        }

        public Set<URI> getDependencies(URI uri, URIConverter uriConverter) {
            if (this.dependencies.containsKey((Object)uri.lastSegment())) {
                HashSet<URI> uris = new HashSet<URI>();
                for (String fileName : (ImmutableSet)this.dependencies.get((Object)uri.lastSegment())) {
                    URI dependentUri = uri.trimSegments(1).appendSegment(fileName);
                    if (!uriConverter.exists(dependentUri, Collections.emptyMap())) continue;
                    uris.add(dependentUri);
                }
                return uris;
            }
            return Collections.emptySet();
        }
    }
}

