/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.command.impl.CopyCommand;
import org.eclipse.emf.compare.diagram.ide.ui.internal.accessor.IDiagramDiffAccessor;
import org.eclipse.emf.compare.diagram.ide.ui.internal.accessor.IDiagramNodeAccessor;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.DiagramMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.DecoratorFigure;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.EdgeFigure;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.NodeFigure;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.NodeListFigure;
import org.eclipse.emf.compare.diagram.internal.extensions.CoordinatesChange;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.diagram.internal.extensions.Hide;
import org.eclipse.emf.compare.diagram.internal.extensions.Show;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.MirroredTreeContentMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.TreeContentMergeViewerContentProvider;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListItemEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;

public class DiagramContentMergeViewer
extends EMFCompareContentMergeViewer {
    private static final String BUNDLE_NAME = DiagramContentMergeViewer.class.getName();
    private final DecoratorsManager fDecoratorsManager = new DecoratorsManager();
    private Diff fCurrentSelectedDiff;
    private boolean fRefreshDecorators;
    private TreeContentMergeViewerContentProvider fContentProvider;

    public DiagramContentMergeViewer(Composite parent, EMFCompareConfiguration config) {
        super(0, ResourceBundle.getBundle(BUNDLE_NAME), config);
        this.buildControl(parent);
        this.fContentProvider = new TreeContentMergeViewerContentProvider(config);
        this.setMirrored(this.isMirrored());
    }

    public DiagramMergeViewer getAncestorMergeViewer() {
        return (DiagramMergeViewer)super.getAncestorMergeViewer();
    }

    public DiagramMergeViewer getLeftMergeViewer() {
        return (DiagramMergeViewer)super.getLeftMergeViewer();
    }

    public DiagramMergeViewer getRightMergeViewer() {
        return (DiagramMergeViewer)super.getRightMergeViewer();
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected IMergeViewer createMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        DiagramMergeViewer diagramMergeViewer = new DiagramMergeViewer(parent, side, (IEMFCompareConfiguration)this.getCompareConfiguration());
        return diagramMergeViewer;
    }

    protected void paintCenter(GC g) {
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        this.fDecoratorsManager.hideAll();
        this.fDecoratorsManager.removeAll();
        super.updateContent(ancestor, left, right);
        this.getLeftMergeViewer().getGraphicalViewer().flush();
        this.getRightMergeViewer().getGraphicalViewer().flush();
        this.getAncestorMergeViewer().getGraphicalViewer().flush();
        if (left instanceof IDiagramNodeAccessor) {
            if (left instanceof IDiagramDiffAccessor) {
                IDiagramDiffAccessor input = (IDiagramDiffAccessor)left;
                DiagramDiff diff = input.getDiff();
                if (!AbstractMerger.isInTerminalState((Diff)diff) && (diff != this.fCurrentSelectedDiff || this.fRefreshDecorators)) {
                    this.fDecoratorsManager.revealDecorators((Diff)diff);
                }
                this.fCurrentSelectedDiff = diff;
                this.fRefreshDecorators = false;
            } else {
                this.fCurrentSelectedDiff = null;
            }
        }
        this.updateToolItems();
    }

    public void commandStackChanged(EventObject event) {
        UnmodifiableIterator diffs;
        Command command;
        super.commandStackChanged(event);
        Object source = event.getSource();
        if (source instanceof CommandStack && (command = ((CommandStack)source).getMostRecentCommand()) instanceof CopyCommand && (diffs = Iterators.filter(command.getAffectedObjects().iterator(), DiagramDiff.class)).hasNext()) {
            this.fDecoratorsManager.hideAll();
            this.fDecoratorsManager.removeAll();
        }
    }

    protected Diff getDiffFrom(IMergeViewer viewer) {
        return this.fCurrentSelectedDiff;
    }

    protected void createControls(Composite composite) {
        super.createControls(composite);
        this.getAncestorMergeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.getLeftMergeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.getRightMergeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    private DiagramMergeViewer getViewer(IMergeViewer.MergeViewerSide side) {
        DiagramMergeViewer result = null;
        switch (side) {
            case LEFT: {
                result = this.getLeftMergeViewer();
                break;
            }
            case RIGHT: {
                result = this.getRightMergeViewer();
                break;
            }
            case ANCESTOR: {
                result = this.getAncestorMergeViewer();
            }
        }
        return result;
    }

    private IMergeViewer.MergeViewerSide getSide(View view) {
        IMergeViewer.MergeViewerSide result = null;
        Match match = this.getCompareConfiguration().getComparison().getMatch((EObject)view);
        if (match.getLeft() == view) {
            result = IMergeViewer.MergeViewerSide.LEFT;
        } else if (match.getRight() == view) {
            result = IMergeViewer.MergeViewerSide.RIGHT;
        } else if (match.getOrigin() == view) {
            result = IMergeViewer.MergeViewerSide.ANCESTOR;
        }
        return this.computeSide(result);
    }

    private EObject getMatchView(EObject object, IMergeViewer.MergeViewerSide side) {
        Match match = this.getCompareConfiguration().getComparison().getMatch(object);
        return this.getMatchView(match, side);
    }

    private EObject getMatchView(Match match, IMergeViewer.MergeViewerSide side) {
        EObject result = null;
        switch (side) {
            case LEFT: {
                result = match.getLeft();
                break;
            }
            case RIGHT: {
                result = match.getRight();
                break;
            }
            case ANCESTOR: {
                result = match.getOrigin();
            }
        }
        return result;
    }

    protected void updateMirrored(boolean isMirrored) {
        this.fRefreshDecorators = true;
        super.updateMirrored(isMirrored);
    }

    protected IContentProvider getUnmirroredContentProvider() {
        return this.fContentProvider;
    }

    protected IContentProvider getMirroredContentProvider() {
        return new MirroredTreeContentMergeViewerContentProvider(this.getCompareConfiguration(), this.fContentProvider);
    }

    private abstract class AbstractDecoratorManager
    implements IDecoratorManager {
        private AbstractDecoratorManager() {
        }

        @Override
        public void hideDecorators(Diff difference) {
            Collection<? extends AbstractDecorator> oldDecorators = this.getDecorators(difference);
            if (oldDecorators != null && !oldDecorators.isEmpty() && DiagramContentMergeViewer.this.getCompareConfiguration().getComparison() != null) {
                this.handleDecorators(oldDecorators, false, true);
            }
        }

        @Override
        public void revealDecorators(Diff difference) {
            Collection<? extends AbstractDecorator> decorators = this.getDecorators(difference);
            if ((decorators == null || decorators.isEmpty()) && this.isGoodCandidate(difference)) {
                DiagramDiff diagramDiff = (DiagramDiff)difference;
                List<View> referenveViews = this.getReferenceViews(diagramDiff);
                for (View referenceView : referenveViews) {
                    AbstractDecorator decorator;
                    IFigure referenceFigure = this.getFigure(referenceView);
                    if (referenceFigure == null) continue;
                    IMergeViewer.MergeViewerSide targetSide = this.getTargetSide(DiagramContentMergeViewer.this.getCompareConfiguration().getComparison().getMatch((EObject)referenceView), referenceView);
                    if (decorators == null) {
                        decorators = new ArrayList<AbstractDecorator>();
                    }
                    if ((decorator = this.createAndRegisterDecorator(difference, referenceView, referenceFigure, targetSide)) == null) continue;
                    decorators.add(decorator);
                }
            }
            if (decorators != null && !decorators.isEmpty()) {
                this.revealDecorators(decorators);
            }
        }

        @Override
        public abstract void removeDecorators(Diff var1);

        @Override
        public abstract void removeAll();

        protected void revealDecorators(Collection<? extends AbstractDecorator> decorators) {
            this.handleDecorators(decorators, true, true);
        }

        protected IFigure getFigure(View view) {
            IMergeViewer.MergeViewerSide side = DiagramContentMergeViewer.this.getSide(view);
            GraphicalEditPart originEditPart = (GraphicalEditPart)DiagramContentMergeViewer.this.getViewer(side).getEditPart((EObject)view);
            if (originEditPart != null) {
                return originEditPart.getFigure();
            }
            return null;
        }

        protected void handleDecorators(Collection<? extends AbstractDecorator> decorators, boolean isAdd, boolean areMain) {
            for (AbstractDecorator abstractDecorator : decorators) {
                this.handleDecorator(abstractDecorator, isAdd, areMain);
            }
        }

        protected void handleDecorator(AbstractDecorator decorator, boolean isAdd, boolean isMain) {
            IFigure layer = decorator.getLayer();
            IFigure figure = decorator.getFigure();
            if (isAdd) {
                this.handleAddDecorator(decorator, layer, figure, isMain);
            } else if (layer.getChildren().contains(figure)) {
                this.handleDeleteDecorator(decorator, layer, figure);
            }
        }

        protected void handleAddDecorator(AbstractDecorator decorator, IFigure parent, IFigure toAdd, boolean isMain) {
            if (decorator.getEditPart() != null) {
                decorator.getEditPart().activate();
            }
            if (!parent.getChildren().contains(toAdd)) {
                parent.add(toAdd);
            }
        }

        protected void handleDeleteDecorator(AbstractDecorator decorator, IFigure parent, IFigure toDelete) {
            if (decorator.getEditPart() != null) {
                decorator.getEditPart().deactivate();
            }
            if (parent.getChildren().contains(toDelete)) {
                parent.remove(toDelete);
            }
        }

        private boolean isGoodCandidate(Diff difference) {
            return this.goodCandidate().apply((Object)difference);
        }

        protected IFigure getLayer(View referenceView, IMergeViewer.MergeViewerSide side) {
            Diagram referenceDiagram = referenceView.getDiagram();
            IMergeViewer.MergeViewerSide matchSide = DiagramContentMergeViewer.this.computeSide(side);
            Diagram targetDiagram = (Diagram)DiagramContentMergeViewer.this.getMatchView((EObject)referenceDiagram, matchSide);
            DiagramMergeViewer targetViewer = DiagramContentMergeViewer.this.getViewer(side);
            EditPart editPart = targetViewer.getEditPart((EObject)targetDiagram);
            if (editPart != null) {
                return LayerManager.Helper.find((EditPart)editPart).getLayer(this.getIDLayer(referenceView));
            }
            return null;
        }

        protected Object getIDLayer(View referenceView) {
            if (referenceView instanceof Edge) {
                return "Connection Layer";
            }
            return "Scalable Layers";
        }

        protected void translateCoordinates(IFigure referenceFigure, IFigure rootReferenceFigure, Rectangle boundsToTranslate) {
            IFigure referenceParentFigure = referenceFigure.getParent();
            if (referenceParentFigure != null && referenceFigure != rootReferenceFigure) {
                if (referenceParentFigure.isCoordinateSystem() && referenceParentFigure != rootReferenceFigure) {
                    boundsToTranslate.x += referenceParentFigure.getBounds().x;
                    boundsToTranslate.y += referenceParentFigure.getBounds().y;
                }
                this.translateCoordinates(referenceParentFigure, rootReferenceFigure, boundsToTranslate);
            }
        }

        protected boolean isNodeList(View view) {
            DiagramMergeViewer viewer = DiagramContentMergeViewer.this.getViewer(DiagramContentMergeViewer.this.getSide(view));
            EditPart part = viewer.getEditPart((EObject)view);
            return this.isNodeList(part);
        }

        private boolean isNodeList(EditPart part) {
            return part instanceof ListItemEditPart || this.isInListContainer(part);
        }

        private boolean isInListContainer(EditPart part) {
            EditPart parent = part.getParent();
            while (parent != null) {
                if (parent instanceof ListCompartmentEditPart) {
                    return true;
                }
                parent = parent.getParent();
            }
            return false;
        }

        protected abstract Predicate<Diff> goodCandidate();

        protected abstract List<View> getReferenceViews(DiagramDiff var1);

        protected abstract IMergeViewer.MergeViewerSide getTargetSide(Match var1, View var2);

        protected abstract AbstractDecorator createAndRegisterDecorator(Diff var1, View var2, IFigure var3, IMergeViewer.MergeViewerSide var4);

        protected abstract Collection<? extends AbstractDecorator> getDecorators(Diff var1);

        protected abstract class AbstractDecorator {
            protected View fOriginView;
            protected IFigure fOriginFigure;
            protected IFigure fFigure;
            protected DecoratorFigure fDecoratorFigure;
            protected IFigure fLayer;
            protected IMergeViewer.MergeViewerSide fSide;
            protected Diff fDifference;
            protected EditPart fEditPart;

            protected AbstractDecorator() {
            }

            public View getOriginView() {
                return this.fOriginView;
            }

            public void setOriginView(View originView) {
                this.fOriginView = originView;
            }

            public IFigure getOriginFigure() {
                return this.fOriginFigure;
            }

            public void setOriginFigure(IFigure originFigure) {
                this.fOriginFigure = originFigure;
            }

            public IFigure getFigure() {
                return this.fFigure;
            }

            public DecoratorFigure getDecoratorFigure() {
                return this.fDecoratorFigure;
            }

            public void setFigure(IFigure figure) {
                this.fFigure = figure;
            }

            public void setDecoratorFigure(DecoratorFigure figure) {
                this.fDecoratorFigure = figure;
                this.setFigure(figure.getMainFigure());
            }

            public IFigure getLayer() {
                return this.fLayer;
            }

            public void setLayer(IFigure layer) {
                this.fLayer = layer;
            }

            public IMergeViewer.MergeViewerSide getSide() {
                return this.fSide;
            }

            public void setSide(IMergeViewer.MergeViewerSide side) {
                this.fSide = side;
            }

            public Diff getDifference() {
                return this.fDifference;
            }

            public void setDifference(Diff difference) {
                this.fDifference = difference;
            }

            public EditPart getEditPart() {
                return this.fEditPart;
            }

            public void setEditPart(EditPart editPart) {
                this.fEditPart = editPart;
            }
        }
    }

    private class DecoratorsManager
    implements IDecoratorManager {
        private IDecoratorManager fPhantomManager;
        private IDecoratorManager fMarkerManager;

        private DecoratorsManager() {
            this.fPhantomManager = new PhantomManager();
            this.fMarkerManager = new MarkerManager();
        }

        @Override
        public void hideDecorators(Diff difference) {
            this.fMarkerManager.hideDecorators(difference);
            this.fPhantomManager.hideDecorators(difference);
        }

        @Override
        public void revealDecorators(Diff difference) {
            this.fMarkerManager.revealDecorators(difference);
            this.fPhantomManager.revealDecorators(difference);
        }

        @Override
        public void hideAll() {
            this.fMarkerManager.hideAll();
            this.fPhantomManager.hideAll();
        }

        @Override
        public void removeDecorators(Diff difference) {
            this.fMarkerManager.removeDecorators(difference);
            this.fPhantomManager.removeDecorators(difference);
        }

        @Override
        public void removeAll() {
            this.fMarkerManager.removeAll();
            this.fPhantomManager.removeAll();
        }
    }

    private static interface IDecoratorManager {
        public void hideAll();

        public void hideDecorators(Diff var1);

        public void revealDecorators(Diff var1);

        public void removeDecorators(Diff var1);

        public void removeAll();
    }

    private class MarkerManager
    extends AbstractDecoratorManager {
        private Multimap<Diff, Marker> fMarkerRegistry = HashMultimap.create();

        private MarkerManager() {
        }

        @Override
        protected List<View> getReferenceViews(DiagramDiff difference) {
            ArrayList<View> result = new ArrayList<View>();
            Match matchValue = DiagramContentMergeViewer.this.getCompareConfiguration().getComparison().getMatch(difference.getView());
            if (matchValue != null) {
                if (matchValue.getLeft() != null) {
                    result.add((View)matchValue.getLeft());
                }
                if (matchValue.getRight() != null) {
                    result.add((View)matchValue.getRight());
                }
                if (DiagramContentMergeViewer.this.getCompareConfiguration().getComparison().isThreeWay()) {
                    switch (difference.getKind()) {
                        case DELETE: 
                        case CHANGE: 
                        case MOVE: {
                            result.add((View)matchValue.getOrigin());
                            break;
                        }
                    }
                }
            }
            return result;
        }

        @Override
        protected IMergeViewer.MergeViewerSide getTargetSide(Match match, View referenceView) {
            return DiagramContentMergeViewer.this.getSide(referenceView);
        }

        @Override
        protected Marker createAndRegisterDecorator(Diff diff, View referenceView, IFigure referenceFigure, IMergeViewer.MergeViewerSide targetSide) {
            Marker marker = this.createMarker(diff, referenceView, referenceFigure, targetSide);
            if (marker != null) {
                this.fMarkerRegistry.put((Object)diff, (Object)marker);
            }
            return marker;
        }

        @Override
        public void removeDecorators(Diff difference) {
            this.fMarkerRegistry.removeAll((Object)difference);
        }

        @Override
        public void removeAll() {
            this.fMarkerRegistry.clear();
        }

        protected Collection<Marker> getDecorators(Diff difference) {
            return this.fMarkerRegistry.get((Object)difference);
        }

        @Override
        protected void handleAddDecorator(AbstractDecoratorManager.AbstractDecorator decorator, IFigure parent, IFigure toAdd, boolean isMain) {
            super.handleAddDecorator(decorator, parent, toAdd, isMain);
            DiagramMergeViewer viewer = DiagramContentMergeViewer.this.getViewer(decorator.getSide());
            EditPart editPart = viewer.getEditPart((EObject)decorator.getOriginView());
            if (editPart != null) {
                viewer.getGraphicalViewer().reveal(editPart);
            }
        }

        @Override
        protected Predicate<Diff> goodCandidate() {
            return new Predicate<Diff>(){

                public boolean apply(Diff difference) {
                    return Predicates.instanceOf(DiagramDiff.class).apply((Object)difference);
                }
            };
        }

        private Marker createMarker(Diff diff, View referenceView, IFigure referenceFigure, IMergeViewer.MergeViewerSide side) {
            IFigure referenceLayer = this.getLayer(referenceView, side);
            if (referenceLayer != null) {
                Rectangle referenceBounds = referenceFigure.getBounds().getCopy();
                this.translateCoordinates(referenceFigure, referenceLayer, referenceBounds);
                DecoratorFigure markerFigure = null;
                Marker marker = new Marker(referenceLayer, side, referenceView, referenceFigure, diff);
                if (this.isNodeList(referenceView)) {
                    markerFigure = new NodeListFigure(diff, DiagramContentMergeViewer.this.isThreeWay(), DiagramContentMergeViewer.this.getCompareColor(), referenceFigure, referenceBounds, false);
                } else if (referenceView instanceof Edge && referenceFigure instanceof PolylineConnection) {
                    markerFigure = new EdgeFigure(diff, DiagramContentMergeViewer.this.isThreeWay(), DiagramContentMergeViewer.this.getCompareColor(), referenceFigure, referenceBounds, false);
                }
                if (markerFigure == null) {
                    markerFigure = new NodeFigure(diff, DiagramContentMergeViewer.this.isThreeWay(), DiagramContentMergeViewer.this.getCompareColor(), referenceFigure, referenceBounds, false);
                }
                marker.setDecoratorFigure(markerFigure);
                return marker;
            }
            return null;
        }

        @Override
        public void hideAll() {
            for (Marker marker : this.fMarkerRegistry.values()) {
                this.handleDeleteDecorator(marker, marker.getLayer(), marker.getFigure());
            }
        }

        private class Marker
        extends AbstractDecoratorManager.AbstractDecorator {
            Marker(IFigure layer, IMergeViewer.MergeViewerSide side, View originView, IFigure originFigure, Diff diff) {
                this.setLayer(layer);
                this.setSide(side);
                this.setOriginView(originView);
                this.setOriginFigure(originFigure);
                this.setDifference(diff);
            }
        }
    }

    private class PhantomManager
    extends AbstractDecoratorManager {
        private final Map<Diff, Phantom> fPhantomRegistry = new HashMap<Diff, Phantom>();
        private Predicate<Diff> isAddOrDelete = Predicates.and((Predicate)Predicates.instanceOf(DiagramDiff.class), (Predicate)Predicates.or((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        private Predicate<Diff> isHideOrReveal = Predicates.or((Predicate)Predicates.instanceOf(Show.class), (Predicate)Predicates.instanceOf(Hide.class));

        private PhantomManager() {
        }

        @Override
        protected Predicate<Diff> goodCandidate() {
            return new Predicate<Diff>(){

                public boolean apply(Diff difference) {
                    return Predicates.or((Predicate)PhantomManager.this.isAddOrDelete, (Predicate)PhantomManager.this.isHideOrReveal).apply((Object)difference) && difference.getState() == DifferenceState.UNRESOLVED;
                }
            };
        }

        private List<Phantom> getOrCreateRelatedPhantoms(EObject referenceView, IMergeViewer.MergeViewerSide side) {
            ArrayList<Phantom> result = new ArrayList<Phantom>();
            Collection changes = Collections2.filter((Collection)DiagramContentMergeViewer.this.getCompareConfiguration().getComparison().getDifferences(referenceView), this.goodCandidate());
            for (Diff change : changes) {
                IFigure referenceFigure;
                Phantom phantom = this.fPhantomRegistry.get(change);
                if (phantom == null && (referenceFigure = this.getFigure((View)referenceView)) != null) {
                    phantom = this.createAndRegisterDecorator(change, (View)referenceView, referenceFigure, side);
                }
                if (phantom == null) continue;
                result.add(phantom);
            }
            return result;
        }

        @Override
        protected List<View> getReferenceViews(DiagramDiff difference) {
            View referenceView;
            ArrayList<View> result = new ArrayList<View>();
            Match match = DiagramContentMergeViewer.this.getCompareConfiguration().getComparison().getMatch(difference.getView());
            EObject originObj = match.getOrigin();
            EObject leftObj = match.getLeft();
            EObject rightObj = match.getRight();
            if ((leftObj instanceof View || rightObj instanceof View) && (referenceView = this.getReferenceView((View)originObj, (View)leftObj, (View)rightObj)) != null) {
                result.add(referenceView);
            }
            return result;
        }

        @Override
        protected IMergeViewer.MergeViewerSide getTargetSide(Match match, View referenceView) {
            IMergeViewer.MergeViewerSide targetSide = null;
            targetSide = !this.isFigureExist((View)match.getLeft()) ? IMergeViewer.MergeViewerSide.LEFT : IMergeViewer.MergeViewerSide.RIGHT;
            return targetSide;
        }

        @Override
        protected Phantom createAndRegisterDecorator(Diff diff, View referenceView, IFigure referenceFigure, IMergeViewer.MergeViewerSide targetSide) {
            Phantom phantom = this.createPhantom(diff, referenceView, referenceFigure, targetSide);
            if (phantom != null) {
                this.fPhantomRegistry.put(diff, phantom);
            }
            return phantom;
        }

        @Override
        public void removeDecorators(Diff difference) {
            this.fPhantomRegistry.remove(difference);
        }

        @Override
        public void removeAll() {
            this.fPhantomRegistry.clear();
        }

        protected List<Phantom> getDecorators(Diff difference) {
            ArrayList<Phantom> result = new ArrayList<Phantom>();
            Phantom phantom = this.fPhantomRegistry.get(difference);
            if (phantom != null) {
                result.add(phantom);
            }
            return result;
        }

        @Override
        protected void handleDecorator(AbstractDecoratorManager.AbstractDecorator decorator, boolean isAdd, boolean isMain) {
            super.handleDecorator(decorator, isAdd, isMain);
            for (AbstractDecoratorManager.AbstractDecorator abstractDecorator : ((Phantom)decorator).getDependencies()) {
                super.handleDecorator(abstractDecorator, isAdd, false);
            }
        }

        @Override
        protected void handleAddDecorator(AbstractDecoratorManager.AbstractDecorator decorator, IFigure parent, IFigure toAdd, boolean isMain) {
            super.handleAddDecorator(decorator, parent, toAdd, isMain);
            if (isMain) {
                decorator.getDecoratorFigure().highlight();
                DiagramContentMergeViewer.this.getViewer(decorator.getSide()).getGraphicalViewer().reveal(toAdd);
            } else {
                decorator.getDecoratorFigure().unhighlight();
            }
        }

        private boolean isFigureExist(View view) {
            return view != null && view.isVisible();
        }

        private View getReferenceView(View originObj, View leftView, View rightView) {
            View referenceView = this.isFigureExist(originObj) ? originObj : (this.isFigureExist(leftView) ? leftView : rightView);
            return referenceView;
        }

        private Phantom createPhantom(Diff diff, View referenceView, IFigure referenceFigure, IMergeViewer.MergeViewerSide side) {
            IMergeViewer.MergeViewerSide targetSide = DiagramContentMergeViewer.this.computeSide(side);
            IFigure targetLayer = this.getLayer(referenceView, targetSide);
            if (targetLayer != null) {
                IMergeViewer.MergeViewerSide referenceSide = DiagramContentMergeViewer.this.getSide(referenceView);
                Rectangle rect = referenceFigure.getBounds().getCopy();
                IFigure referenceLayer = this.getLayer(referenceView, referenceSide);
                this.translateCoordinates(referenceFigure, referenceLayer, rect);
                DecoratorFigure ghost = null;
                Phantom phantom = new Phantom(targetLayer, side, referenceView, referenceFigure, diff);
                if (this.isNodeList(referenceView)) {
                    int nbElements;
                    int index = this.getIndex(diff, referenceView, side);
                    IFigure referenceParentFigure = referenceFigure.getParent();
                    Rectangle referenceParentBounds = referenceParentFigure.getBounds().getCopy();
                    this.translateCoordinates(referenceParentFigure, referenceLayer, referenceParentBounds);
                    View parentView = (View)DiagramContentMergeViewer.this.getMatchView(referenceView.eContainer(), side);
                    if (parentView != null && index > (nbElements = this.getVisibleViews(parentView).size())) {
                        index = nbElements;
                    }
                    int pos = rect.height * index + referenceParentBounds.y + 1;
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("yPos", pos);
                    ghost = new NodeListFigure(diff, DiagramContentMergeViewer.this.isThreeWay(), DiagramContentMergeViewer.this.getCompareColor(), referenceFigure, rect, true, parameters);
                } else if (referenceView instanceof Edge) {
                    if (this.hasAnExtremityChange((Edge)referenceView, side)) {
                        EditPart edgeEditPart = this.createEdgeEditPart((Edge)referenceView, referenceSide, side);
                        if (edgeEditPart instanceof GraphicalEditPart) {
                            phantom.setEditPart(edgeEditPart);
                            IFigure fig = ((GraphicalEditPart)edgeEditPart).getFigure();
                            fig.getChildren().clear();
                            ghost = new DecoratorFigure(diff, DiagramContentMergeViewer.this.isThreeWay(), DiagramContentMergeViewer.this.getCompareColor(), referenceFigure, fig, true);
                        }
                    } else if (referenceFigure instanceof PolylineConnection) {
                        ghost = new EdgeFigure(diff, DiagramContentMergeViewer.this.isThreeWay(), DiagramContentMergeViewer.this.getCompareColor(), referenceFigure, rect, true);
                    }
                }
                if (ghost == null) {
                    ghost = new NodeFigure(diff, DiagramContentMergeViewer.this.isThreeWay(), DiagramContentMergeViewer.this.getCompareColor(), referenceFigure, rect, true);
                }
                phantom.setDecoratorFigure(ghost);
                this.translateWhenInsideContainerChange(phantom);
                return phantom;
            }
            return null;
        }

        private int getIndex(Diff diff, View referenceView, IMergeViewer.MergeViewerSide side) {
            if (diff instanceof Hide || diff instanceof Show) {
                List source = null;
                List target = null;
                EObject newElement = null;
                Match match = diff.getMatch();
                List leftList = ReferenceUtil.getAsList((EObject)match.getLeft().eContainer(), (EStructuralFeature)NotationPackage.Literals.VIEW__PERSISTED_CHILDREN);
                List rightList = ReferenceUtil.getAsList((EObject)match.getRight().eContainer(), (EStructuralFeature)NotationPackage.Literals.VIEW__PERSISTED_CHILDREN);
                if (diff instanceof Hide) {
                    source = rightList;
                    target = leftList;
                    newElement = diff.getMatch().getRight();
                } else {
                    source = leftList;
                    target = rightList;
                    newElement = diff.getMatch().getLeft();
                }
                Iterable ignoredElements = Iterables.filter((Iterable)target, (Predicate)new Predicate(){

                    public boolean apply(Object input) {
                        return input instanceof View && !((View)input).isVisible();
                    }
                });
                return DiffUtil.findInsertionIndex((Comparison)DiagramContentMergeViewer.this.getCompareConfiguration().getComparison(), (Iterable)ignoredElements, (List)source, (List)target, (Object)newElement);
            }
            Diff refiningDiff = (Diff)Iterators.find((Iterator)diff.getRefinedBy().iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.valueIs((Object)referenceView), (Predicate)EMFComparePredicates.onFeature((String)NotationPackage.Literals.VIEW__PERSISTED_CHILDREN.getName())));
            return DiffUtil.findInsertionIndex((Comparison)DiagramContentMergeViewer.this.getCompareConfiguration().getComparison(), (Diff)refiningDiff, (side == IMergeViewer.MergeViewerSide.LEFT ? 1 : 0) != 0);
        }

        private List<View> getVisibleViews(View parent) {
            return Lists.newArrayList((Iterator)Iterators.filter((Iterator)parent.getChildren().iterator(), (Predicate)new Predicate<Object>(){

                public boolean apply(Object input) {
                    return input instanceof View && ((View)input).isVisible();
                }
            }));
        }

        private void translateWhenInsideContainerChange(Phantom phantom) {
            View parentView;
            IFigure parentFigure;
            View referenceView;
            View parentReferenceView;
            boolean isCandidate = false;
            Diff diff = phantom.getDifference();
            if (diff instanceof DiagramDiff) {
                EObject parent = ((DiagramDiff)diff).getView().eContainer();
                while (parent instanceof View && !isCandidate) {
                    isCandidate = Iterables.any((Iterable)DiagramContentMergeViewer.this.getCompareConfiguration().getComparison().getDifferences(parent), (Predicate)Predicates.instanceOf(CoordinatesChange.class));
                    parent = parent.eContainer();
                }
            }
            if (isCandidate && (parentReferenceView = (View)(referenceView = phantom.getOriginView()).eContainer()) != null && (parentFigure = this.getFigure(parentView = (View)DiagramContentMergeViewer.this.getMatchView((EObject)parentReferenceView, phantom.getSide()))) != null) {
                Rectangle parentRect = parentFigure.getBounds().getCopy();
                this.translateCoordinates(parentFigure, this.getLayer(parentReferenceView, DiagramContentMergeViewer.this.getSide(parentView)), parentRect);
                IFigure parentReferenceFigure = this.getFigure(parentReferenceView);
                if (parentReferenceFigure != null) {
                    Rectangle parentReferenceRect = parentReferenceFigure.getBounds().getCopy();
                    this.translateCoordinates(parentReferenceFigure, this.getLayer(parentReferenceView, DiagramContentMergeViewer.this.getSide(parentReferenceView)), parentReferenceRect);
                    int deltaX = parentRect.x - parentReferenceRect.x;
                    int deltaY = parentRect.y - parentReferenceRect.y;
                    int deltaWidth = parentRect.width - parentReferenceRect.width;
                    int deltaHeight = parentRect.height - parentReferenceRect.height;
                    IFigure figure = phantom.getFigure();
                    Rectangle rect = figure.getBounds().getCopy();
                    rect.x += deltaX;
                    rect.y += deltaY;
                    rect.width += deltaWidth;
                    if (!(figure instanceof Polyline)) {
                        rect.height += deltaHeight;
                    }
                    figure.setBounds(rect);
                    if (figure instanceof Polyline) {
                        Point firstPoint = ((Polyline)figure).getPoints().getFirstPoint().getCopy();
                        Point lastPoint = ((Polyline)figure).getPoints().getLastPoint().getCopy();
                        firstPoint.x += deltaX;
                        firstPoint.y += deltaY;
                        lastPoint.x += deltaX + deltaWidth;
                        lastPoint.y += deltaY;
                        ((Polyline)figure).setEndpoints(firstPoint, lastPoint);
                    }
                }
            }
        }

        private boolean hasAnExtremityChange(Edge edge, IMergeViewer.MergeViewerSide targetSide) {
            View referenceSource = edge.getSource();
            View referenceTarget = edge.getTarget();
            return this.hasChange(referenceSource, targetSide) || this.hasChange(referenceTarget, targetSide);
        }

        private boolean hasChange(View referenceView, IMergeViewer.MergeViewerSide targetSide) {
            View extremity = (View)DiagramContentMergeViewer.this.getMatchView((EObject)referenceView, targetSide);
            Collection diffs = Collections2.filter((Collection)DiagramContentMergeViewer.this.getCompareConfiguration().getComparison().getDifferences((EObject)referenceView), (Predicate)Predicates.instanceOf(CoordinatesChange.class));
            if (diffs.isEmpty()) {
                diffs = Collections2.filter((Collection)DiagramContentMergeViewer.this.getCompareConfiguration().getComparison().getDifferences((EObject)extremity), (Predicate)Predicates.instanceOf(CoordinatesChange.class));
            }
            return !diffs.isEmpty();
        }

        private EditPart createEdgeEditPart(Edge referenceEdge, IMergeViewer.MergeViewerSide referenceSide, IMergeViewer.MergeViewerSide targetSide) {
            EditPart edgeEditPartReference = DiagramContentMergeViewer.this.getViewer(referenceSide).getEditPart((EObject)referenceEdge);
            EditPart edgeEditPart = null;
            if (edgeEditPartReference instanceof ConnectionEditPart && (edgeEditPart = this.getOrCreatePhantomEditPart((EObject)referenceEdge, referenceSide, targetSide)) instanceof ConnectionEditPart) {
                EditPart edgeSourceEp = this.getOrCreateExtremityPhantomEditPart(((ConnectionEditPart)edgeEditPartReference).getSource(), referenceSide, targetSide);
                ((ConnectionEditPart)edgeEditPart).setSource(edgeSourceEp);
                EditPart edgeTargetEp = this.getOrCreateExtremityPhantomEditPart(((ConnectionEditPart)edgeEditPartReference).getTarget(), referenceSide, targetSide);
                ((ConnectionEditPart)edgeEditPart).setTarget(edgeTargetEp);
            }
            return edgeEditPart;
        }

        private EditPart getOrCreateExtremityPhantomEditPart(EditPart referenceEdgeExtremityEp, IMergeViewer.MergeViewerSide referenceSide, IMergeViewer.MergeViewerSide targetSide) {
            View referenceExtremityView = (View)referenceEdgeExtremityEp.getModel();
            Object edgeExtremityEp = this.getOrCreatePhantomEditPart((EObject)referenceExtremityView, referenceSide, targetSide);
            if (this.isPhantomEditPart((AbstractGraphicalEditPart)edgeExtremityEp)) {
                final AbstractGraphicalEditPart edgeExtremityEpParent = (AbstractGraphicalEditPart)edgeExtremityEp.getParent();
                List<Phantom> phantoms = this.getOrCreateRelatedPhantoms((EObject)referenceExtremityView, targetSide);
                if (!phantoms.isEmpty()) {
                    Phantom phantomToTarget = phantoms.get(0);
                    final IFigure figureToTarget = phantomToTarget.getFigure();
                    edgeExtremityEp = new org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart((EObject)referenceExtremityView){

                        protected void createDefaultEditPolicies() {
                        }

                        protected IFigure createFigure() {
                            RectangleFigure fig = new RectangleFigure();
                            fig.setBounds(figureToTarget.getBounds());
                            fig.setParent(edgeExtremityEpParent.getFigure());
                            return fig;
                        }
                    };
                    edgeExtremityEp.setParent((EditPart)edgeExtremityEpParent);
                }
                ((AbstractGraphicalEditPart)edgeExtremityEp).activate();
                ((AbstractGraphicalEditPart)edgeExtremityEp).getFigure();
            }
            return edgeExtremityEp;
        }

        private boolean isPhantomEditPart(AbstractGraphicalEditPart editPart) {
            Rectangle targetBounds = editPart.getFigure().getBounds();
            return targetBounds.x == 0 && targetBounds.y == 0 && targetBounds.width == 0 && targetBounds.height == 0;
        }

        private EditPart getOrCreatePhantomEditPart(EObject referenceView, IMergeViewer.MergeViewerSide referenceSide, IMergeViewer.MergeViewerSide targetSide) {
            View viewParent;
            EditPart editPartParent = null;
            EditPart editPart = null;
            EditPart editPartReference = DiagramContentMergeViewer.this.getViewer(referenceSide).getEditPart(referenceView);
            EditPart editPartReferenceParent = editPartReference.getParent();
            Object referenceViewParent = editPartReferenceParent.getModel();
            if (!(referenceViewParent instanceof EObject)) {
                referenceViewParent = referenceView.eContainer();
            }
            if ((viewParent = (View)DiagramContentMergeViewer.this.getMatchView((EObject)referenceViewParent, targetSide)) != null) {
                editPartParent = DiagramContentMergeViewer.this.getViewer(targetSide).getEditPart((EObject)viewParent);
            }
            if (editPartParent == null) {
                editPartParent = this.getOrCreatePhantomEditPart((EObject)referenceViewParent, referenceSide, targetSide);
            }
            if (editPartParent != null) {
                View view = (View)DiagramContentMergeViewer.this.getMatchView(referenceView, targetSide);
                if (view != null) {
                    editPart = DiagramContentMergeViewer.this.getViewer(targetSide).getEditPart((EObject)view);
                }
                if (editPart == null) {
                    editPart = DiagramContentMergeViewer.this.getViewer(targetSide).getGraphicalViewer().getEditPartFactory().createEditPart(editPartParent, (Object)referenceView);
                    editPart.setParent(editPartParent);
                    DiagramContentMergeViewer.this.getViewer(targetSide).getGraphicalViewer().getEditPartRegistry().put(referenceView, editPart);
                }
            }
            return editPart;
        }

        @Override
        public void hideAll() {
            for (Phantom phantom : this.fPhantomRegistry.values()) {
                this.handleDeleteDecorator(phantom, phantom.getLayer(), phantom.getFigure());
            }
        }

        private class Phantom
        extends AbstractDecoratorManager.AbstractDecorator {
            Phantom(IFigure layer, IMergeViewer.MergeViewerSide side, View originView, IFigure originFigure, Diff diff) {
                this.setLayer(layer);
                this.setSide(side);
                this.setOriginView(originView);
                this.setOriginFigure(originFigure);
                this.setDifference(diff);
            }

            public List<? extends AbstractDecoratorManager.AbstractDecorator> getDependencies() {
                ArrayList<? extends AbstractDecoratorManager.AbstractDecorator> result = new ArrayList<AbstractDecoratorManager.AbstractDecorator>();
                result.addAll(this.getAncestors());
                if (this.fOriginView instanceof Edge) {
                    View source = ((Edge)this.fOriginView).getSource();
                    View target = ((Edge)this.fOriginView).getTarget();
                    result.addAll(PhantomManager.this.getOrCreateRelatedPhantoms((EObject)source, this.fSide));
                    result.addAll(PhantomManager.this.getOrCreateRelatedPhantoms((EObject)target, this.fSide));
                }
                return result;
            }

            private List<? extends AbstractDecoratorManager.AbstractDecorator> getAncestors() {
                ArrayList result = new ArrayList();
                EObject parentOriginView = this.fOriginView.eContainer();
                while (parentOriginView != null) {
                    result.addAll(PhantomManager.this.getOrCreateRelatedPhantoms(parentOriginView, this.fSide));
                    parentOriginView = parentOriginView.eContainer();
                }
                return result;
            }
        }
    }
}

