/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.DelegatingMerger;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

public class DiffRelationshipComputer
implements IDiffRelationshipComputer {
    protected IMerger.Registry registry;
    protected IMergeCriterion criterion;

    public DiffRelationshipComputer(IMerger.Registry registry) {
        this(registry, IMergeCriterion.NONE);
    }

    public DiffRelationshipComputer(IMerger.Registry registry, IMergeCriterion criterion) {
        this.registry = registry;
        this.criterion = criterion;
    }

    @Override
    public IMerger.Registry getMergerRegistry() {
        return this.registry;
    }

    @Override
    public void setMergerRegistry(IMerger.Registry mergerRegistry) {
        this.registry = mergerRegistry;
    }

    @Override
    public IMergeCriterion getMergeCriterion() {
        return this.criterion;
    }

    @Override
    public void setMergeCriterion(IMergeCriterion mergeCriterion) {
        this.criterion = mergeCriterion;
    }

    protected IMerger.Registry2 getMergerRegistry2() {
        if (this.registry instanceof IMerger.Registry2) {
            return (IMerger.Registry2)this.registry;
        }
        return null;
    }

    @Override
    public IMerger2 getMerger(Diff diff) {
        if (this.getMergerRegistry2() == null) {
            return null;
        }
        DelegatingMerger mergerDelegate = AbstractMerger.getMergerDelegate(diff, this.getMergerRegistry2(), this.getMergeCriterion());
        IMerger merger = mergerDelegate.getMerger();
        if (!(merger instanceof IMerger2)) {
            return null;
        }
        return (IMerger2)merger;
    }

    @Override
    public boolean hasMerger(Diff diff) {
        return this.getMerger(diff) != null;
    }

    @Override
    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        IMerger2 merger = this.getMerger(diff);
        if (merger != null) {
            return merger.getDirectMergeDependencies(diff, mergeRightToLeft);
        }
        return Sets.newHashSet();
    }

    @Override
    public Set<Diff> getDirectResultingMerges(Diff diff, boolean mergeRightToLeft) {
        IMerger2 merger = this.getMerger(diff);
        if (merger != null) {
            return merger.getDirectResultingMerges(diff, mergeRightToLeft);
        }
        return Sets.newHashSet();
    }

    @Override
    public Set<Diff> getDirectResultingRejections(Diff diff, boolean mergeRightToLeft) {
        IMerger2 merger = this.getMerger(diff);
        if (merger != null) {
            return merger.getDirectResultingRejections(diff, mergeRightToLeft);
        }
        return Sets.newHashSet();
    }

    @Override
    public Set<Diff> getAllResultingMerges(Diff diff, boolean rightToLeft) {
        LinkedHashSet<Diff> resultingMerges = new LinkedHashSet<Diff>();
        resultingMerges.add(diff);
        Set<Diff> relations = this.internalGetAllResultingMerges(diff, rightToLeft);
        Set difference = Sets.filter((Set)Sets.difference(relations, resultingMerges), (Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO)));
        while (!difference.isEmpty()) {
            LinkedHashSet newRelations = new LinkedHashSet(difference);
            resultingMerges.addAll(newRelations);
            relations = new LinkedHashSet<Diff>();
            for (Diff newRelation : newRelations) {
                Set<Diff> internalResultingMerges = this.internalGetAllResultingMerges(newRelation, rightToLeft);
                relations.addAll(Sets.filter(internalResultingMerges, (Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO))));
            }
            difference = Sets.difference(relations, resultingMerges);
        }
        if (diff.getConflict() != null && diff.getConflict().getKind() == ConflictKind.PSEUDO) {
            resultingMerges.addAll((Collection<Diff>)diff.getConflict().getDifferences());
        }
        return resultingMerges;
    }

    protected Set<Diff> internalGetAllResultingMerges(Diff diff, boolean rightToLeft) {
        Set<Diff> directParents = this.getDirectMergeDependencies(diff, rightToLeft);
        Set<Diff> directImplications = this.getDirectResultingMerges(diff, rightToLeft);
        Sets.SetView directRelated = Sets.union(directParents, directImplications);
        return directRelated;
    }

    @Override
    public Set<Diff> getAllResultingRejections(Diff diff, boolean mergeRightToLeft) {
        LinkedHashSet<Diff> resultingRejections = new LinkedHashSet<Diff>();
        Set<Diff> allResultingMerges = this.getAllResultingMerges(diff, mergeRightToLeft);
        resultingRejections.addAll(Sets.filter(allResultingMerges, (Predicate)Predicates.and((Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO)), (Predicate)Predicates.not(EMFComparePredicates.sameSideAs(diff)))));
        for (Diff resulting : Sets.filter(allResultingMerges, EMFComparePredicates.sameSideAs(diff))) {
            Set<Diff> rejections = this.getDirectResultingRejections(resulting, mergeRightToLeft);
            Set difference = Sets.filter(rejections, (Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO)));
            while (!difference.isEmpty()) {
                LinkedHashSet newRejections = new LinkedHashSet(difference);
                resultingRejections.addAll(newRejections);
                rejections = new LinkedHashSet<Diff>();
                for (Diff rejected : newRejections) {
                    Set<Diff> directMergeDependencies = this.getDirectMergeDependencies(rejected, mergeRightToLeft);
                    rejections.addAll(Sets.filter(directMergeDependencies, (Predicate)Predicates.and((Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO)), (Predicate)Predicates.not(EMFComparePredicates.sameSideAs(diff)))));
                    Set<Diff> directResultingMerges = this.getDirectResultingMerges(rejected, mergeRightToLeft);
                    rejections.addAll(Sets.filter(directResultingMerges, (Predicate)Predicates.and((Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO)), (Predicate)Predicates.not(EMFComparePredicates.sameSideAs(diff)))));
                }
                difference = Sets.difference(rejections, resultingRejections);
            }
        }
        return resultingRejections;
    }
}

