/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.command.impl;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.compare.command.DelegatingCommandStack;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.edit.provider.IDisposable;

public class CompareCommandStack
extends DelegatingCommandStack
implements ICompareCommandStack,
IDisposable {
    private final CompareSideCommandStack rightCommandStack;
    private final CompareSideCommandStack leftCommandStack;
    private final CommandStack delegate;
    private final CommandStackListener delegateCommandStackListener;

    public CompareCommandStack(CommandStack commandStack) {
        this.delegate = commandStack;
        this.delegateCommandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                CompareCommandStack.this.notifyListeners(event.getSource());
            }
        };
        this.delegate().addCommandStackListener(this.delegateCommandStackListener);
        this.rightCommandStack = new CompareSideCommandStack();
        this.leftCommandStack = new CompareSideCommandStack();
    }

    public void dispose() {
        this.delegate().removeCommandStackListener(this.delegateCommandStackListener);
    }

    @Override
    protected CommandStack delegate() {
        return this.delegate;
    }

    @Override
    public void execute(Command command) {
        if (command instanceof ICompareCopyCommand && command.canExecute()) {
            ICompareCopyCommand compareCommand = (ICompareCopyCommand)command;
            super.execute(command);
            CompareSideCommandStack commandStack = compareCommand.isLeftToRight() ? this.rightCommandStack : this.leftCommandStack;
            if (super.canUndo()) {
                commandStack.executed(compareCommand);
            } else {
                commandStack.executedWithException(compareCommand);
            }
            this.notifyListeners(this);
        }
    }

    @Override
    public void undo() {
        if (this.canUndo() && this.getUndoCommand() instanceof ICompareCopyCommand) {
            ICompareCopyCommand compareCommand = (ICompareCopyCommand)this.getUndoCommand();
            super.undo();
            CompareSideCommandStack commandStack = compareCommand.isLeftToRight() ? this.rightCommandStack : this.leftCommandStack;
            if (super.canRedo()) {
                commandStack.undone();
            } else {
                commandStack.undoneWithException();
            }
            this.notifyListeners(this);
        }
    }

    @Override
    public void redo() {
        if (this.canRedo() && this.getRedoCommand() instanceof ICompareCopyCommand) {
            ICompareCopyCommand compareCommand = (ICompareCopyCommand)this.getRedoCommand();
            super.redo();
            CompareSideCommandStack commandStack = compareCommand.isLeftToRight() ? this.rightCommandStack : this.leftCommandStack;
            if (super.canUndo()) {
                commandStack.redone();
            } else {
                commandStack.redoneWithException();
            }
            this.notifyListeners(this);
        }
    }

    @Override
    public void flush() {
        super.flush();
        this.rightCommandStack.flushed();
        this.leftCommandStack.flushed();
        this.notifyListeners(this);
    }

    @Override
    public boolean isLeftSaveNeeded() {
        return this.leftCommandStack.isSaveNeeded();
    }

    @Override
    public boolean isRightSaveNeeded() {
        return this.rightCommandStack.isSaveNeeded();
    }

    @Override
    public void leftSaveIsDone() {
        this.leftCommandStack.saveIsDone();
    }

    @Override
    public void rightSaveIsDone() {
        this.rightCommandStack.saveIsDone();
    }

    public static class CompareSideCommandStack {
        private static final int IS_SAVE_NEEDED_WILL_BE_TRUE = -2;
        private final List<ICompareCopyCommand> commandList = Lists.newArrayList();
        private int top = -1;
        private Command mostRecentCommand;
        private int saveIndex = -1;

        public void redoneWithException() {
            this.mostRecentCommand = null;
            this.commandList.subList(this.top + 1, this.commandList.size()).clear();
        }

        public void undoneWithException() {
            --this.top;
            this.mostRecentCommand = null;
            this.flushed();
        }

        public void executed(ICompareCopyCommand command) {
            if (command != null && command.canExecute()) {
                ListIterator<ICompareCopyCommand> commands = this.commandList.listIterator(this.top + 1);
                while (commands.hasNext()) {
                    commands.next();
                    commands.remove();
                }
                this.mostRecentCommand = command;
                this.commandList.add(command);
                ++this.top;
                if (this.saveIndex >= this.top) {
                    this.saveIndex = -2;
                }
            }
        }

        public void executedWithException(ICompareCopyCommand command) {
            this.mostRecentCommand = null;
        }

        public void undone() {
            Command command;
            this.mostRecentCommand = command = (Command)this.commandList.get(this.top--);
        }

        public void redone() {
            Command command;
            this.mostRecentCommand = command = (Command)this.commandList.get(++this.top);
        }

        public void flushed() {
            this.commandList.clear();
            this.top = -1;
            this.saveIndex = -1;
            this.mostRecentCommand = null;
        }

        public void saveIsDone() {
            this.saveIndex = this.top;
        }

        public boolean isSaveNeeded() {
            boolean ret;
            block7: {
                ret = false;
                if (this.saveIndex < -1) {
                    ret = true;
                }
                if (ret) break block7;
                if (this.top > this.saveIndex) {
                    int i = this.top;
                    while (!ret && i > this.saveIndex) {
                        if (!(this.commandList.get(i) instanceof AbstractCommand.NonDirtying)) {
                            ret = true;
                        }
                        --i;
                    }
                } else {
                    int i = this.saveIndex;
                    while (!ret && i > this.top) {
                        if (!(this.commandList.get(i) instanceof AbstractCommand.NonDirtying)) {
                            ret = true;
                        }
                        --i;
                    }
                }
            }
            return ret;
        }

        public Command getUndoCommand() {
            Command undoCommand = this.top == -1 || this.top == this.commandList.size() ? null : (Command)this.commandList.get(this.top);
            return undoCommand;
        }

        public Command getRedoCommand() {
            Command redoCommand = this.top + 1 >= this.commandList.size() ? null : (Command)this.commandList.get(this.top + 1);
            return redoCommand;
        }

        public Command getMostRecentCommand() {
            return this.mostRecentCommand;
        }
    }
}

