/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.scope;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.fullcomparison.data.generics.GenericsMatchInputData;
import org.eclipse.emf.compare.tests.fullcomparison.data.identifier.IdentifierMatchInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class DefaultComparisonScopeTest {
    @Test
    public void testGetRoots() throws IOException {
        IComparisonScope nullScope = DefaultComparisonScopeTest.createNullScope();
        Assert.assertNull((Object)nullScope.getLeft());
        Assert.assertNull((Object)nullScope.getRight());
        Assert.assertNull((Object)nullScope.getOrigin());
        IdentifierMatchInputData mockModel = new IdentifierMatchInputData();
        Resource leftResource = mockModel.getExtlibraryLeft();
        Resource rightResource = mockModel.getExtlibraryRight();
        Resource originResource = mockModel.getExtlibraryOrigin();
        Assert.assertNotNull((Object)leftResource);
        Assert.assertNotNull((Object)rightResource);
        Assert.assertNotNull((Object)originResource);
        TreeIterator leftContent = EcoreUtil.getAllProperContents((Resource)leftResource, (boolean)false);
        TreeIterator rightContent = EcoreUtil.getAllProperContents((Resource)rightResource, (boolean)false);
        TreeIterator originContent = EcoreUtil.getAllProperContents((Resource)originResource, (boolean)false);
        while (leftContent.hasNext() && rightContent.hasNext() && originContent.hasNext()) {
            EObject left = (EObject)leftContent.next();
            EObject right = (EObject)rightContent.next();
            EObject origin = (EObject)originContent.next();
            DefaultComparisonScope eObjectScope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
            Assert.assertSame((Object)left, (Object)eObjectScope.getLeft());
            Assert.assertSame((Object)right, (Object)eObjectScope.getRight());
            Assert.assertSame((Object)origin, (Object)eObjectScope.getOrigin());
        }
        DefaultComparisonScope resourceScope = new DefaultComparisonScope((Notifier)leftResource, (Notifier)rightResource, (Notifier)originResource);
        Assert.assertSame((Object)leftResource, (Object)resourceScope.getLeft());
        Assert.assertSame((Object)rightResource, (Object)resourceScope.getRight());
        Assert.assertSame((Object)originResource, (Object)resourceScope.getOrigin());
        ResourceSet leftRS = DefaultComparisonScopeTest.newResourceSet(leftResource);
        ResourceSet rightRS = DefaultComparisonScopeTest.newResourceSet(rightResource);
        ResourceSet originRS = DefaultComparisonScopeTest.newResourceSet(originResource);
        DefaultComparisonScope resourceSetScope = new DefaultComparisonScope((Notifier)leftRS, (Notifier)rightRS, (Notifier)originRS);
        Assert.assertSame((Object)leftRS, (Object)resourceSetScope.getLeft());
        Assert.assertSame((Object)rightRS, (Object)resourceSetScope.getRight());
        Assert.assertSame((Object)originRS, (Object)resourceSetScope.getOrigin());
    }

    @Test
    public void testGetChildrenForNull() {
        IComparisonScope nullScope = DefaultComparisonScopeTest.createNullScope();
        Assert.assertFalse((boolean)nullScope.getChildren(null).hasNext());
        Assert.assertFalse((boolean)nullScope.getCoveredEObjects(null).hasNext());
        Assert.assertFalse((boolean)nullScope.getCoveredResources(null).hasNext());
    }

    @Test
    public void testGetEObjectCHildren() throws IOException {
        IComparisonScope resourceScope = DefaultComparisonScopeTest.createResourceScope();
        Assert.assertTrue((boolean)(resourceScope.getLeft() instanceof Resource));
        Assert.assertTrue((boolean)(resourceScope.getRight() instanceof Resource));
        Assert.assertTrue((boolean)(resourceScope.getOrigin() instanceof Resource));
        Resource leftResource = (Resource)resourceScope.getLeft();
        Resource rightResource = (Resource)resourceScope.getRight();
        Resource originResource = (Resource)resourceScope.getOrigin();
        TreeIterator leftContent = EcoreUtil.getAllProperContents((Resource)leftResource, (boolean)false);
        TreeIterator rightContent = EcoreUtil.getAllProperContents((Resource)rightResource, (boolean)false);
        TreeIterator originContent = EcoreUtil.getAllProperContents((Resource)originResource, (boolean)false);
        Iterator allEObjects = Iterators.concat((Iterator)leftContent, (Iterator)rightContent, (Iterator)originContent);
        boolean empty = true;
        while (allEObjects.hasNext()) {
            empty = false;
            EObject root = (EObject)allEObjects.next();
            Iterator scopeChildren = resourceScope.getChildren(root);
            ArrayList children = Lists.newArrayList((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllProperContents((EObject)root, (boolean)false), EObject.class));
            while (scopeChildren.hasNext()) {
                Assert.assertTrue((boolean)children.remove(scopeChildren.next()));
            }
            for (EObject outOfScope : children) {
                Assert.assertTrue((boolean)(outOfScope instanceof EGenericType));
            }
        }
        Assert.assertFalse((boolean)empty);
    }

    @Test
    public void testGetResourceChildren() throws IOException {
        IComparisonScope resourceScope = DefaultComparisonScopeTest.createResourceScope();
        Assert.assertTrue((boolean)(resourceScope.getLeft() instanceof Resource));
        Assert.assertTrue((boolean)(resourceScope.getRight() instanceof Resource));
        Assert.assertTrue((boolean)(resourceScope.getOrigin() instanceof Resource));
        Resource leftResource = (Resource)resourceScope.getLeft();
        Resource rightResource = (Resource)resourceScope.getRight();
        Resource originResource = (Resource)resourceScope.getOrigin();
        Iterator scopeLeftChildren = resourceScope.getCoveredEObjects(leftResource);
        ArrayList leftChildren = Lists.newArrayList((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllProperContents((Resource)leftResource, (boolean)false), EObject.class));
        while (scopeLeftChildren.hasNext()) {
            Assert.assertTrue((boolean)leftChildren.remove(scopeLeftChildren.next()));
        }
        for (EObject outOfScope : leftChildren) {
            Assert.assertTrue((boolean)(outOfScope instanceof EGenericType));
        }
        Iterator scopeRightChildren = resourceScope.getCoveredEObjects(rightResource);
        ArrayList rightChildren = Lists.newArrayList((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllProperContents((Resource)rightResource, (boolean)false), EObject.class));
        while (scopeRightChildren.hasNext()) {
            Assert.assertTrue((boolean)rightChildren.remove(scopeRightChildren.next()));
        }
        for (EObject outOfScope : rightChildren) {
            Assert.assertTrue((boolean)(outOfScope instanceof EGenericType));
        }
        Iterator scopeOriginChildren = resourceScope.getCoveredEObjects(originResource);
        ArrayList originChildren = Lists.newArrayList((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllProperContents((Resource)originResource, (boolean)false), EObject.class));
        while (scopeOriginChildren.hasNext()) {
            Assert.assertTrue((boolean)originChildren.remove(scopeOriginChildren.next()));
        }
        for (EObject outOfScope : originChildren) {
            Assert.assertTrue((boolean)(outOfScope instanceof EGenericType));
        }
    }

    @Test
    public void testGetResourceSetChildren() throws IOException {
        IComparisonScope resourceScope = DefaultComparisonScopeTest.createResourceSetScope();
        Assert.assertTrue((boolean)(resourceScope.getLeft() instanceof ResourceSet));
        Assert.assertTrue((boolean)(resourceScope.getRight() instanceof ResourceSet));
        Assert.assertTrue((boolean)(resourceScope.getOrigin() instanceof ResourceSet));
        ResourceSet leftResourceSet = (ResourceSet)resourceScope.getLeft();
        ResourceSet rightResourceSet = (ResourceSet)resourceScope.getRight();
        ResourceSet originResourceSet = (ResourceSet)resourceScope.getOrigin();
        Iterator scopeLeftChildren = resourceScope.getCoveredResources(leftResourceSet);
        ArrayList leftChildren = Lists.newArrayList((Iterable)leftResourceSet.getResources());
        while (scopeLeftChildren.hasNext()) {
            Resource child = (Resource)scopeLeftChildren.next();
            Assert.assertTrue((boolean)leftChildren.remove(child));
        }
        Assert.assertTrue((boolean)leftChildren.isEmpty());
        Iterator scopeRightChildren = resourceScope.getCoveredResources(rightResourceSet);
        ArrayList rightChildren = Lists.newArrayList((Iterable)rightResourceSet.getResources());
        while (scopeRightChildren.hasNext()) {
            Resource child = (Resource)scopeRightChildren.next();
            Assert.assertTrue((boolean)rightChildren.remove(child));
        }
        Assert.assertTrue((boolean)rightChildren.isEmpty());
        Iterator scopeOriginChildren = resourceScope.getCoveredResources(originResourceSet);
        ArrayList originChildren = Lists.newArrayList((Iterable)originResourceSet.getResources());
        while (scopeOriginChildren.hasNext()) {
            Resource child = (Resource)scopeOriginChildren.next();
            Assert.assertTrue((boolean)originChildren.remove(child));
        }
        Assert.assertTrue((boolean)originChildren.isEmpty());
    }

    @Test
    public void testGetRootsWithGenerics() throws IOException {
        GenericsMatchInputData mockModel = new GenericsMatchInputData();
        Resource leftResource = mockModel.getLeft();
        Resource rightResource = mockModel.getRight();
        Assert.assertNotNull((Object)leftResource);
        Assert.assertNotNull((Object)rightResource);
        TreeIterator leftContent = EcoreUtil.getAllProperContents((Resource)leftResource, (boolean)false);
        TreeIterator rightContent = EcoreUtil.getAllProperContents((Resource)rightResource, (boolean)false);
        while (leftContent.hasNext() && rightContent.hasNext()) {
            EObject left = (EObject)leftContent.next();
            EObject right = (EObject)rightContent.next();
            DefaultComparisonScope eObjectScope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
            Assert.assertSame((Object)left, (Object)eObjectScope.getLeft());
            Assert.assertSame((Object)right, (Object)eObjectScope.getRight());
        }
        DefaultComparisonScope resourceScope = new DefaultComparisonScope((Notifier)leftResource, (Notifier)rightResource, null);
        Assert.assertSame((Object)leftResource, (Object)resourceScope.getLeft());
        Assert.assertSame((Object)rightResource, (Object)resourceScope.getRight());
        ResourceSet leftRS = DefaultComparisonScopeTest.newResourceSet(leftResource);
        ResourceSet rightRS = DefaultComparisonScopeTest.newResourceSet(rightResource);
        DefaultComparisonScope resourceSetScope = new DefaultComparisonScope((Notifier)leftRS, (Notifier)rightRS, null);
        Assert.assertSame((Object)leftRS, (Object)resourceSetScope.getLeft());
        Assert.assertSame((Object)rightRS, (Object)resourceSetScope.getRight());
    }

    @Test
    public void testGetEObjectChildrenWithGenerics() throws IOException {
        GenericsMatchInputData mockModel = new GenericsMatchInputData();
        Resource leftResource = mockModel.getLeft();
        Resource rightResource = mockModel.getRight();
        Assert.assertNotNull((Object)leftResource);
        Assert.assertNotNull((Object)rightResource);
        DefaultComparisonScope resourceScope = new DefaultComparisonScope((Notifier)leftResource, (Notifier)rightResource, null);
        TreeIterator leftContent = EcoreUtil.getAllProperContents((Resource)leftResource, (boolean)false);
        TreeIterator rightContent = EcoreUtil.getAllProperContents((Resource)rightResource, (boolean)false);
        Iterator allEObjects = Iterators.concat((Iterator)leftContent, (Iterator)rightContent);
        Assert.assertTrue((boolean)allEObjects.hasNext());
        while (allEObjects.hasNext()) {
            EObject root = (EObject)allEObjects.next();
            Iterator scopeChildren = resourceScope.getChildren(root);
            ArrayList children = Lists.newArrayList((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllProperContents((EObject)root, (boolean)false), EObject.class));
            while (scopeChildren.hasNext()) {
                Assert.assertTrue((boolean)children.remove(scopeChildren.next()));
            }
            for (EObject outOfScope : children) {
                Assert.assertTrue((boolean)(outOfScope instanceof EGenericType));
                Assert.assertTrue((boolean)EMFComparePredicates.IS_EGENERIC_TYPE_WITHOUT_PARAMETERS.apply((Object)outOfScope));
            }
        }
    }

    private static IComparisonScope createNullScope() {
        return new DefaultComparisonScope(null, null, null);
    }

    private static IComparisonScope createResourceScope() throws IOException {
        IdentifierMatchInputData mockModel = new IdentifierMatchInputData();
        Resource leftResource = mockModel.getExtlibraryLeft();
        Resource rightResource = mockModel.getExtlibraryRight();
        Resource originResource = mockModel.getExtlibraryOrigin();
        Assert.assertNotNull((Object)leftResource);
        Assert.assertNotNull((Object)rightResource);
        Assert.assertNotNull((Object)originResource);
        return new DefaultComparisonScope((Notifier)leftResource, (Notifier)rightResource, (Notifier)originResource);
    }

    private static IComparisonScope createResourceSetScope() throws IOException {
        IdentifierMatchInputData mockModel = new IdentifierMatchInputData();
        Resource leftResource = mockModel.getExtlibraryLeft();
        Resource rightResource = mockModel.getExtlibraryRight();
        Resource originResource = mockModel.getExtlibraryOrigin();
        Assert.assertNotNull((Object)leftResource);
        Assert.assertNotNull((Object)rightResource);
        Assert.assertNotNull((Object)originResource);
        ResourceSet leftRS = DefaultComparisonScopeTest.newResourceSet(leftResource);
        ResourceSet rightRS = DefaultComparisonScopeTest.newResourceSet(rightResource);
        ResourceSet originRS = DefaultComparisonScopeTest.newResourceSet(originResource);
        return new DefaultComparisonScope((Notifier)leftRS, (Notifier)rightRS, (Notifier)originRS);
    }

    private static ResourceSet newResourceSet(Resource ... resources) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        int i = 0;
        while (i < resources.length) {
            resourceSet.getResources().add((Object)resources[i]);
            ++i;
        }
        return resourceSet;
    }
}

