/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.merge.IMergeData;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.MatchResourceItemProvider;
import org.eclipse.emf.compare.provider.SafeAdapterFactoryItemDelegator;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;

public class MatchResourceItemProviderSpec
extends MatchResourceItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private final AdapterFactoryItemDelegator itemDelegator = new SafeAdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public MatchResourceItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    private static Predicate<ResourceAttachmentChange> uriEqualToOneAtLeast(final MatchResource matchResource) {
        return new Predicate<ResourceAttachmentChange>(){

            public boolean apply(ResourceAttachmentChange difference) {
                String diffResourceURI = difference.getResourceURI();
                return diffResourceURI != null && (diffResourceURI.equals(matchResource.getLeftURI()) || diffResourceURI.equals(matchResource.getRightURI()) || diffResourceURI.equals(matchResource.getOriginURI()));
            }
        };
    }

    public static final Predicate<ResourceAttachmentChange> uriDifferentFromAll(MatchResource matchResource) {
        return Predicates.not(MatchResourceItemProviderSpec.uriEqualToOneAtLeast(matchResource));
    }

    @Override
    public String getText(Object object) {
        String originURI;
        MatchResource matchResource = (MatchResource)object;
        String leftURI = matchResource.getLeftURI();
        String rightURI = matchResource.getRightURI();
        IMergeData mergeData = (IMergeData)EcoreUtil.getExistingAdapter((Notifier)matchResource.getComparison(), IMergeData.class);
        if (mergeData != null && mergeData.isMirrored()) {
            String effectiveLeftURI = rightURI;
            String effectiveRightURI = leftURI;
            leftURI = effectiveLeftURI;
            rightURI = effectiveRightURI;
        }
        String commonBase = this.getCommonBase(leftURI, rightURI);
        String text = "";
        if (leftURI != null) {
            text = String.valueOf(text) + leftURI.substring(commonBase.length());
        }
        text = String.valueOf(text) + " <-> ";
        if (rightURI != null) {
            text = String.valueOf(text) + rightURI.substring(commonBase.length());
        }
        if (matchResource.eContainer() instanceof Comparison && ((Comparison)matchResource.eContainer()).isThreeWay() && (originURI = matchResource.getOriginURI()) != null) {
            commonBase = this.getCommonBase(commonBase, originURI);
            text = String.valueOf(text) + " (" + originURI.substring(commonBase.length()) + ")";
        }
        return text;
    }

    @Override
    public Object getImage(Object object) {
        MatchResource matchResource = (MatchResource)object;
        Resource resource = matchResource.getLeft();
        Object image = null;
        if (resource == null && (resource = matchResource.getRight()) == null) {
            resource = matchResource.getOrigin();
        }
        if (resource != null) {
            image = this.itemDelegator.getImage((Object)resource);
            if (image == null) {
                image = super.getImage(object);
            }
        } else {
            image = super.getImage(object);
        }
        return image;
    }

    public String getCommonBase(String left, String right) {
        if (left == null || right == null) {
            return "";
        }
        char[] leftChars = left.toCharArray();
        char[] rightChars = right.toCharArray();
        StringBuilder buffer = new StringBuilder();
        StringBuilder fragmentBuffer = new StringBuilder();
        int i = 0;
        while (i < Math.min(leftChars.length, rightChars.length)) {
            if (leftChars[i] != rightChars[i]) break;
            fragmentBuffer.append(leftChars[i]);
            if (leftChars[i] == '\\' || leftChars[i] == '/') {
                buffer.append((CharSequence)fragmentBuffer);
                fragmentBuffer = new StringBuilder();
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public IStyledString.IComposedStyledString getStyledText(Object object) {
        return new ComposedStyledString(this.getText(object));
    }

    @Override
    public String getDescription(Object object) {
        return this.getText(object);
    }
}

