/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractMergerTest {
    protected Resource origin;
    protected Resource left;
    protected Resource right;
    protected Resource expected;
    protected boolean rightToLeft;
    protected IMerger.Registry mergerRegistry;
    protected Comparison comparison;

    public AbstractMergerTest(Resource origin, Resource left, Resource right, boolean rightToLeft, Resource expected, IMerger.Registry mergerRegistry) {
        this.origin = (Resource)Preconditions.checkNotNull((Object)origin);
        this.left = (Resource)Preconditions.checkNotNull((Object)left);
        this.right = (Resource)Preconditions.checkNotNull((Object)right);
        this.expected = (Resource)Preconditions.checkNotNull((Object)expected);
        this.rightToLeft = rightToLeft;
        this.mergerRegistry = (IMerger.Registry)Preconditions.checkNotNull((Object)mergerRegistry);
    }

    protected abstract List<Diff> getDiffsToMerge();

    @Test
    public void runMergeTest() {
        this.createComparison();
        List<Diff> diffsToMerge = this.getDiffsToMerge();
        this.mergeAndCompare(diffsToMerge);
    }

    protected void createComparison() {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, (Notifier)this.origin);
        this.comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
    }

    protected void mergeAndCompare(List<Diff> diffsToMerge) {
        for (Diff diff : diffsToMerge) {
            if (this.rightToLeft) {
                this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
                continue;
            }
            this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        }
        DefaultComparisonScope scope = this.rightToLeft ? new DefaultComparisonScope((Notifier)this.left, (Notifier)this.expected, null) : new DefaultComparisonScope((Notifier)this.right, (Notifier)this.expected, null);
        this.comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)this.comparison.getDifferences().size());
    }
}

