/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.command;

import java.util.EventObject;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.tests.command.MockCompareCommand;
import org.eclipse.emf.compare.tests.nodes.NodeMultipleContainment;
import org.eclipse.emf.compare.tests.nodes.NodesFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTestCompareCommandStack {
    private ICompareCommandStack commandStack;
    private MockCompareCommand leftToRight1;
    private MockCompareCommand leftToRight2;
    private MockCompareCommand leftToRight3;
    private MockCompareCommand rightToLeft1;
    private MockCompareCommand rightToLeft2;
    private MockCompareCommand rightToLeft3;
    private NodeMultipleContainment leftNode;
    private NodeMultipleContainment rightNode;

    @Before
    public void before() {
        ResourceSetImpl leftResourceSet = new ResourceSetImpl();
        ResourceImpl leftResource = new ResourceImpl(URI.createURI((String)"left.model"));
        leftResourceSet.getResources().add((Object)leftResource);
        this.leftNode = NodesFactory.eINSTANCE.createNodeMultipleContainment();
        leftResource.getContents().add((Object)this.leftNode);
        ResourceSetImpl rightResourceSet = new ResourceSetImpl();
        ResourceImpl rightResource = new ResourceImpl(URI.createURI((String)"right.model"));
        rightResourceSet.getResources().add((Object)rightResource);
        this.rightNode = NodesFactory.eINSTANCE.createNodeMultipleContainment();
        rightResource.getContents().add((Object)this.rightNode);
        this.commandStack = this.createCommandStack((ResourceSet)leftResourceSet, (ResourceSet)rightResourceSet);
        this.leftToRight1 = this.createMockCommand(true);
        this.leftToRight2 = this.createMockCommand(true);
        this.leftToRight3 = this.createMockCommand(true);
        this.rightToLeft1 = this.createMockCommand(false);
        this.rightToLeft2 = this.createMockCommand(false);
        this.rightToLeft3 = this.createMockCommand(false);
    }

    protected MockCompareCommand createMockCommand(final boolean leftToRight) {
        return new MockCompareCommand(leftToRight){

            @Override
            public void execute() {
                if (leftToRight) {
                    AbstractTestCompareCommandStack.this.rightNode.setName("rightNode " + System.nanoTime());
                } else {
                    AbstractTestCompareCommandStack.this.leftNode.setName("leftNode" + System.nanoTime());
                }
            }
        };
    }

    protected abstract ICompareCommandStack createCommandStack(ResourceSet var1, ResourceSet var2);

    protected ICompareCommandStack getCommandStack() {
        return this.commandStack;
    }

    protected final NodeMultipleContainment getLeftNode() {
        return this.leftNode;
    }

    protected final NodeMultipleContainment getRightNode() {
        return this.rightNode;
    }

    @Test
    public void testListener0() {
        final AtomicInteger changed = new AtomicInteger();
        this.commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                changed.incrementAndGet();
            }
        });
        Assert.assertEquals((long)0L, (long)changed.get());
    }

    @Test
    public void testListener1() {
        final AtomicInteger changed = new AtomicInteger();
        this.commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                if (event.getSource() == AbstractTestCompareCommandStack.this.commandStack) {
                    Assert.assertTrue((boolean)AbstractTestCompareCommandStack.this.commandStack.canUndo());
                    Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.commandStack.canRedo());
                    changed.set(Integer.MAX_VALUE);
                }
            }
        });
        this.commandStack.execute((Command)this.leftToRight1);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)changed.get());
    }

    @Test
    public void testListener2() {
        final AtomicInteger changed = new AtomicInteger();
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.commandStack.canUndo());
                Assert.assertTrue((boolean)AbstractTestCompareCommandStack.this.commandStack.canRedo());
                changed.set(Integer.MAX_VALUE);
            }
        });
        this.commandStack.undo();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)changed.get());
    }

    @Test
    public void testListener3() {
        final AtomicInteger changed = new AtomicInteger();
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        this.commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Assert.assertTrue((boolean)AbstractTestCompareCommandStack.this.commandStack.canUndo());
                Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.commandStack.canRedo());
                changed.set(Integer.MAX_VALUE);
            }
        });
        this.commandStack.redo();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)changed.get());
    }

    @Test
    public void testListener4() {
        final AtomicInteger changed = new AtomicInteger();
        this.commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.commandStack.canUndo());
                Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.commandStack.canRedo());
                changed.set(Integer.MAX_VALUE);
            }
        });
        this.commandStack.flush();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)changed.get());
    }

    @Test
    public void testListener5() {
        final AtomicInteger changed = new AtomicInteger();
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.commandStack.canUndo());
                Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.commandStack.canRedo());
                changed.set(Integer.MAX_VALUE);
            }
        });
        this.commandStack.flush();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)changed.get());
    }

    @Test
    public void testInitState() {
        Assert.assertEquals(null, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertFalse((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTROnce() {
        this.commandStack.execute((Command)this.leftToRight1);
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTROnceUndo() {
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertFalse((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTROnceUndoRedo() {
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        this.commandStack.redo();
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTRTwice() {
        this.commandStack.execute((Command)this.leftToRight2);
        this.commandStack.execute((Command)this.leftToRight1);
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTRTwiceUndo() {
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.execute((Command)this.leftToRight2);
        this.commandStack.undo();
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTRTwiceUndoTwice() {
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.execute((Command)this.leftToRight2);
        this.commandStack.undo();
        this.commandStack.undo();
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertFalse((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTRTwiceUndoTwiceRedo() {
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.execute((Command)this.leftToRight2);
        this.commandStack.undo();
        this.commandStack.undo();
        this.commandStack.redo();
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTRTwiceUndoTwiceRedoTwice() {
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.execute((Command)this.leftToRight2);
        this.commandStack.undo();
        this.commandStack.undo();
        this.commandStack.redo();
        this.commandStack.redo();
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTRTwiceUndoExecuteLTR() {
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.execute((Command)this.leftToRight2);
        this.commandStack.undo();
        this.commandStack.execute((Command)this.leftToRight3);
        Assert.assertEquals((Object)this.leftToRight3, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight3, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTRTwiceUndoExecuteLTRUndo() {
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.execute((Command)this.leftToRight2);
        this.commandStack.undo();
        this.commandStack.execute((Command)this.leftToRight3);
        this.commandStack.undo();
        Assert.assertEquals((Object)this.leftToRight3, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.leftToRight3, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLOnce() {
        this.commandStack.execute((Command)this.rightToLeft1);
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLOnceUndo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.undo();
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertFalse((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLOnceUndoRedo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.undo();
        this.commandStack.redo();
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLTwice() {
        this.commandStack.execute((Command)this.rightToLeft2);
        this.commandStack.execute((Command)this.rightToLeft1);
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLTwiceUndo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.rightToLeft2);
        this.commandStack.undo();
        Assert.assertEquals((Object)this.rightToLeft2, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.rightToLeft2, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLTwiceUndoTwice() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.rightToLeft2);
        this.commandStack.undo();
        this.commandStack.undo();
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertFalse((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLTwiceUndoTwiceRedo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.rightToLeft2);
        this.commandStack.undo();
        this.commandStack.undo();
        this.commandStack.redo();
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.rightToLeft2, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLTwiceUndoTwiceRedoTwice() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.rightToLeft2);
        this.commandStack.undo();
        this.commandStack.undo();
        this.commandStack.redo();
        this.commandStack.redo();
        Assert.assertEquals((Object)this.rightToLeft2, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft2, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLTwiceUndoExecuteRTL() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.rightToLeft2);
        this.commandStack.undo();
        this.commandStack.execute((Command)this.rightToLeft3);
        Assert.assertEquals((Object)this.rightToLeft3, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft3, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLTwiceUndoExecuteRTLUndo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.rightToLeft2);
        this.commandStack.undo();
        this.commandStack.execute((Command)this.rightToLeft3);
        this.commandStack.undo();
        Assert.assertEquals((Object)this.rightToLeft3, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.rightToLeft3, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTRExecuteRTL() {
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.execute((Command)this.rightToLeft1);
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteLTRExecuteRTLUndo() {
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.undo();
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLExecuteLTRUndo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLExecuteLTRUndoUndo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        this.commandStack.undo();
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertFalse((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLExecuteLTRUndoRedo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        this.commandStack.redo();
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLExecuteLTRUndoExecuteLTR() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        this.commandStack.execute((Command)this.leftToRight2);
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLExecuteLTRUndoExecuteRTL() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        this.commandStack.execute((Command)this.rightToLeft2);
        Assert.assertEquals((Object)this.rightToLeft2, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft2, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLExecuteLTRUndoExecuteRTLUndo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        this.commandStack.execute((Command)this.rightToLeft2);
        this.commandStack.undo();
        Assert.assertEquals((Object)this.rightToLeft2, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.rightToLeft2, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLExecuteLTRUndoExecuteRTLUndoUndo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        this.commandStack.execute((Command)this.rightToLeft2);
        this.commandStack.undo();
        this.commandStack.undo();
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertFalse((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLExecuteLTRUndoExecuteLTRUndo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        this.commandStack.execute((Command)this.leftToRight2);
        this.commandStack.undo();
        Command mostRecentCommand = this.commandStack.getMostRecentCommand();
        Assert.assertEquals((Object)this.leftToRight2, (Object)mostRecentCommand);
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertTrue((boolean)this.commandStack.canUndo());
        Assert.assertTrue((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteRTLExecuteLTRUndoExecuteLTRUndoUndo() {
        this.commandStack.execute((Command)this.rightToLeft1);
        this.commandStack.execute((Command)this.leftToRight1);
        this.commandStack.undo();
        this.commandStack.execute((Command)this.leftToRight2);
        this.commandStack.undo();
        this.commandStack.undo();
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.rightToLeft1, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.canRedo());
        Assert.assertFalse((boolean)this.commandStack.canUndo());
        Assert.assertFalse((boolean)this.commandStack.isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.commandStack.isRightSaveNeeded());
    }

    @Test
    public void testExecuteWithException() {
        MockCompareCommand command = new MockCompareCommand(true){

            @Override
            public void execute() {
                throw new IllegalStateException();
            }
        };
        this.getCommandStack().execute((Command)command);
        Assert.assertEquals(null, (Object)this.getCommandStack().getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getRedoCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getUndoCommand());
        Assert.assertFalse((boolean)this.getCommandStack().canRedo());
        Assert.assertFalse((boolean)this.getCommandStack().canUndo());
        Assert.assertFalse((boolean)this.getCommandStack().isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.getCommandStack().isRightSaveNeeded());
    }

    @Test
    public void testExecuteWithException2() {
        MockCompareCommand command = new MockCompareCommand(true){

            @Override
            public void execute() {
                AbstractTestCompareCommandStack.this.getRightNode().setName("newValue");
            }
        };
        MockCompareCommand command2 = new MockCompareCommand(true){

            @Override
            public void execute() {
                throw new IllegalStateException();
            }
        };
        this.getCommandStack().execute((Command)command);
        Assert.assertEquals((Object)"newValue", (Object)this.getRightNode().getName());
        Assert.assertEquals((Object)command, (Object)this.getCommandStack().getMostRecentCommand());
        this.getCommandStack().execute((Command)command2);
        Assert.assertEquals((Object)"newValue", (Object)this.getRightNode().getName());
        Assert.assertEquals(null, (Object)this.getCommandStack().getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getRedoCommand());
        Assert.assertEquals((Object)command, (Object)this.getCommandStack().getUndoCommand());
        Assert.assertFalse((boolean)this.getCommandStack().canRedo());
        Assert.assertTrue((boolean)this.getCommandStack().canUndo());
        Assert.assertFalse((boolean)this.getCommandStack().isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.getCommandStack().isRightSaveNeeded());
    }

    @Test
    public void testUndoWithException() {
        MockCompareCommand command = new MockCompareCommand(true){

            @Override
            public void execute() {
                AbstractTestCompareCommandStack.this.getRightNode().setName("newValue");
            }

            @Override
            public void undo() {
                throw new IllegalStateException();
            }
        };
        this.getCommandStack().execute((Command)command);
        Assert.assertEquals((Object)"newValue", (Object)this.getRightNode().getName());
        Assert.assertEquals((Object)command, (Object)this.getCommandStack().getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getRedoCommand());
        Assert.assertEquals((Object)command, (Object)this.getCommandStack().getUndoCommand());
        Assert.assertFalse((boolean)this.getCommandStack().canRedo());
        Assert.assertTrue((boolean)this.getCommandStack().canUndo());
        Assert.assertFalse((boolean)this.getCommandStack().isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.getCommandStack().isRightSaveNeeded());
        this.getCommandStack().undo();
        Assert.assertEquals((Object)"newValue", (Object)this.getRightNode().getName());
        Assert.assertEquals(null, (Object)this.getCommandStack().getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getRedoCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getUndoCommand());
        Assert.assertFalse((boolean)this.getCommandStack().canRedo());
        Assert.assertFalse((boolean)this.getCommandStack().canUndo());
        Assert.assertFalse((boolean)this.getCommandStack().isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.getCommandStack().isRightSaveNeeded());
    }

    @Test
    public void testRedoWithException() {
        MockCompareCommand command = new MockCompareCommand(true){

            @Override
            public void execute() {
                AbstractTestCompareCommandStack.this.getRightNode().setName("newValue");
            }

            @Override
            public void redo() {
                throw new IllegalStateException();
            }

            @Override
            public void undo() {
                AbstractTestCompareCommandStack.this.getRightNode().setName("undo");
            }
        };
        this.getCommandStack().execute((Command)command);
        Assert.assertEquals((Object)"newValue", (Object)this.getRightNode().getName());
        Assert.assertEquals((Object)command, (Object)this.getCommandStack().getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getRedoCommand());
        Assert.assertEquals((Object)command, (Object)this.getCommandStack().getUndoCommand());
        Assert.assertFalse((boolean)this.getCommandStack().canRedo());
        Assert.assertTrue((boolean)this.getCommandStack().canUndo());
        Assert.assertFalse((boolean)this.getCommandStack().isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.getCommandStack().isRightSaveNeeded());
        this.getCommandStack().undo();
        Assert.assertEquals((Object)"undo", (Object)this.getRightNode().getName());
        Assert.assertEquals((Object)command, (Object)this.getCommandStack().getMostRecentCommand());
        Assert.assertEquals((Object)command, (Object)this.getCommandStack().getRedoCommand());
        Assert.assertNull((Object)this.getCommandStack().getUndoCommand());
        Assert.assertTrue((boolean)this.getCommandStack().canRedo());
        Assert.assertFalse((boolean)this.getCommandStack().canUndo());
        Assert.assertFalse((boolean)this.getCommandStack().isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.getCommandStack().isRightSaveNeeded());
        this.getCommandStack().redo();
        Assert.assertEquals((Object)"undo", (Object)this.getRightNode().getName());
        Assert.assertEquals(null, (Object)this.getCommandStack().getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getRedoCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getUndoCommand());
        Assert.assertFalse((boolean)this.getCommandStack().canRedo());
        Assert.assertFalse((boolean)this.getCommandStack().canUndo());
        Assert.assertFalse((boolean)this.getCommandStack().isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.getCommandStack().isRightSaveNeeded());
    }

    @Test
    public void testListenerWithException1() {
        final AtomicInteger changed = new AtomicInteger();
        this.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.getCommandStack().canUndo());
                Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.getCommandStack().canRedo());
                Assert.assertNull((Object)AbstractTestCompareCommandStack.this.getCommandStack().getMostRecentCommand());
                changed.set(Integer.MAX_VALUE);
            }
        });
        this.getCommandStack().execute((Command)new MockCompareCommand(true){

            @Override
            public void execute() {
                throw new IllegalStateException();
            }
        });
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)changed.get());
    }

    @Test
    public void testListenerWithException2() {
        final AtomicInteger changed = new AtomicInteger();
        this.getCommandStack().execute((Command)new MockCompareCommand(true){

            @Override
            public void execute() {
                AbstractTestCompareCommandStack.this.getRightNode().setName("it will crash at undo");
            }

            @Override
            public void undo() {
                throw new IllegalStateException();
            }
        });
        this.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                if (event.getSource() == AbstractTestCompareCommandStack.this.getCommandStack()) {
                    Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.getCommandStack().canUndo());
                    Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.getCommandStack().canRedo());
                    Assert.assertNull((Object)AbstractTestCompareCommandStack.this.getCommandStack().getMostRecentCommand());
                    changed.set(Integer.MAX_VALUE);
                }
            }
        });
        this.getCommandStack().undo();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)changed.get());
    }

    @Test
    public void testListenerWithException3() {
        final AtomicInteger changed = new AtomicInteger();
        this.getCommandStack().execute((Command)new MockCompareCommand(true){

            @Override
            public void execute() {
                AbstractTestCompareCommandStack.this.getRightNode().setName("it will crash at redo");
            }

            @Override
            public void redo() {
                throw new IllegalStateException();
            }
        });
        this.getCommandStack().undo();
        this.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.getCommandStack().canUndo());
                Assert.assertFalse((boolean)AbstractTestCompareCommandStack.this.getCommandStack().canRedo());
                Assert.assertNull((Object)AbstractTestCompareCommandStack.this.getCommandStack().getMostRecentCommand());
                changed.set(Integer.MAX_VALUE);
            }
        });
        this.getCommandStack().redo();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)changed.get());
    }
}

