/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.utils;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class MatchUtilFeatureContainsTest {
    private static final int MOCK_FEATURE_ID = 1;
    List<EObject> featureList;
    InternalEObject value;
    InternalEObject container;
    EClass eClass;
    EStructuralFeature feature;

    @Before
    public void setUp() {
        EPackage ePackage = (EPackage)Mockito.mock(EPackage.class);
        this.container = (InternalEObject)Mockito.mock(InternalEObject.class);
        this.feature = (EStructuralFeature)Mockito.mock(EStructuralFeature.class);
        Mockito.when((Object)this.feature.isMany()).thenReturn((Object)true);
        this.eClass = (EClass)Mockito.mock(EClass.class);
        Mockito.when((Object)this.eClass.getEPackage()).thenReturn((Object)ePackage);
        Mockito.when((Object)this.eClass.getFeatureID(this.feature)).thenReturn((Object)1);
        Mockito.when((Object)this.container.eClass()).thenReturn((Object)this.eClass);
        Mockito.when((Object)this.feature.getEContainingClass()).thenReturn((Object)this.eClass);
        this.featureList = new LinkedList<EObject>();
        Mockito.when((Object)this.container.eGet(1, false, true)).thenReturn(this.featureList);
        this.value = this.mockInternalObject();
        this.featureList.add((EObject)this.value);
    }

    @Test
    public void test_SameObject() {
        Assert.assertTrue((boolean)MatchUtil.featureContains((EObject)this.container, (EStructuralFeature)this.feature, (Object)this.value));
    }

    @Test
    public void test_Proxy() {
        URI uri = URI.createFileURI((String)"/my/path");
        InternalEObject proxyValue = this.mockInternalObject();
        Mockito.when((Object)proxyValue.eIsProxy()).thenReturn((Object)true);
        Mockito.when((Object)proxyValue.eProxyURI()).thenReturn((Object)uri);
        Mockito.when((Object)this.value.eIsProxy()).thenReturn((Object)true);
        Mockito.when((Object)this.value.eProxyURI()).thenReturn((Object)uri);
        Assert.assertTrue((boolean)MatchUtil.featureContains((EObject)this.container, (EStructuralFeature)this.feature, (Object)proxyValue));
    }

    @Test
    public void test_DifferentObject() {
        InternalEObject otherValue = this.mockInternalObject();
        Assert.assertFalse((boolean)MatchUtil.featureContains((EObject)this.container, (EStructuralFeature)this.feature, (Object)otherValue));
    }

    private InternalEObject mockInternalObject() {
        InternalEObject internalObject = (InternalEObject)Mockito.mock(InternalEObject.class);
        Mockito.when((Object)internalObject.eClass()).thenReturn((Object)this.eClass);
        return internalObject;
    }
}

