/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.AbstractTestUITreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.MockMergeAction;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.data.tooltips.NodeTooltipsInputData;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.provider.TooltipLabelAdapterFactory;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeNodeItemProviderSpec;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TooltipProviderTest
extends AbstractTestUITreeNodeItemProviderAdapter {
    private static AdapterFactory composedAdapterFactory;
    private static TreeNodeItemProviderSpec itemProvider;
    private IMerger.Registry mergerRegistry;
    private TreeNode leftAttributeAdd;
    private TreeNode rightAttributeAdd;
    private TreeNode leftContainmentAdd;
    private TreeNode rightContainmentAdd;
    private TreeNode leftNonContainmentAdd;
    private TreeNode rightNonContainmentAdd;
    private TreeNode leftContainmentDelete;
    private TreeNode rightContainmentDelete;
    private TreeNode leftNonContainmentDelete;
    private TreeNode rightNonContainmentDelete;
    private TreeNode leftPositionMove;
    private TreeNode rightPositionMove;
    private TreeNode leftContainerMove;
    private TreeNode rightContainerMove;
    private TreeNode leftStringSet;
    private TreeNode rightStringSet;
    private TreeNode leftEmptyStringSet;
    private TreeNode rightEmptyStringSet;
    private TreeNode leftReferenceSet;
    private TreeNode rightReferenceSet;
    private TreeNode leftEmptyReferenceSet;
    private TreeNode rightEmptyReferenceSet;
    private TreeNode leftStringUnset;
    private TreeNode rightStringUnset;
    private TreeNode leftReferenceUnset;
    private TreeNode rightReferenceUnset;

    @Before
    public void before() throws IOException {
        super.before();
        ArrayList factories = Lists.newArrayList();
        factories.add(new CompareItemProviderAdapterFactorySpec());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        factories.add(this.treeItemProviderAdapterFactory);
        factories.add(new TooltipLabelAdapterFactory());
        composedAdapterFactory = new ComposedAdapterFactory((Collection)factories);
        itemProvider = (TreeNodeItemProviderSpec)this.treeItemProviderAdapterFactory.createTreeNodeAdapter();
        this.mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        NodeTooltipsInputData scopeProvider = new NodeTooltipsInputData();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)scopeProvider.getLeft(), (Notifier)scopeProvider.getRight(), (Notifier)scopeProvider.getOrigin());
        EMFCompare.Builder comparisonBuilder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(comparisonBuilder);
        Comparison comparison = comparisonBuilder.build().compare((IComparisonScope)scope);
        this.editingDomain = EMFCompareEditingDomain.create((Notifier)scopeProvider.getLeft(), (Notifier)scopeProvider.getRight(), (Notifier)scopeProvider.getOrigin());
        TreeNode root = TooltipProviderTest.getNodeRootMatch(comparison);
        TreeNode nodeSetString = (TreeNode)root.getChildren().get(0);
        this.leftStringSet = (TreeNode)((TreeNode)nodeSetString.getChildren().get(0)).getChildren().get(0);
        this.rightStringSet = (TreeNode)((TreeNode)nodeSetString.getChildren().get(1)).getChildren().get(0);
        TreeNode nodeSetFromEmptyString = (TreeNode)root.getChildren().get(1);
        this.leftEmptyStringSet = (TreeNode)((TreeNode)nodeSetFromEmptyString.getChildren().get(0)).getChildren().get(0);
        this.rightEmptyStringSet = (TreeNode)((TreeNode)nodeSetFromEmptyString.getChildren().get(1)).getChildren().get(0);
        TreeNode nodeSetReference = (TreeNode)root.getChildren().get(2);
        this.leftReferenceSet = (TreeNode)((TreeNode)nodeSetReference.getChildren().get(0)).getChildren().get(0);
        this.rightReferenceSet = (TreeNode)((TreeNode)nodeSetReference.getChildren().get(1)).getChildren().get(0);
        TreeNode nodeSetFromEmptyReference = (TreeNode)root.getChildren().get(3);
        this.leftEmptyReferenceSet = (TreeNode)((TreeNode)nodeSetFromEmptyReference.getChildren().get(0)).getChildren().get(0);
        this.rightEmptyReferenceSet = (TreeNode)((TreeNode)nodeSetFromEmptyReference.getChildren().get(1)).getChildren().get(0);
        TreeNode nodeUnsetString = (TreeNode)root.getChildren().get(4);
        this.leftStringUnset = (TreeNode)((TreeNode)nodeUnsetString.getChildren().get(0)).getChildren().get(0);
        this.rightStringUnset = (TreeNode)((TreeNode)nodeUnsetString.getChildren().get(1)).getChildren().get(0);
        TreeNode nodeUnsetRef = (TreeNode)root.getChildren().get(5);
        this.leftReferenceUnset = (TreeNode)((TreeNode)nodeUnsetRef.getChildren().get(0)).getChildren().get(0);
        this.rightReferenceUnset = (TreeNode)((TreeNode)nodeUnsetRef.getChildren().get(1)).getChildren().get(0);
        TreeNode nodeAddAttribute = (TreeNode)root.getChildren().get(6);
        this.leftAttributeAdd = (TreeNode)((TreeNode)nodeAddAttribute.getChildren().get(0)).getChildren().get(0);
        this.rightAttributeAdd = (TreeNode)((TreeNode)nodeAddAttribute.getChildren().get(1)).getChildren().get(0);
        TreeNode nodeAddRef = (TreeNode)root.getChildren().get(7);
        this.leftContainmentAdd = (TreeNode)((TreeNode)nodeAddRef.getChildren().get(2)).getChildren().get(0);
        this.rightContainmentAdd = (TreeNode)((TreeNode)nodeAddRef.getChildren().get(3)).getChildren().get(0);
        TreeNode nodeAddRefNonCont1 = (TreeNode)root.getChildren().get(8);
        this.leftNonContainmentAdd = (TreeNode)((TreeNode)nodeAddRefNonCont1.getChildren().get(0)).getChildren().get(0);
        this.rightNonContainmentAdd = (TreeNode)((TreeNode)nodeAddRefNonCont1.getChildren().get(1)).getChildren().get(0);
        TreeNode nodeDel = (TreeNode)root.getChildren().get(9);
        this.leftContainmentDelete = (TreeNode)((TreeNode)nodeDel.getChildren().get(1)).getChildren().get(0);
        this.rightContainmentDelete = (TreeNode)((TreeNode)nodeDel.getChildren().get(0)).getChildren().get(0);
        TreeNode nodeDelNonCont = (TreeNode)root.getChildren().get(10);
        this.leftNonContainmentDelete = (TreeNode)((TreeNode)nodeDelNonCont.getChildren().get(0)).getChildren().get(0);
        this.rightNonContainmentDelete = (TreeNode)((TreeNode)nodeDelNonCont.getChildren().get(1)).getChildren().get(0);
        TreeNode nodeMoveCont = (TreeNode)root.getChildren().get(11);
        this.leftContainerMove = (TreeNode)((TreeNode)nodeMoveCont.getChildren().get(1)).getChildren().get(0);
        this.rightContainerMove = (TreeNode)((TreeNode)nodeMoveCont.getChildren().get(0)).getChildren().get(0);
        TreeNode nodeMovePos = (TreeNode)root.getChildren().get(12);
        this.leftPositionMove = (TreeNode)((TreeNode)nodeMovePos.getChildren().get(0)).getChildren().get(0);
        this.rightPositionMove = (TreeNode)((TreeNode)nodeMovePos.getChildren().get(1)).getChildren().get(0);
    }

    @Test
    public void testReject() {
        String rejectChange = EMFCompareEditMessages.getString((String)"ContextualTooltip.rejectChange");
        String leftUnchanged = EMFCompareEditMessages.getString((String)"ContextualTooltip.readonly.leftUnchanged");
        String leftChanged = EMFCompareEditMessages.getString((String)"ContextualTooltip.readonly.leftChanged");
        MergeMode accept = MergeMode.REJECT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        emfCC.setAdapterFactory(composedAdapterFactory);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftStringSet));
        String toolTipText = action.getToolTipText();
        String tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.reject", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value1", "value1bis"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightStringSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.reject", (Object[])new Object[]{"value2", "singleValuedAttribute", "NodeSingleValueAttribute"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftEmptyStringSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.reject.empty", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "newValue1"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightEmptyStringSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.reject.empty", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.reject", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp1", "Node temp5"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.reject", (Object[])new Object[]{"Node temp2", "singleValuedReference", "NodeSingleValueReference"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftEmptyReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.reject.empty", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp5"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightEmptyReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.reject.empty", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftStringUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.left.reject", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value3"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightStringUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.right.reject", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value4"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftReferenceUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.left.reject", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp3"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightReferenceUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.right.reject", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp4"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftAttributeAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.attribute.left.reject", (Object[])new Object[]{"value 1", "Node Multi Valued Attribute attribute1"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightAttributeAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.attribute.right.reject", (Object[])new Object[]{"value 2", "Node Multi Valued Attribute attribute2"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.containment.left.reject", (Object[])new Object[]{"Node newNode1", "Node AddReference"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.containment.right.reject", (Object[])new Object[]{"Node newNode2", "Node AddReference"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftNonContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.nonContainment.left.reject", (Object[])new Object[]{"Node temp1"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightNonContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.nonContainment.right.reject", (Object[])new Object[]{"Node temp2"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.containment.left.reject", (Object[])new Object[]{"Node Single Value Attribute M", "Node DelContainment"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.containment.right.reject", (Object[])new Object[]{"Node Single Value Attribute N", "Node DelContainment"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftNonContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.nonContainment.left.reject", (Object[])new Object[]{"Node temp7"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightNonContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.nonContainment.right.reject", (Object[])new Object[]{"Node temp8"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainerMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.container.left.reject", (Object[])new Object[]{"Node Single Value Attribute O", "Node MoveContainerOrigin", "Node MoveContainerDestination"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainerMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.container.right.reject", (Object[])new Object[]{"Node Single Value Attribute P", "Node MoveContainerOrigin"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftPositionMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.position.left.reject", (Object[])new Object[]{"Node Q"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightPositionMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.position.right.container.reject", (Object[])new Object[]{"Node S", "Node MovePosition"});
        Assert.assertEquals((Object)this.computeTooltip(rejectChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareIDEUIMessages.getString((String)"reject.multiple.changes.tooltip");
        Assert.assertEquals((Object)tooltipBody, (Object)toolTipText);
        action.clearCache();
    }

    @Test
    public void testAccept() {
        String acceptChange = EMFCompareEditMessages.getString((String)"ContextualTooltip.acceptChange");
        String leftUnchanged = EMFCompareEditMessages.getString((String)"ContextualTooltip.readonly.leftUnchanged");
        String leftChanged = EMFCompareEditMessages.getString((String)"ContextualTooltip.readonly.leftChanged");
        MergeMode accept = MergeMode.ACCEPT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        emfCC.setAdapterFactory(composedAdapterFactory);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftStringSet));
        String toolTipText = action.getToolTipText();
        String tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.accept", (Object[])new Object[]{"value1bis", "singleValuedAttribute", "NodeSingleValueAttribute"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightStringSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.accept", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value2bis", "value2"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.accept", (Object[])new Object[]{"Node temp5", "singleValuedReference", "NodeSingleValueReference"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.accept", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp6", "Node temp2"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftEmptyReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.accept", (Object[])new Object[]{"Node temp5", "singleValuedReference", "NodeSingleValueReference"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightEmptyReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.accept.empty", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp6"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftStringUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.left.accept", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightStringUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.right.accept", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value4"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftReferenceUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.left.accept", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightReferenceUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.right.accept", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp4"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftAttributeAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.attribute.left.accept", (Object[])new Object[]{"value 1", "Node Multi Valued Attribute attribute1"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightAttributeAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.attribute.right.accept", (Object[])new Object[]{"value 2", "Node Multi Valued Attribute attribute2"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.containment.left.accept", (Object[])new Object[]{"Node newNode1", "Node AddReference"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.containment.right.accept", (Object[])new Object[]{"Node newNode2", "Node AddReference"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftNonContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.nonContainment.left.accept", (Object[])new Object[]{"Node temp1"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightNonContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.nonContainment.right.accept", (Object[])new Object[]{"Node temp2"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.containment.left.accept", (Object[])new Object[]{"Node Single Value Attribute M", "Node DelContainment"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.containment.right.accept", (Object[])new Object[]{"Node Single Value Attribute N", "Node DelContainment"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftNonContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.nonContainment.left.accept", (Object[])new Object[]{"Node temp7"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightNonContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.nonContainment.right.accept", (Object[])new Object[]{"Node temp8"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainerMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.container.left.accept", (Object[])new Object[]{"Node Single Value Attribute O", "Node MoveContainerDestination"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainerMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.container.right.accept", (Object[])new Object[]{"Node Single Value Attribute P", "Node MoveContainerDestination", "Node MoveContainerOrigin"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftPositionMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.position.left.container.accept", (Object[])new Object[]{"Node Q", "Node MovePosition"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightPositionMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.position.right.container.accept", (Object[])new Object[]{"Node S", "Node MovePosition"});
        Assert.assertEquals((Object)this.computeTooltip(acceptChange, tooltipBody, leftChanged), (Object)toolTipText);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareIDEUIMessages.getString((String)"accept.multiple.changes.tooltip");
        Assert.assertEquals((Object)tooltipBody, (Object)toolTipText);
        action.clearCache();
    }

    @Test
    public void testLeftToRight() {
        String rightChanged = EMFCompareEditMessages.getString((String)"ContextualTooltip.editable.rightChanged");
        MergeMode accept = MergeMode.LEFT_TO_RIGHT;
        boolean leftEditable = true;
        boolean rightEditable = true;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, true);
        emfCC.setAdapterFactory(composedAdapterFactory);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftStringSet));
        String toolTipText = action.getToolTipText();
        String tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.leftToRight", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value1bis", "value1"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightStringSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.leftToRight", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value2", "value2bis"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightEmptyStringSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.leftToRight.empty", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "newValue2"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.leftToRight", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp5", "Node temp1"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.leftToRight", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp2", "Node temp6"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftEmptyReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.leftToRight.empty", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp5"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightEmptyReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.leftToRight.empty", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp6"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftStringUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.left.leftToRight", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value3"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightStringUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.right.leftToRight", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value4"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftReferenceUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.left.leftToRight", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp3"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightReferenceUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.right.leftToRight", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp4"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftAttributeAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.attribute.left.leftToRight", (Object[])new Object[]{"value 1", "Node Multi Valued Attribute attribute1"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightAttributeAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.attribute.right.leftToRight", (Object[])new Object[]{"value 2", "Node Multi Valued Attribute attribute2"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.containment.left.leftToRight", (Object[])new Object[]{"Node newNode1", "Node AddReference"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.containment.right.leftToRight", (Object[])new Object[]{"Node newNode2", "Node AddReference"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftNonContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.nonContainment.left.leftToRight", (Object[])new Object[]{"Node temp1"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightNonContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.nonContainment.right.leftToRight", (Object[])new Object[]{"Node temp2"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.containment.left.leftToRight", (Object[])new Object[]{"Node Single Value Attribute M", "Node DelContainment"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.containment.right.leftToRight", (Object[])new Object[]{"Node Single Value Attribute N", "Node DelContainment"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftNonContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.nonContainment.left.leftToRight", (Object[])new Object[]{"Node temp7"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightNonContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.nonContainment.right.leftToRight", (Object[])new Object[]{"Node temp8"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainerMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.container.left.leftToRight", (Object[])new Object[]{"Node Single Value Attribute O", "Node MoveContainerDestination", "Node MoveContainerOrigin"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainerMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.container.right.leftToRight", (Object[])new Object[]{"Node Single Value Attribute P", "Node MoveContainerOrigin", "Node MoveContainerDestination"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftPositionMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.position.left.leftToRight", (Object[])new Object[]{"Node Q"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightPositionMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.position.right.leftToRight", (Object[])new Object[]{"Node S"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightChanged), (Object)toolTipText);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareIDEUIMessages.getString((String)"merged.multiple.to.right.tooltip");
        Assert.assertEquals((Object)tooltipBody, (Object)toolTipText);
        action.clearCache();
    }

    @Test
    public void testRightToLeft() {
        String rightUnchanged = EMFCompareEditMessages.getString((String)"ContextualTooltip.editable.rightUnchanged");
        MergeMode accept = MergeMode.RIGHT_TO_LEFT;
        boolean leftEditable = true;
        boolean rightEditable = true;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, true);
        emfCC.setAdapterFactory(composedAdapterFactory);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftStringSet));
        String toolTipText = action.getToolTipText();
        String tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.rightToLeft", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value1", "value1bis"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightStringSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.rightToLeft", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value2bis", "value2"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftEmptyStringSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.rightToLeft.empty", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "newValue1"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.rightToLeft", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp1", "Node temp5"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.rightToLeft", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp6", "Node temp2"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftEmptyReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.left.rightToLeft.empty", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp5"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightEmptyReferenceSet));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.set.right.rightToLeft.empty", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp6"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftStringUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.left.rightToLeft", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value3"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightStringUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.right.rightToLeft", (Object[])new Object[]{"singleValuedAttribute", "NodeSingleValueAttribute", "value4"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftReferenceUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.left.rightToLeft", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp3"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightReferenceUnset));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.unset.right.rightToLeft", (Object[])new Object[]{"singleValuedReference", "NodeSingleValueReference", "Node temp4"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftAttributeAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.attribute.left.rightToLeft", (Object[])new Object[]{"value 1", "Node Multi Valued Attribute attribute1"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightAttributeAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.attribute.right.rightToLeft", (Object[])new Object[]{"value 2", "Node Multi Valued Attribute attribute2"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.containment.left.rightToLeft", (Object[])new Object[]{"Node newNode1", "Node AddReference"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.containment.right.rightToLeft", (Object[])new Object[]{"Node newNode2", "Node AddReference"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftNonContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.nonContainment.left.rightToLeft", (Object[])new Object[]{"Node temp1"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightNonContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.add.nonContainment.right.rightToLeft", (Object[])new Object[]{"Node temp2"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.containment.left.rightToLeft", (Object[])new Object[]{"Node Single Value Attribute M", "Node DelContainment"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.containment.right.rightToLeft", (Object[])new Object[]{"Node Single Value Attribute N", "Node DelContainment"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftNonContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.nonContainment.left.rightToLeft", (Object[])new Object[]{"Node temp7"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightNonContainmentDelete));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.delete.nonContainment.right.rightToLeft", (Object[])new Object[]{"Node temp8"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainerMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.container.left.rightToLeft", (Object[])new Object[]{"Node Single Value Attribute O", "Node MoveContainerOrigin", "Node MoveContainerDestination"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightContainerMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.container.right.rightToLeft", (Object[])new Object[]{"Node Single Value Attribute P", "Node MoveContainerDestination", "Node MoveContainerOrigin"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftPositionMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.position.left.rightToLeft", (Object[])new Object[]{"Node Q"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.clearCache();
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.rightPositionMove));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareEditMessages.getString((String)"ContextualTooltip.move.position.right.rightToLeft", (Object[])new Object[]{"Node S"});
        Assert.assertEquals((Object)this.computeTooltip("", tooltipBody, rightUnchanged), (Object)toolTipText);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.leftContainmentAdd));
        toolTipText = action.getToolTipText();
        tooltipBody = EMFCompareIDEUIMessages.getString((String)"merged.multiple.to.left.tooltip");
        Assert.assertEquals((Object)tooltipBody, (Object)toolTipText);
        action.clearCache();
    }

    private static TreeNode getNodeRootMatch(Comparison comparison) throws IOException {
        TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
        treeNode.setData((EObject)comparison);
        treeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemProvider.getChildren((Object)treeNode);
        Iterable matches = Iterables.filter((Iterable)children, (Predicate)matchTreeNode);
        return (TreeNode)matches.iterator().next();
    }

    private String computeTooltip(String header, String body, String footer) {
        String separator = "\n";
        StringBuilder builder = new StringBuilder();
        if (!"".equals(header)) {
            builder.append(header);
            builder.append(separator);
        }
        builder.append(body);
        builder.append(separator);
        builder.append(footer);
        return builder.toString();
    }
}

