/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.framework.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.compare.ide.hook.IResourceSetHook;
import org.eclipse.emf.compare.ide.internal.hook.ResourceSetHookRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CompareTestSupport {
    private ResourceSet leftRS;
    private ResourceSet rightRS;
    private ResourceSet ancestorRS;
    private List<IResourceSetHook> resourceSetHooks;
    private Resource rightResource;
    private Resource leftResource;
    private Resource ancestorResource;

    public CompareTestSupport(Class<?>[] resourceSetHooks) {
        this.resourceSetHooks = new ArrayList<IResourceSetHook>(this.collectResourceSetHooks(resourceSetHooks));
    }

    protected Collection<IResourceSetHook> collectResourceSetHooks(final Class<?>[] resourceSetHookClasses) {
        ResourceSetHookRegistry hookRegistry = EMFCompareIDEPlugin.getDefault().getResourceSetHookRegistry();
        return Collections2.filter((Collection)hookRegistry.getResourceSetHooks(), (Predicate)new Predicate<IResourceSetHook>(){

            public boolean apply(IResourceSetHook hook) {
                Class[] classArray = resourceSetHookClasses;
                int n = resourceSetHookClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Class hookClass = classArray[n2];
                    if (hookClass.isAssignableFrom(hook.getClass())) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
    }

    protected void removePathmapResources(ResourceSet set) {
        ListIterator it = set.getResources().listIterator();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            if (!resource.getURI().toString().startsWith("pathmap://")) continue;
            it.remove();
        }
    }

    protected void loadResources(Class<?> clazz, String left, String right, String ancestor) throws IOException {
        this.leftRS = new ResourceSetImpl();
        this.leftResource = this.loadFromClassLoader(clazz, left, this.leftRS);
        EcoreUtil.resolveAll((ResourceSet)this.leftRS);
        this.removePathmapResources(this.leftRS);
        this.rightRS = new ResourceSetImpl();
        this.rightResource = this.loadFromClassLoader(clazz, right, this.rightRS);
        EcoreUtil.resolveAll((ResourceSet)this.rightRS);
        this.removePathmapResources(this.rightRS);
        if (!"".equals(ancestor)) {
            this.ancestorRS = new ResourceSetImpl();
            this.ancestorResource = this.loadFromClassLoader(clazz, ancestor, this.ancestorRS);
            EcoreUtil.resolveAll((ResourceSet)this.ancestorRS);
            this.removePathmapResources(this.ancestorRS);
        }
    }

    private Collection<IResourceSetHook> getMatchingHooks(final Collection<URI> uris) {
        return Collections2.filter(this.resourceSetHooks, (Predicate)new Predicate<IResourceSetHook>(){

            public boolean apply(IResourceSetHook input) {
                return input.isHookFor(uris);
            }
        });
    }

    private Collection<IResourceSetHook> getMatchingHooks(List<Resource> resources) {
        Collection uris = Collections2.transform(resources, (Function)new Function<Resource, URI>(){

            public URI apply(Resource resource) {
                return resource.getURI();
            }
        });
        return this.getMatchingHooks(uris);
    }

    private Resource loadFromClassLoader(Class<?> clazz, String path, ResourceSet resourceSet) throws IOException {
        Resource resource;
        List<URI> urisToLoad;
        block17: {
            URL fileURL = clazz.getResource(path);
            URI uri = URI.createURI((String)fileURL.toString());
            urisToLoad = Collections.singletonList(uri);
            for (IResourceSetHook hook : this.getMatchingHooks((Collection<URI>)urisToLoad)) {
                hook.preLoadingHook(resourceSet, urisToLoad);
            }
            Resource existing = resourceSet.getResource(uri, false);
            if (existing != null) {
                return existing;
            }
            InputStream stream = null;
            resource = null;
            try {
                try {
                    resource = resourceSet.createResource(uri);
                    stream = fileURL.openStream();
                    resource.load(stream, Collections.emptyMap());
                }
                catch (IOException | WrappedException throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        for (IResourceSetHook hook : this.getMatchingHooks((Collection<URI>)urisToLoad)) {
            hook.postLoadingHook(resourceSet, urisToLoad);
        }
        return resource;
    }

    public Comparison compare() {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.leftRS, (Notifier)this.rightRS, (Notifier)this.ancestorRS);
        EMFCompare.Builder comparisonBuilder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(comparisonBuilder);
        return comparisonBuilder.build().compare((IComparisonScope)scope);
    }

    protected void tearDown() {
        this.onDispose(this.leftRS);
        this.onDispose(this.rightRS);
        this.onDispose(this.ancestorRS);
    }

    protected void onDispose(ResourceSet resourceSet) {
        if (resourceSet != null) {
            for (IResourceSetHook hook : this.getMatchingHooks((List<Resource>)resourceSet.getResources())) {
                hook.onDispose((Iterable)resourceSet.getResources());
            }
        }
    }

    public Resource getLeftResource() {
        return this.leftResource;
    }

    public Resource getRightResource() {
        return this.rightResource;
    }

    public Resource getAncestorResource() {
        return this.ancestorResource;
    }

    public List<IResourceSetHook> getResourceSetHooks() {
        return this.resourceSetHooks;
    }

    public boolean isThreeWay() {
        return this.ancestorResource != null;
    }
}

