/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ScopeQuery;
import org.eclipse.emf.compare.match.eobject.internal.ByTypeIndex;
import org.eclipse.emf.compare.match.eobject.internal.MatchAheadOfTime;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProximityEObjectMatcher
implements IEObjectMatcher,
ScopeQuery {
    private static final int NB_ELEMENTS_BETWEEN_MATCH_AHEAD = 10000;
    private EObjectIndex index;
    private Map<EObject, EObjectIndex.Side> eObjectsToSide = Maps.newHashMap();

    public ProximityEObjectMatcher(DistanceFunction meter) {
        this.index = new ByTypeIndex(meter, this);
    }

    @Override
    public void createMatches(Comparison comparison, Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, Monitor monitor) {
        BasicMonitor subMonitor = new BasicMonitor();
        subMonitor.beginTask("indexing objects", 1);
        int nbElements = 0;
        int lastSegment = 0;
        while (leftEObjects.hasNext() || rightEObjects.hasNext() || originEObjects.hasNext()) {
            EObject next;
            if (leftEObjects.hasNext()) {
                next = leftEObjects.next();
                ++nbElements;
                this.index.index(next, EObjectIndex.Side.LEFT);
                this.eObjectsToSide.put(next, EObjectIndex.Side.LEFT);
            }
            if (rightEObjects.hasNext()) {
                next = rightEObjects.next();
                this.index.index(next, EObjectIndex.Side.RIGHT);
                this.eObjectsToSide.put(next, EObjectIndex.Side.RIGHT);
            }
            if (originEObjects.hasNext()) {
                next = originEObjects.next();
                this.index.index(next, EObjectIndex.Side.ORIGIN);
                this.eObjectsToSide.put(next, EObjectIndex.Side.ORIGIN);
            }
            if (nbElements / 10000 <= lastSegment) continue;
            this.matchAheadOfTime(comparison, (Monitor)subMonitor);
            ++lastSegment;
        }
        subMonitor.worked(1);
        subMonitor.done();
        subMonitor = new BasicMonitor();
        subMonitor.beginTask("matching objects", nbElements);
        this.matchIndexedObjects(comparison, (Monitor)subMonitor);
        this.createUnmatchesForRemainingObjects(comparison);
        subMonitor.done();
        this.restructureMatchModel(comparison);
    }

    private void matchAheadOfTime(Comparison comparison, Monitor monitor) {
        if (this.index instanceof MatchAheadOfTime) {
            this.matchList(comparison, ((MatchAheadOfTime)((Object)this.index)).getValuesToMatchAhead(EObjectIndex.Side.LEFT), false, monitor);
            this.matchList(comparison, ((MatchAheadOfTime)((Object)this.index)).getValuesToMatchAhead(EObjectIndex.Side.RIGHT), false, monitor);
        }
    }

    private void matchIndexedObjects(Comparison comparison, Monitor subMonitor) {
        Iterable<EObject> todo = this.index.getValuesStillThere(EObjectIndex.Side.LEFT);
        while (todo.iterator().hasNext()) {
            todo = this.matchList(comparison, todo, true, subMonitor);
        }
        todo = this.index.getValuesStillThere(EObjectIndex.Side.RIGHT);
        while (todo.iterator().hasNext()) {
            todo = this.matchList(comparison, todo, true, subMonitor);
        }
    }

    private void createUnmatchesForRemainingObjects(Comparison comparison) {
        for (EObject notFound : this.index.getValuesStillThere(EObjectIndex.Side.RIGHT)) {
            this.areMatching(comparison, null, notFound, null);
        }
        for (EObject notFound : this.index.getValuesStillThere(EObjectIndex.Side.LEFT)) {
            this.areMatching(comparison, notFound, null, null);
        }
        for (EObject notFound : this.index.getValuesStillThere(EObjectIndex.Side.ORIGIN)) {
            this.areMatching(comparison, null, null, notFound);
        }
    }

    private Iterable<EObject> matchList(Comparison comparison, Iterable<EObject> todoList, boolean createUnmatches, Monitor monitor) {
        LinkedHashSet remainingResult = Sets.newLinkedHashSet();
        ArrayList requiredContainers = Lists.newArrayList();
        for (EObject next : todoList) {
            EObject container = next.eContainer();
            while (container != null && this.isInScope(container)) {
                if (comparison.getMatch(container) == null) {
                    requiredContainers.add(0, container);
                }
                container = container.eContainer();
            }
        }
        Iterator containersAndTodo = Iterators.concat(requiredContainers.iterator(), todoList.iterator());
        while (containersAndTodo.hasNext()) {
            EObject next = (EObject)containersAndTodo.next();
            if (comparison.getMatch(next) != null || this.tryToMatch(comparison, next, createUnmatches)) continue;
            remainingResult.add(next);
            monitor.worked(1);
        }
        return remainingResult;
    }

    private boolean tryToMatch(Comparison comparison, EObject a, boolean createUnmatches) {
        boolean okToMatch = false;
        EObjectIndex.Side aSide = this.eObjectsToSide.get(a);
        assert (aSide != null);
        EObjectIndex.Side bSide = EObjectIndex.Side.LEFT;
        EObjectIndex.Side cSide = EObjectIndex.Side.RIGHT;
        if (aSide == EObjectIndex.Side.RIGHT) {
            bSide = EObjectIndex.Side.LEFT;
            cSide = EObjectIndex.Side.ORIGIN;
        } else if (aSide == EObjectIndex.Side.LEFT) {
            bSide = EObjectIndex.Side.RIGHT;
            cSide = EObjectIndex.Side.ORIGIN;
        } else if (aSide == EObjectIndex.Side.ORIGIN) {
            bSide = EObjectIndex.Side.LEFT;
            cSide = EObjectIndex.Side.RIGHT;
        }
        assert (aSide != bSide);
        assert (bSide != cSide);
        assert (cSide != aSide);
        Map<EObjectIndex.Side, EObject> closests = this.index.findClosests(comparison, a, aSide);
        if (closests != null) {
            EObject lObj = closests.get((Object)bSide);
            EObject aObj = closests.get((Object)cSide);
            if (lObj != null || aObj != null) {
                this.areMatching(comparison, closests.get((Object)EObjectIndex.Side.LEFT), closests.get((Object)EObjectIndex.Side.RIGHT), closests.get((Object)EObjectIndex.Side.ORIGIN));
                okToMatch = true;
            } else if (createUnmatches) {
                this.areMatching(comparison, closests.get((Object)EObjectIndex.Side.LEFT), closests.get((Object)EObjectIndex.Side.RIGHT), closests.get((Object)EObjectIndex.Side.ORIGIN));
                okToMatch = true;
            }
        }
        return okToMatch;
    }

    private void restructureMatchModel(Comparison comparison) {
        for (Match cur : ImmutableList.copyOf((Iterator)Iterators.filter((Iterator)comparison.eAllContents(), Match.class))) {
            Match possibleContainerMatch;
            EObject possibleContainer = null;
            if (cur.getLeft() != null) {
                possibleContainer = cur.getLeft().eContainer();
            }
            if (possibleContainer == null && cur.getRight() != null) {
                possibleContainer = cur.getRight().eContainer();
            }
            if (possibleContainer == null && cur.getOrigin() != null) {
                possibleContainer = cur.getOrigin().eContainer();
            }
            if ((possibleContainerMatch = comparison.getMatch(possibleContainer)) == null) continue;
            ((BasicEList)possibleContainerMatch.getSubmatches()).addUnique((Object)cur);
        }
    }

    private Match areMatching(Comparison comparison, EObject left, EObject right, EObject origin) {
        Match result = CompareFactory.eINSTANCE.createMatch();
        result.setLeft(left);
        result.setRight(right);
        result.setOrigin(origin);
        ((BasicEList)comparison.getMatches()).addUnique((Object)result);
        if (left != null) {
            this.index.remove(left, EObjectIndex.Side.LEFT);
        }
        if (right != null) {
            this.index.remove(right, EObjectIndex.Side.RIGHT);
        }
        if (origin != null) {
            this.index.remove(origin, EObjectIndex.Side.ORIGIN);
        }
        return result;
    }

    @Override
    public boolean isInScope(EObject eContainer) {
        return this.eObjectsToSide.get(eContainer) != null;
    }

    public static interface DistanceFunction {
        public double distance(Comparison var1, EObject var2, EObject var3);

        public boolean areIdentic(Comparison var1, EObject var2, EObject var3);
    }
}

