/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.DependencyResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.logical.Graph;
import org.eclipse.emf.compare.ide.ui.internal.logical.LogicalModelResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.RevisionedURIConverter;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.ide.utils.StorageURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectModelResolver
extends LogicalModelResolver {
    private static final String[] MODEL_CONTENT_TYPES = new String[]{"org.eclipse.emf.compare.content.type", "org.eclipse.emf.ecore", "org.eclipse.emf.ecore.xmi"};
    private Graph<URI> dependencyGraph;
    private ModelResourceListener resourceListener;

    @Override
    public void initialize() {
        super.initialize();
        this.dependencyGraph = new Graph();
        this.resourceListener = new ModelResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        this.resourceListener = null;
        this.dependencyGraph = null;
    }

    @Override
    public SynchronizationModel resolveLocalModels(IResource left, IResource right, IResource origin, IProgressMonitor monitor) {
        if (!(left instanceof IFile) || !(right instanceof IFile)) {
            return super.resolveLocalModels(left, right, origin, monitor);
        }
        this.updateChangedDependencies(monitor);
        this.updateDependencies((IFile)left, monitor);
        this.updateDependencies((IFile)right, monitor);
        if (origin instanceof IFile) {
            this.updateDependencies((IFile)origin, monitor);
        }
        ImmutableSet startingPoints = origin != null ? ImmutableSet.of((Object)((IFile)left), (Object)((IFile)right), (Object)((IFile)origin)) : ImmutableSet.of((Object)((IFile)left), (Object)((IFile)right));
        Set<IStorage> leftTraversal = this.resolveTraversal((IFile)left, (Set<IFile>)Sets.difference((Set)startingPoints, Collections.singleton(left)), monitor);
        Set<IStorage> rightTraversal = this.resolveTraversal((IFile)right, (Set<IFile>)Sets.difference((Set)startingPoints, Collections.singleton(right)), monitor);
        Set<Object> originTraversal = origin instanceof IFile ? this.resolveTraversal((IFile)origin, (Set<IFile>)Sets.difference((Set)startingPoints, Collections.singleton(origin)), monitor) : Collections.emptySet();
        Sets.SetView intersection = Sets.intersection(leftTraversal, rightTraversal);
        if (!originTraversal.isEmpty()) {
            intersection = Sets.intersection((Set)intersection, originTraversal);
        }
        this.logCoherenceThreats((Set<IFile>)startingPoints, (Set<IStorage>)intersection);
        LinkedHashSet actualLeft = Sets.newLinkedHashSet((Iterable)Sets.difference(leftTraversal, (Set)intersection));
        LinkedHashSet actualRight = Sets.newLinkedHashSet((Iterable)Sets.difference(rightTraversal, (Set)intersection));
        LinkedHashSet actualOrigin = Sets.newLinkedHashSet((Iterable)Sets.difference(originTraversal, (Set)intersection));
        return new SynchronizationModel(new StorageTraversal((Set)actualLeft), new StorageTraversal((Set)actualRight), new StorageTraversal((Set)actualOrigin));
    }

    private void logCoherenceThreats(Set<IFile> startingPoints, Set<IStorage> removedFromModel) {
        LinkedHashSet<URI> coherenceThreats = new LinkedHashSet<URI>();
        for (IStorage iStorage : startingPoints) {
            URI startURI = ResourceUtil.createURIFor((IStorage)iStorage);
            for (IStorage removed : removedFromModel) {
                URI removedURI = ResourceUtil.createURIFor((IStorage)removed);
                if (!this.dependencyGraph.hasChild(removedURI, startURI)) continue;
                coherenceThreats.add(removedURI);
            }
        }
        if (!coherenceThreats.isEmpty()) {
            String string = EMFCompareIDEUIMessages.getString("ModelResolver.coherenceWarning");
            String details = Iterables.toString(coherenceThreats);
            EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.ide.ui", String.valueOf(string) + '\n' + details));
        }
    }

    @Override
    public SynchronizationModel resolveModels(IStorageProviderAccessor storageAccessor, IStorage left, IStorage right, IStorage origin, IProgressMonitor monitor) {
        IFile leftFile = PlatformElementUtil.adaptAs(left, IFile.class);
        if (leftFile == null) {
            return super.resolveModels(storageAccessor, (IStorage)leftFile, right, origin, monitor);
        }
        this.updateChangedDependencies(monitor);
        this.updateDependencies(leftFile, storageAccessor, monitor);
        Set<IStorage> leftTraversal = this.resolveLocalTraversal(storageAccessor, leftFile, monitor);
        Set<IStorage> rightTraversal = this.resolveTraversal(storageAccessor, IStorageProviderAccessor.DiffSide.REMOTE, leftTraversal, monitor);
        Set<Object> originTraversal = origin != null ? this.resolveTraversal(storageAccessor, IStorageProviderAccessor.DiffSide.ORIGIN, leftTraversal, monitor) : Collections.emptySet();
        return new SynchronizationModel(new StorageTraversal(leftTraversal), new StorageTraversal(rightTraversal), new StorageTraversal(originTraversal));
    }

    @Override
    public StorageTraversal resolveLocalModel(IResource start, IProgressMonitor monitor) {
        if (!(start instanceof IFile)) {
            return super.resolveLocalModel(start, monitor);
        }
        this.updateChangedDependencies(monitor);
        this.updateDependencies((IFile)start, monitor);
        return new StorageTraversal(this.resolveTraversal((IFile)start, monitor));
    }

    @Override
    public boolean canResolve(IStorage sourceStorage) {
        if (sourceStorage instanceof IFile) {
            IFile file = (IFile)sourceStorage;
            return file.getProject().isAccessible() && ((IFile)sourceStorage).exists();
        }
        return false;
    }

    private void updateDependencies(IFile file, IProgressMonitor monitor) {
        URI startURI = ResourceUtil.createURIFor((IFile)file);
        if (!this.dependencyGraph.contains(startURI)) {
            IProject project = file.getProject();
            ModelResourceVisitor modelVisitor = new ModelResourceVisitor(this.dependencyGraph, monitor);
            try {
                project.accept((IResourceVisitor)modelVisitor);
            }
            catch (CoreException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    private void updateDependencies(IFile file, IStorageProviderAccessor storageAccessor, IProgressMonitor monitor) {
        URI leftURI = ResourceUtil.createURIFor((IFile)file);
        if (!this.dependencyGraph.contains(leftURI)) {
            IProject project = file.getProject();
            ModelResourceVisitor modelVisitor = new ModelResourceVisitor(storageAccessor, IStorageProviderAccessor.DiffSide.SOURCE, this.dependencyGraph, monitor);
            try {
                project.accept((IResourceVisitor)modelVisitor);
            }
            catch (CoreException coreException) {}
        }
    }

    private void updateChangedDependencies(IProgressMonitor monitor) {
        Set<URI> removedURIs = this.resourceListener.popRemovedURIs();
        Sets.SetView changedURIs = Sets.difference(this.resourceListener.popChangedURIs(), removedURIs);
        for (URI removed : removedURIs) {
            this.dependencyGraph.remove(removed);
        }
        for (URI changed : changedURIs) {
            this.dependencyGraph.remove(changed);
            IFile file = this.getFileAt(changed);
            this.updateDependencies(file, monitor);
        }
    }

    protected static final boolean hasModelType(IFile file) {
        boolean isModel = false;
        int i = 0;
        while (i < MODEL_CONTENT_TYPES.length && !isModel) {
            isModel = ResourceUtil.hasContentType((IFile)file, (String)MODEL_CONTENT_TYPES[i]);
            ++i;
        }
        return isModel;
    }

    private Set<IStorage> resolveTraversal(IFile resource, IProgressMonitor monitor) {
        LinkedHashSet<IStorage> traversal = new LinkedHashSet<IStorage>();
        URI startURI = ResourceUtil.createURIFor((IFile)resource);
        Iterable<URI> uris = this.dependencyGraph.getSubgraphOf(startURI);
        for (URI uri : uris) {
            traversal.add((IStorage)this.getFileAt(uri));
        }
        return traversal;
    }

    private Set<IStorage> resolveLocalTraversal(IStorageProviderAccessor storageAccessor, IFile resource, IProgressMonitor monitor) {
        LinkedHashSet<IStorage> traversal = new LinkedHashSet<IStorage>();
        URI startURI = ResourceUtil.createURIFor((IFile)resource);
        Iterable<URI> uris = this.dependencyGraph.getSubgraphOf(startURI);
        for (URI uri : uris) {
            IFile file = this.getFileAt(uri);
            try {
                if (storageAccessor.isInSync((IResource)file)) continue;
                traversal.add((IStorage)file);
            }
            catch (CoreException coreException) {}
        }
        return traversal;
    }

    private Set<IStorage> resolveTraversal(IFile resource, Set<IFile> bounds, IProgressMonitor monitor) {
        LinkedHashSet<IStorage> traversal = new LinkedHashSet<IStorage>();
        URI startURI = ResourceUtil.createURIFor((IFile)resource);
        LinkedHashSet<URI> uriBounds = new LinkedHashSet<URI>(bounds.size());
        for (IFile bound : bounds) {
            uriBounds.add(ResourceUtil.createURIFor((IFile)bound));
        }
        Iterable<URI> uris = this.dependencyGraph.getBoundedSubgraphOf(startURI, uriBounds);
        for (URI uri : uris) {
            traversal.add((IStorage)this.getFileAt(uri));
        }
        return traversal;
    }

    private IFile getFileAt(URI uri) {
        StringBuilder path = new StringBuilder();
        List segments = uri.segmentsList();
        if (uri.isPlatformResource()) {
            segments = segments.subList(1, segments.size());
        }
        for (String segment : segments) {
            path.append(URI.decode((String)segment)).append('/');
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path.toString()));
    }

    private Set<IStorage> resolveTraversal(IStorageProviderAccessor storageAccessor, IStorageProviderAccessor.DiffSide side, Set<IStorage> localTraversal, IProgressMonitor monitor) {
        DependencyResourceSet resourceSet = new DependencyResourceSet(this.dependencyGraph);
        RevisionedURIConverter converter = new RevisionedURIConverter(resourceSet.getURIConverter(), storageAccessor, side);
        resourceSet.setURIConverter((URIConverter)converter);
        LinkedHashSet storages = Sets.newLinkedHashSet();
        for (IStorage local : localTraversal) {
            IFile localFile = PlatformElementUtil.adaptAs(local, IFile.class);
            try {
                IStorage start;
                IStorageProvider remoteStorageProvider = storageAccessor.getStorageProvider((IResource)localFile, side);
                if (remoteStorageProvider == null || !resourceSet.resolveAll(start = remoteStorageProvider.getStorage(monitor), monitor)) continue;
                if (!this.contains(storages, start)) {
                    storages.add(start);
                }
                for (IStorage loaded : converter.getLoadedRevisions()) {
                    if (this.contains(storages, loaded)) continue;
                    storages.add(loaded);
                }
            }
            catch (CoreException coreException) {}
        }
        return storages;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelResourceListener
    implements IResourceChangeListener {
        protected Set<URI> changedURIs = new LinkedHashSet<URI>();
        protected Set<URI> removedURIs = new LinkedHashSet<URI>();

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                delta.accept((IResourceDeltaVisitor)new ModelResourceDeltaVisitor());
            }
            catch (CoreException e) {
                EMFCompareIDEUIPlugin.getDefault().log(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<URI> popChangedURIs() {
            ImmutableSet changed;
            Set<URI> set = this.changedURIs;
            synchronized (set) {
                changed = ImmutableSet.copyOf(this.changedURIs);
                this.changedURIs.clear();
            }
            return changed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<URI> popRemovedURIs() {
            ImmutableSet removed;
            Set<URI> set = this.removedURIs;
            synchronized (set) {
                removed = ImmutableSet.copyOf(this.removedURIs);
                this.removedURIs.clear();
            }
            return removed;
        }

        private class ModelResourceDeltaVisitor
        implements IResourceDeltaVisitor {
            private ModelResourceDeltaVisitor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean visit(IResourceDelta delta) throws CoreException {
                if (delta.getFlags() == 131072 || delta.getResource().getType() != 1) {
                    return true;
                }
                IFile file = (IFile)delta.getResource();
                URI fileURI = ResourceUtil.createURIFor((IFile)file);
                if (delta.getKind() == 2) {
                    Set<URI> set = ModelResourceListener.this.removedURIs;
                    synchronized (set) {
                        ModelResourceListener.this.removedURIs.add(fileURI);
                    }
                }
                if (ProjectModelResolver.hasModelType(file) && (delta.getKind() & 5) != 0) {
                    Set<URI> set = ModelResourceListener.this.changedURIs;
                    synchronized (set) {
                        ModelResourceListener.this.changedURIs.add(fileURI);
                    }
                }
                return true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelResourceVisitor
    implements IResourceVisitor {
        private final DependencyResourceSet resourceSet;
        private final IProgressMonitor monitor;

        public ModelResourceVisitor(Graph<URI> graph, IProgressMonitor monitor) {
            this.resourceSet = new DependencyResourceSet(graph);
            this.monitor = monitor;
            StorageURIConverter converter = new StorageURIConverter(this.resourceSet.getURIConverter());
            this.resourceSet.setURIConverter((URIConverter)converter);
        }

        public ModelResourceVisitor(IStorageProviderAccessor storageAccessor, IStorageProviderAccessor.DiffSide side, Graph<URI> graph, IProgressMonitor monitor) {
            this.resourceSet = new DependencyResourceSet(graph);
            this.monitor = monitor;
            RevisionedURIConverter converter = new RevisionedURIConverter(this.resourceSet.getURIConverter(), storageAccessor, side);
            this.resourceSet.setURIConverter((URIConverter)converter);
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (ProjectModelResolver.hasModelType(file)) {
                    this.resourceSet.resolveAll((IStorage)file, this.monitor);
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

