/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.command.impl;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.compare.command.DelegatingCommandStack;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;

public class CompareCommandStack
extends DelegatingCommandStack
implements ICompareCommandStack {
    private final CompareSideCommandStack rightCommandStack;
    private final CompareSideCommandStack leftCommandStack;
    private final CommandStack delegate;

    public CompareCommandStack(CommandStack commandStack) {
        this.delegate = commandStack;
        this.rightCommandStack = new CompareSideCommandStack();
        this.leftCommandStack = new CompareSideCommandStack();
    }

    protected CommandStack delegate() {
        return this.delegate;
    }

    public void execute(Command command) {
        if (command instanceof ICompareCopyCommand) {
            ICompareCopyCommand compareCommand = (ICompareCopyCommand)command;
            if (compareCommand.isLeftToRight()) {
                this.rightCommandStack.executed(compareCommand);
            } else {
                this.leftCommandStack.executed(compareCommand);
            }
        }
        super.execute(command);
    }

    public void undo() {
        if (this.canUndo() && this.getUndoCommand() instanceof ICompareCopyCommand) {
            ICompareCopyCommand compareCommand = (ICompareCopyCommand)this.getUndoCommand();
            if (compareCommand.isLeftToRight()) {
                this.rightCommandStack.undone();
            } else {
                this.leftCommandStack.undone();
            }
        }
        super.undo();
    }

    public void redo() {
        if (this.canRedo() && this.getRedoCommand() instanceof ICompareCopyCommand) {
            ICompareCopyCommand compareCommand = (ICompareCopyCommand)this.getRedoCommand();
            if (compareCommand.isLeftToRight()) {
                this.rightCommandStack.redone();
            } else {
                this.leftCommandStack.redone();
            }
        }
        super.redo();
    }

    public void flush() {
        this.rightCommandStack.flushed();
        this.leftCommandStack.flushed();
        super.flush();
    }

    public boolean isLeftSaveNeeded() {
        return this.leftCommandStack.isSaveNeeded();
    }

    public boolean isRightSaveNeeded() {
        return this.rightCommandStack.isSaveNeeded();
    }

    public void leftSaveIsDone() {
        this.leftCommandStack.saveIsDone();
    }

    public void rightSaveIsDone() {
        this.rightCommandStack.saveIsDone();
    }

    public static class CompareSideCommandStack {
        private static final int IS_SAVE_NEEDED_WILL_BE_TRUE = -2;
        private final List<ICompareCopyCommand> commandList = Lists.newArrayList();
        private int top = -1;
        private Command mostRecentCommand;
        private int saveIndex = -1;

        public void executed(ICompareCopyCommand command) {
            if (command != null && command.canExecute()) {
                ListIterator<ICompareCopyCommand> commands = this.commandList.listIterator(this.top + 1);
                while (commands.hasNext()) {
                    commands.next();
                    commands.remove();
                }
                this.mostRecentCommand = command;
                this.commandList.add(command);
                ++this.top;
                if (this.saveIndex >= this.top) {
                    this.saveIndex = -2;
                }
            }
        }

        public void undone() {
            Command command;
            this.mostRecentCommand = command = (Command)this.commandList.get(this.top--);
        }

        public void redone() {
            Command command;
            this.mostRecentCommand = command = (Command)this.commandList.get(++this.top);
        }

        public void flushed() {
            ListIterator<ICompareCopyCommand> commands = this.commandList.listIterator();
            while (commands.hasNext()) {
                commands.next();
                commands.remove();
            }
            this.commandList.clear();
            this.top = -1;
            this.saveIndex = -1;
            this.mostRecentCommand = null;
        }

        public void saveIsDone() {
            this.saveIndex = this.top;
        }

        public boolean isSaveNeeded() {
            boolean ret;
            block7: {
                ret = false;
                if (this.saveIndex < -1) {
                    ret = true;
                }
                if (ret) break block7;
                if (this.top > this.saveIndex) {
                    int i = this.top;
                    while (!ret && i > this.saveIndex) {
                        if (!(this.commandList.get(i) instanceof AbstractCommand.NonDirtying)) {
                            ret = true;
                        }
                        --i;
                    }
                } else {
                    int i = this.saveIndex;
                    while (!ret && i > this.top) {
                        if (!(this.commandList.get(i) instanceof AbstractCommand.NonDirtying)) {
                            ret = true;
                        }
                        --i;
                    }
                }
            }
            return ret;
        }

        public Command getUndoCommand() {
            Command undoCommand = this.top == -1 || this.top == this.commandList.size() ? null : (Command)this.commandList.get(this.top);
            return undoCommand;
        }

        public Command getRedoCommand() {
            Command redoCommand = this.top + 1 >= this.commandList.size() ? null : (Command)this.commandList.get(this.top + 1);
            return redoCommand;
        }

        public Command getMostRecentCommand() {
            return this.mostRecentCommand;
        }
    }
}

