/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.utils;

import org.eclipse.emf.common.util.URI;

public interface IStyledString {
    public String getString();

    public Style getStyle();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IComposedStyledString
    extends Iterable<IStyledString> {
        public IComposedStyledString append(String var1);

        public IComposedStyledString append(String var1, Style var2);

        public String getString();
    }

    public static final class Style {
        public static final Style NO_STYLE = new Style(null, null, null, false, null, null, null, null, null);
        public static final Style QUALIFIER_STYLER = new Style(null, null, null, false, null, null, null, null, null);
        public static final Style COUNTER_STYLER = new Style(null, null, null, false, null, null, null, null, null);
        public static final Style DECORATIONS_STYLER = new Style(null, null, null, false, null, null, null, null, null);
        private final URI font;
        private final URI backgroundColor;
        private final URI foregroundColor;
        private final boolean isStrikedout;
        private final URI strikeoutColor;
        private final UnderLineStyle underlineStyle;
        private final URI underlineColor;
        private final BorderStyle borderStyle;
        private final URI borderColor;

        private Style(URI font, URI backgroundColor, URI foregroundColor, boolean isStrikedout, URI strikeoutColor, UnderLineStyle underlineStyle, URI underlineColor, BorderStyle borderStyle, URI borderColor) {
            this.font = font;
            this.backgroundColor = backgroundColor;
            this.foregroundColor = foregroundColor;
            this.isStrikedout = isStrikedout;
            this.strikeoutColor = strikeoutColor;
            this.underlineStyle = underlineStyle;
            this.underlineColor = underlineColor;
            this.borderStyle = borderStyle;
            this.borderColor = borderColor;
        }

        public URI getFont() {
            return this.font;
        }

        public URI getBackgoundColor() {
            return this.backgroundColor;
        }

        public URI getForegroundColor() {
            return this.foregroundColor;
        }

        public boolean isStrikedout() {
            return this.isStrikedout;
        }

        public URI getStrikeoutColor() {
            return this.strikeoutColor;
        }

        public UnderLineStyle getUnderlineStyle() {
            return this.underlineStyle;
        }

        public URI getUnderlineColor() {
            return this.underlineColor;
        }

        public BorderStyle getBorderStyle() {
            return this.borderStyle;
        }

        public URI getBorderColor() {
            return this.borderColor;
        }

        public static StyleBuilder builder() {
            return new StyleBuilder();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum BorderStyle {
            NONE,
            SOLID,
            DOT,
            DASH;

        }

        public static final class StyleBuilder {
            private static final URI BLACK = URI.createURI((String)"color://rgb/0/0/0");
            private URI font;
            private URI backgroundColor;
            private URI foregroundColor;
            private boolean isStrikedout;
            private URI strikeoutColor;
            private UnderLineStyle underlineStyle = UnderLineStyle.NONE;
            private URI underlineColor;
            private BorderStyle borderStyle = BorderStyle.NONE;
            private URI borderColor;

            public StyleBuilder setFont(URI font) {
                this.font = font;
                return this;
            }

            public StyleBuilder setBackgroundColor(URI backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public StyleBuilder setForegroundColor(URI foregroundColor) {
                this.foregroundColor = foregroundColor;
                return this;
            }

            public StyleBuilder setStrikedout(boolean isStrikedout) {
                this.isStrikedout = isStrikedout;
                if (this.strikeoutColor == null) {
                    this.strikeoutColor = BLACK;
                }
                return this;
            }

            public StyleBuilder setStrikeoutColor(URI strikeoutColor) {
                this.strikeoutColor = strikeoutColor;
                this.isStrikedout = true;
                return this;
            }

            public StyleBuilder setBorderColor(URI borderColor) {
                this.borderColor = borderColor;
                if (this.borderStyle == BorderStyle.NONE) {
                    this.borderStyle = BorderStyle.SOLID;
                }
                return this;
            }

            public StyleBuilder setBorderStyle(BorderStyle borderStyle) {
                this.borderStyle = borderStyle;
                if (this.borderColor == null) {
                    this.borderColor = BLACK;
                }
                return this;
            }

            public StyleBuilder setUnderlineColor(URI underlineColor) {
                this.underlineColor = underlineColor;
                if (this.underlineStyle == UnderLineStyle.NONE) {
                    this.underlineStyle = UnderLineStyle.SINGLE;
                }
                return this;
            }

            public StyleBuilder setUnderlineStyle(UnderLineStyle underlineStyle) {
                this.underlineStyle = underlineStyle;
                if (underlineStyle == null) {
                    this.underlineColor = BLACK;
                }
                return this;
            }

            public Style build() {
                return new Style(this.font, this.backgroundColor, this.foregroundColor, this.isStrikedout, this.strikeoutColor, this.underlineStyle, this.underlineColor, this.borderStyle, this.borderColor);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum UnderLineStyle {
            NONE,
            SINGLE,
            DOUBLE,
            SQUIGGLE,
            ERROR,
            LINK;

        }
    }
}

