/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.factories.extensions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diagram.internal.CompareDiagramConfiguration;
import org.eclipse.emf.compare.diagram.internal.extensions.CoordinatesChange;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.diagram.internal.extensions.ExtensionsFactory;
import org.eclipse.emf.compare.diagram.internal.factories.extensions.NodeChangeFactory;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.NotationPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatesChangeFactory
extends NodeChangeFactory {
    private final CompareDiagramConfiguration configuration;

    public CoordinatesChangeFactory(CompareDiagramConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Class<? extends Diff> getExtensionKind() {
        return CoordinatesChange.class;
    }

    @Override
    public DiagramDiff createExtension() {
        return ExtensionsFactory.eINSTANCE.createCoordinatesChange();
    }

    @Override
    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        if (extensionKind == DifferenceKind.CHANGE) {
            extension.getRefinedBy().addAll(this.getAllDifferencesForChange(refiningDiff));
        }
    }

    public static Predicate<? super Diff> isCoordinatesChangeExtension() {
        return Predicates.and((Predicate)Predicates.instanceOf(CoordinatesChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE));
    }

    private static Predicate<? super Diff> isRelatedToMove(final List<Match> scannedMatches) {
        return new Predicate<Diff>(){

            public boolean apply(Diff difference) {
                if (!scannedMatches.isEmpty()) {
                    return difference instanceof ReferenceChange && CoordinatesChangeFactory.isRelatedToAMoveNode((ReferenceChange)difference) && scannedMatches.contains(((Match)scannedMatches.get(0)).getComparison().getMatch(((ReferenceChange)difference).getValue()));
                }
                return false;
            }
        };
    }

    protected boolean isRelatedToAnExtensionChange(AttributeChange input) {
        return input.getAttribute().eContainer().equals(NotationPackage.eINSTANCE.getLocation()) && Collections2.filter((Collection)input.getRefines(), CoordinatesChangeFactory.isCoordinatesChangeExtension()).isEmpty() && this.isOverThreshold(input) && !this.isLeadedByMoveNode(input);
    }

    private boolean isLeadedByMoveNode(AttributeChange input) {
        ArrayList<Match> scannedMatches = new ArrayList<Match>();
        boolean result = false;
        Match match = input.getMatch();
        while (!result && match instanceof Match) {
            scannedMatches.add(match);
            result = Iterators.any((Iterator)match.getDifferences().iterator(), CoordinatesChangeFactory.isRelatedToMove(scannedMatches));
            match = match.eContainer();
        }
        return result;
    }

    private boolean isOverThreshold(AttributeChange diff) {
        Comparison comparison = diff.getMatch().getComparison();
        EObject left = MatchUtil.getContainer((Comparison)comparison, (Diff)diff);
        EObject right = MatchUtil.getOriginContainer((Comparison)comparison, (Diff)diff);
        if (left instanceof Bounds && right instanceof Bounds) {
            int threshold;
            int deltaY;
            int leftX = ((Bounds)left).getX();
            int leftY = ((Bounds)left).getY();
            int rightX = ((Bounds)right).getX();
            int rightY = ((Bounds)right).getY();
            int deltaX = Math.abs(leftX - rightX);
            return deltaX + (deltaY = Math.abs(leftY - rightY)) > (threshold = this.configuration.getMoveThreshold());
        }
        return false;
    }
}

