/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ScopeQuery;
import org.eclipse.emf.compare.match.eobject.internal.ByTypeIndex;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProximityEObjectMatcher
implements IEObjectMatcher,
ScopeQuery {
    private EObjectIndex index;
    private Map<EObject, EObjectIndex.Side> eObjectsToSide = Maps.newHashMap();

    public ProximityEObjectMatcher(DistanceFunction meter) {
        this.index = new ByTypeIndex(meter, this);
    }

    @Override
    public void createMatches(Comparison comparison, Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, Monitor monitor) {
        Iterator<EObject> remainingResult;
        BasicMonitor subMonitor = new BasicMonitor();
        subMonitor.beginTask("indexing objects", 1);
        int nbElements = 0;
        while (leftEObjects.hasNext() || rightEObjects.hasNext() || leftEObjects.hasNext()) {
            EObject next;
            if (leftEObjects.hasNext()) {
                next = leftEObjects.next();
                ++nbElements;
                this.index.index(next, EObjectIndex.Side.LEFT);
                this.eObjectsToSide.put(next, EObjectIndex.Side.LEFT);
            }
            if (rightEObjects.hasNext()) {
                next = rightEObjects.next();
                ++nbElements;
                this.index.index(next, EObjectIndex.Side.RIGHT);
                this.eObjectsToSide.put(next, EObjectIndex.Side.RIGHT);
            }
            if (!originEObjects.hasNext()) continue;
            next = originEObjects.next();
            ++nbElements;
            this.index.index(next, EObjectIndex.Side.ORIGIN);
            this.eObjectsToSide.put(next, EObjectIndex.Side.ORIGIN);
        }
        subMonitor.worked(1);
        subMonitor.done();
        subMonitor = new BasicMonitor();
        subMonitor.beginTask("matching objects", nbElements);
        Iterator<EObject> todo = this.index.getValuesStillThere(EObjectIndex.Side.LEFT).iterator();
        while (todo.hasNext()) {
            remainingResult = this.matchList(comparison, todo, (Monitor)subMonitor).iterator();
            todo = remainingResult;
        }
        todo = this.index.getValuesStillThere(EObjectIndex.Side.RIGHT).iterator();
        while (todo.hasNext()) {
            remainingResult = this.matchList(comparison, todo, (Monitor)subMonitor).iterator();
            todo = remainingResult;
        }
        for (EObject notFound : this.index.getValuesStillThere(EObjectIndex.Side.RIGHT)) {
            this.areMatching(comparison, null, notFound, null);
        }
        for (EObject notFound : this.index.getValuesStillThere(EObjectIndex.Side.LEFT)) {
            this.areMatching(comparison, notFound, null, null);
        }
        for (EObject notFound : this.index.getValuesStillThere(EObjectIndex.Side.ORIGIN)) {
            this.areMatching(comparison, null, null, notFound);
        }
        subMonitor.done();
        this.restructureMatchModel(comparison);
    }

    private Iterable<EObject> matchList(Comparison comparison, Iterator<EObject> todo, Monitor monitor) {
        ArrayList remainingResult = Lists.newArrayList();
        while (todo.hasNext()) {
            EObject next = todo.next();
            if (next.eContainer() == null || comparison.getMatch(next.eContainer()) != null || !this.isInScope(next.eContainer())) {
                if (!this.tryToMatch(comparison, next)) {
                    remainingResult.add(next);
                }
                monitor.worked(1);
                continue;
            }
            remainingResult.add(next);
        }
        return remainingResult;
    }

    private boolean tryToMatch(Comparison comparison, EObject a) {
        EObjectIndex.Side aSide = this.eObjectsToSide.get(a);
        assert (aSide != null);
        EObjectIndex.Side bSide = EObjectIndex.Side.LEFT;
        EObjectIndex.Side cSide = EObjectIndex.Side.RIGHT;
        if (aSide == EObjectIndex.Side.RIGHT) {
            bSide = EObjectIndex.Side.LEFT;
            cSide = EObjectIndex.Side.ORIGIN;
        } else if (aSide == EObjectIndex.Side.LEFT) {
            bSide = EObjectIndex.Side.RIGHT;
            cSide = EObjectIndex.Side.ORIGIN;
        } else if (aSide == EObjectIndex.Side.ORIGIN) {
            bSide = EObjectIndex.Side.LEFT;
            cSide = EObjectIndex.Side.RIGHT;
        }
        assert (aSide != bSide);
        assert (bSide != cSide);
        assert (cSide != aSide);
        Map<EObjectIndex.Side, EObject> closests = this.index.findClosests(comparison, a, aSide);
        if (closests != null) {
            EObject lObj = closests.get((Object)bSide);
            EObject aObj = closests.get((Object)cSide);
            this.areMatching(comparison, closests.get((Object)EObjectIndex.Side.LEFT), closests.get((Object)EObjectIndex.Side.RIGHT), closests.get((Object)EObjectIndex.Side.ORIGIN));
            if (lObj != null) {
                this.index.remove(lObj, EObjectIndex.Side.LEFT);
            }
            if (aObj != null) {
                this.index.remove(aObj, EObjectIndex.Side.ORIGIN);
            }
            if (a != null) {
                this.index.remove(a, EObjectIndex.Side.RIGHT);
            }
            return true;
        }
        return false;
    }

    private void restructureMatchModel(Comparison comparison) {
        for (Match cur : ImmutableList.copyOf((Iterator)Iterators.filter((Iterator)comparison.eAllContents(), Match.class))) {
            Match possibleContainerMatch;
            EObject possibleContainer = null;
            if (cur.getLeft() != null) {
                possibleContainer = cur.getLeft().eContainer();
            }
            if (possibleContainer == null && cur.getRight() != null) {
                possibleContainer = cur.getRight().eContainer();
            }
            if (possibleContainer == null && cur.getOrigin() != null) {
                possibleContainer = cur.getOrigin().eContainer();
            }
            if ((possibleContainerMatch = comparison.getMatch(possibleContainer)) == null) continue;
            ((BasicEList)possibleContainerMatch.getSubmatches()).addUnique((Object)cur);
        }
    }

    private Match areMatching(Comparison comparison, EObject left, EObject right, EObject origin) {
        Match result = CompareFactory.eINSTANCE.createMatch();
        result.setLeft(left);
        result.setRight(right);
        result.setOrigin(origin);
        ((BasicEList)comparison.getMatches()).addUnique((Object)result);
        if (left != null) {
            this.index.remove(left, EObjectIndex.Side.LEFT);
        }
        if (right != null) {
            this.index.remove(right, EObjectIndex.Side.RIGHT);
        }
        if (origin != null) {
            this.index.remove(origin, EObjectIndex.Side.ORIGIN);
        }
        return result;
    }

    @Override
    public boolean isInScope(EObject eContainer) {
        return this.eObjectsToSide.get(eContainer) != null;
    }

    public static interface DistanceFunction {
        public double distance(Comparison var1, EObject var2, EObject var3);

        public boolean areIdentic(Comparison var1, EObject var2, EObject var3);
    }
}

