/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.DifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StructureMergeViewerGrouper {
    private IDifferenceGroupProvider provider;
    private List<TreeViewer> viewers = Lists.newArrayList();
    private EventBus eventBus;

    public StructureMergeViewerGrouper(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public Iterable<? extends DifferenceGroup> getGroups(Comparison comparison) {
        if (this.provider == null) {
            return ImmutableList.of();
        }
        Iterable<? extends DifferenceGroup> groups = this.provider.getGroups(comparison);
        Iterable filteredGroups = Iterables.filter(groups, (Predicate)new NonEmptyGroup());
        return filteredGroups;
    }

    public void setProvider(IDifferenceGroupProvider provider) {
        if (this.provider != provider) {
            this.provider = provider;
            this.eventBus.post((Object)provider);
            this.refreshViewers();
        }
    }

    private void refreshViewers() {
        for (TreeViewer viewer : this.viewers) {
            TreePath[] paths = viewer.getExpandedTreePaths();
            viewer.refresh();
            viewer.setExpandedTreePaths(paths);
        }
    }

    public void install(final TreeViewer viewer) {
        viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StructureMergeViewerGrouper.this.uninstall(viewer);
            }
        });
        this.viewers.add(viewer);
    }

    public void uninstall(TreeViewer viewer) {
        this.viewers.remove(viewer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonEmptyGroup
    implements Predicate<DifferenceGroup> {
        private NonEmptyGroup() {
        }

        public boolean apply(DifferenceGroup input) {
            return input != null && !Iterables.isEmpty(input.getDifferences());
        }
    }
}

