/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.actions.group.DifferenceGroup;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractEDiffElement;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.DiffNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ImageProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.MatchNode;
import org.eclipse.emf.compare.ide.ui.internal.util.EMFCompareCompositeImageDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

class EMFCompareStructureMergeViewerLabelProvider
extends AdapterFactoryLabelProvider.FontAndColorProvider {
    private final boolean fLeftIsLocal;
    private final ImageProvider imgProvider;

    public EMFCompareStructureMergeViewerLabelProvider(AdapterFactory adapterFactory, Viewer viewer, boolean leftIsLocal) {
        super(adapterFactory, viewer);
        this.fLeftIsLocal = leftIsLocal;
        this.imgProvider = new ImageProvider(this.fLeftIsLocal);
    }

    public String getText(Object element) {
        String ret = element instanceof IDiffElement ? ((IDiffElement)element).getName() : (element instanceof DifferenceGroup ? ((DifferenceGroup)element).getName() : super.getText(element));
        return ret;
    }

    public Font getFont(Object object) {
        if (object instanceof AbstractEDiffElement) {
            return super.getFont((Object)((AbstractEDiffElement)((Object)object)).getTarget());
        }
        return super.getFont(object);
    }

    public Color getForeground(Object object) {
        if (object instanceof AbstractEDiffElement) {
            return super.getForeground((Object)((AbstractEDiffElement)((Object)object)).getTarget());
        }
        return super.getForeground(object);
    }

    public Color getBackground(Object object) {
        if (object instanceof AbstractEDiffElement) {
            return super.getBackground((Object)((AbstractEDiffElement)((Object)object)).getTarget());
        }
        return super.getBackground(object);
    }

    public Image getImage(Object element) {
        Image ret;
        if (element instanceof DiffNode) {
            Diff target = ((DiffNode)((Object)element)).getTarget();
            ImageDescriptor overlay = this.imgProvider.getImageDescriptorOverlay(target);
            Image base = super.getImage((Object)target);
            EMFCompareCompositeImageDescriptor descriptor = new EMFCompareCompositeImageDescriptor(base, overlay, 22, !this.fLeftIsLocal);
            ret = EMFCompareIDEUIPlugin.getDefault().getImage((ImageDescriptor)descriptor);
        } else if (element instanceof MatchNode) {
            Match target = ((MatchNode)((Object)element)).getTarget();
            ImageDescriptor overlay = this.imgProvider.getImageDescriptorOverlay(target);
            Image base = super.getImage((Object)target);
            EMFCompareCompositeImageDescriptor descriptor = new EMFCompareCompositeImageDescriptor(base, overlay, 22, !this.fLeftIsLocal);
            ret = EMFCompareIDEUIPlugin.getDefault().getImage((ImageDescriptor)descriptor);
        } else {
            Image groupImage;
            ret = element instanceof AbstractEDiffElement ? ((AbstractEDiffElement)((Object)element)).getImage() : (element instanceof DifferenceGroup ? ((groupImage = ((DifferenceGroup)element).getImage()) != null ? groupImage : EMFCompareIDEUIPlugin.getDefault().getImage("icons/full/toolb16/group.gif")) : super.getImage(element));
        }
        return ret;
    }
}

