/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.InsertionPoint;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.MatchedObject;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.MergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor.BasicStructuralFeatureAccessorImpl;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyStructuralFeatureAccessorImpl
extends BasicStructuralFeatureAccessorImpl {
    public ManyStructuralFeatureAccessorImpl(Diff diff, MergeViewer.MergeViewerSide side) {
        super(diff, side);
    }

    @Override
    public ImmutableList<? extends IMergeViewerItem> getItems() {
        List<?> list = this.getFeatureValues(this.getSide());
        List<? extends IMergeViewerItem> ret = this.createMergeViewerItemFrom(list);
        if (this.getSide() != MergeViewer.MergeViewerSide.ANCESTOR) {
            ret = this.createInsertionPoints(ret);
        }
        return ImmutableList.copyOf(ret);
    }

    private List<? extends IMergeViewerItem> createMergeViewerItemFrom(List<?> values) {
        ArrayList ret = Lists.newArrayListWithCapacity((int)values.size());
        for (Object value : values) {
            IMergeViewerItem valueToAdd = this.createMergeViewerItemFrom(value);
            ret.add(valueToAdd);
        }
        return ret;
    }

    private IMergeViewerItem createMergeViewerItemFrom(Object object) {
        Diff diff = this.getDiffWithValue(object);
        Object left = this.matchingValue(object, MergeViewer.MergeViewerSide.LEFT);
        Object right = this.matchingValue(object, MergeViewer.MergeViewerSide.RIGHT);
        Object ancestor = this.matchingValue(object, MergeViewer.MergeViewerSide.ANCESTOR);
        return new MatchedObject(diff, left, right, ancestor);
    }

    private List<? extends IMergeViewerItem> createInsertionPoints(List<? extends IMergeViewerItem> values) {
        ArrayList ret = Lists.newArrayList(values);
        for (Diff diff : this.getDifferences().reverse()) {
            boolean rightEmptyBox;
            boolean rightToLeft = this.getSide() == MergeViewer.MergeViewerSide.LEFT;
            Object left = this.getValueFromDiff(diff, MergeViewer.MergeViewerSide.LEFT);
            Object right = this.getValueFromDiff(diff, MergeViewer.MergeViewerSide.RIGHT);
            if (left == null && right == null) continue;
            boolean leftEmptyBox = this.getSide() == MergeViewer.MergeViewerSide.LEFT && (left == null || !this.getFeatureValues(this.getSide()).contains(left));
            boolean bl = rightEmptyBox = this.getSide() == MergeViewer.MergeViewerSide.RIGHT && (right == null || !this.getFeatureValues(this.getSide()).contains(right));
            if (!leftEmptyBox && !rightEmptyBox) continue;
            Object ancestor = this.getValueFromDiff(diff, MergeViewer.MergeViewerSide.ANCESTOR);
            InsertionPoint insertionPoint = new InsertionPoint(diff, left, right, ancestor);
            int insertionIndex = Math.min(this.findInsertionIndex(diff, rightToLeft), ret.size());
            List subList = ret.subList(0, insertionIndex);
            int nbInsertionPointBefore = Iterables.size((Iterable)Iterables.filter(subList, InsertionPoint.class));
            int index = Math.min(insertionIndex + nbInsertionPointBefore, ret.size());
            ret.add(index, insertionPoint);
        }
        return ret;
    }

    protected int findInsertionIndex(Diff diff, boolean rightToLeft) {
        return DiffUtil.findInsertionIndex((Comparison)this.getComparison(), (Diff)diff, (boolean)rightToLeft);
    }

    private Diff getDiffWithValue(Object value) {
        Diff ret = null;
        for (Diff diff : this.getDifferences()) {
            Object valueOfDiff = this.getValueFromDiff(diff, this.getSide());
            if (valueOfDiff != value) continue;
            ret = diff;
            break;
        }
        return ret;
    }

    protected Object getValueFromDiff(Diff diff, MergeViewer.MergeViewerSide side) {
        Object diffValue = this.getDiffValue(diff);
        Object ret = this.matchingValue(diffValue, side);
        return ret;
    }

    private Object matchingValue(Object object, MergeViewer.MergeViewerSide side) {
        Object ret;
        block7: {
            block5: {
                block6: {
                    if (!(object instanceof EObject)) break block5;
                    Match matchOfValue = this.getComparison().getMatch((EObject)object);
                    if (matchOfValue == null) break block6;
                    switch (side) {
                        case ANCESTOR: {
                            ret = matchOfValue.getOrigin();
                            break block7;
                        }
                        case LEFT: {
                            ret = matchOfValue.getLeft();
                            break block7;
                        }
                        case RIGHT: {
                            ret = matchOfValue.getRight();
                            break block7;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                ret = this.matchingValue(object, this.getFeatureValues(side));
                break block7;
            }
            ret = this.matchingValue(object, this.getFeatureValues(side));
        }
        return ret;
    }

    private Object matchingValue(Object value, List<?> in) {
        Object ret = null;
        IEqualityHelper equalityHelper = this.getComparison().getEqualityHelper();
        Iterator<?> valuesIterator = in.iterator();
        while (valuesIterator.hasNext() && ret == null) {
            Object object = valuesIterator.next();
            if (!equalityHelper.matchingValues(object, value)) continue;
            ret = object;
        }
        return ret;
    }

    protected List<?> getFeatureValues(MergeViewer.MergeViewerSide side) {
        EObject eObject = this.getEObject(side);
        return ManyStructuralFeatureAccessorImpl.getAsList(eObject, this.getStructuralFeature());
    }

    private static List<?> getAsList(EObject object, EStructuralFeature feature) {
        Object value;
        ArrayList asList = object != null ? ((value = ReferenceUtil.safeEGet((EObject)object, (EStructuralFeature)feature)) instanceof InternalEList ? Lists.newArrayList((Iterable)((InternalEList)value).basicList()) : (value instanceof List ? Lists.newArrayList((Iterable)((List)value)) : (value instanceof Iterable ? Lists.newArrayList((Iterable)((Iterable)value)) : (value != null ? Lists.newArrayList((Object[])new Object[]{value}) : Lists.newArrayList())))) : Lists.newArrayList();
        return asList;
    }

    protected Object getDiffValue(Diff diff) {
        Object ret = diff instanceof ReferenceChange ? ((ReferenceChange)diff).getValue() : (diff instanceof AttributeChange ? ((AttributeChange)diff).getValue() : null);
        return ret;
    }
}

