/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.utils;

import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PriorityExecutor
implements Executor {
    private final ExecutorService pool;

    public PriorityExecutor(String poolName) {
        int threadCount = Runtime.getRuntime().availableProcessors();
        String actualName = poolName == null || poolName.length() == 0 ? "PrioritizedPool" : poolName;
        NamedPoolThreadFactory factory = new NamedPoolThreadFactory(actualName);
        this.pool = new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(16, new PriorityTaskComparable()), factory);
    }

    public <T> Future<T> submit(Runnable task, Priority priority) {
        if (task == null) {
            throw new NullPointerException();
        }
        PriorityFutureTask<Object> ftask = new PriorityFutureTask<Object>(Executors.callable(task, null), priority);
        this.execute(ftask);
        return ftask;
    }

    public <T> Future<T> submit(Callable<T> task, Priority priority) {
        if (task == null) {
            throw new NullPointerException();
        }
        PriorityFutureTask<T> ftask = new PriorityFutureTask<T>(task, priority);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public void execute(Runnable command) {
        if (command instanceof PriorityFutureTask) {
            this.pool.execute(command);
        } else {
            this.pool.execute(new PriorityFutureTask<Object>(Executors.callable(command), Priority.NORMAL));
        }
    }

    private static class NamedPoolThreadFactory
    implements ThreadFactory {
        private final String poolName;
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public NamedPoolThreadFactory(String poolName) {
            this.poolName = poolName;
            SecurityManager manager = System.getSecurityManager();
            this.group = manager == null ? Thread.currentThread().getThreadGroup() : manager.getThreadGroup();
        }

        public Thread newThread(Runnable r) {
            String prefix = String.valueOf(this.poolName) + "-thread-";
            Thread thread = new Thread(this.group, r, String.valueOf(prefix) + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        LOW(2),
        NORMAL(1),
        HIGH(0);

        private int value;

        private Priority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PriorityFutureTask<V>
    extends FutureTask<V> {
        private Priority priority;

        public PriorityFutureTask(Callable<V> callable, Priority priority) {
            super(callable);
            this.priority = priority;
        }

        public Priority getPriority() {
            return this.priority;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PriorityTaskComparable
    implements Comparator<Runnable> {
        private PriorityTaskComparable() {
        }

        @Override
        public int compare(Runnable o1, Runnable o2) {
            if (o1 instanceof PriorityFutureTask && o2 instanceof PriorityFutureTask) {
                return ((PriorityFutureTask)o1).getPriority().getValue() - ((PriorityFutureTask)o2).getPriority().getValue();
            }
            return 0;
        }
    }
}

