/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.viewers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.LocateInExplorerAction;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.activities.ExplorerActivity;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.BasicSessionActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.Messages;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SelectionHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.viewers.AbstractActivityExplorerViewer;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.sections.ActivityExplorerSection;
import org.eclipse.amalgam.explorer.activity.ui.api.hyperlinkadapter.AbstractNewDiagramHyperlinkAdapter;
import org.eclipse.amalgam.explorer.activity.ui.internal.util.ActivityExplorerLoggerService;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.CloneAction;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.DeleteRepresentationAction;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.MoveRepresentationAction;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.OpenRepresentationsAction;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.RenameRepresentationAction;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.providers.DiagramViewerContentProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointItem;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.SiriusCommonLabelProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class DiagramViewer
extends AbstractActivityExplorerViewer {
    private static final String GROUP_MOVE = "Move";
    private MoveRepresentationAction _moveDiagramAction;
    private OpenRepresentationsAction _openRepresentation;
    private RenameRepresentationAction _renameRepresentationAction;
    private BaseSelectionListenerAction _showInModelExplorerAction;
    private CloneAction _cloneAction;
    private DeleteRepresentationAction _deleteRepresentationAction;

    public DiagramViewer(BasicSessionActivityExplorerPage page_p) {
        super(page_p);
    }

    @Override
    protected String getViewerSectionTitle() {
        return Messages.BasicSessionActivityExplorerPage_0;
    }

    @Override
    protected Object getInput() {
        return this.page.getEditorInput().getSession();
    }

    @Override
    protected ILabelProvider getLabelProvider() {
        return new SiriusCommonLabelProvider();
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new DiagramViewerContentProvider(this.page.getHandledViewpoint());
    }

    @Override
    protected void addListenersOnViewer(TreeViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event_p) {
                IStructuredSelection selection = (IStructuredSelection)event_p.getSelection();
                OpenRepresentationsAction action = new OpenRepresentationsAction();
                action.selectionChanged(selection);
                action.run();
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        ISelectionProvider selectionProvider = this.page.getEditorSite().getSelectionProvider();
        if (this._renameRepresentationAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._renameRepresentationAction);
            this._renameRepresentationAction = null;
        }
        if (this._deleteRepresentationAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._deleteRepresentationAction);
            this._deleteRepresentationAction = null;
        }
        if (this._openRepresentation != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._openRepresentation);
            this._openRepresentation = null;
        }
        if (this._moveDiagramAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._moveDiagramAction);
            this._moveDiagramAction.dispose();
            this._moveDiagramAction = null;
        }
        if (this._cloneAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._cloneAction);
            this._cloneAction = null;
        }
        if (this._showInModelExplorerAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._showInModelExplorerAction);
            this._showInModelExplorerAction = null;
        }
    }

    @Override
    protected MenuManager initMenuToViewer(final TreeViewer treeViewer_p) {
        MenuManager contextMenuManager = super.initMenuToViewer(treeViewer_p);
        contextMenuManager.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToHide(IMenuManager manager_p) {
                manager_p.remove("MoveDiagrams.Menu.ID");
                DiagramViewer.this._moveDiagramAction.dispose();
            }

            public void menuAboutToShow(IMenuManager manager_p) {
                manager_p.appendToGroup(DiagramViewer.GROUP_MOVE, (IContributionItem)DiagramViewer.this._moveDiagramAction.fillContextMenu((IStructuredSelection)treeViewer_p.getSelection()));
            }
        });
        return contextMenuManager;
    }

    @Override
    protected void declareViewerActions(MenuManager contextMenuManager_p, TreeViewer treeViewer_p) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ISelectionProvider selectionProvider = this.page.getEditorSite().getSelectionProvider();
        this._showInModelExplorerAction = new BaseSelectionListenerAction(Messages.BasicSessionActivityExplorerPage_1){

            public void run() {
                LocateInExplorerAction callback = new LocateInExplorerAction();
                callback.setSite((IWorkbenchPartSite)DiagramViewer.this.page.getEditorSite());
                callback.run((IAction)DiagramViewer.this._showInModelExplorerAction);
            }

            protected boolean updateSelection(IStructuredSelection selection_p) {
                return DiagramViewer.this.containsOnlyRepresentations(selection_p);
            }
        };
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._showInModelExplorerAction, selectionProvider);
        contextMenuManager_p.add((IAction)this._showInModelExplorerAction);
        contextMenuManager_p.add((IContributionItem)new Separator());
        this._openRepresentation = new OpenRepresentationsAction(){

            protected boolean updateSelection(IStructuredSelection selection_p) {
                return DiagramViewer.this.containsOnlyRepresentations(selection_p);
            }
        };
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._openRepresentation, selectionProvider);
        contextMenuManager_p.add((IAction)this._openRepresentation);
        contextMenuManager_p.add((IContributionItem)new Separator());
        this._cloneAction = new CloneAction(treeViewer_p);
        this._cloneAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._cloneAction, selectionProvider);
        contextMenuManager_p.add((IAction)this._cloneAction);
        this._deleteRepresentationAction = new DeleteRepresentationAction(){

            protected boolean updateSelection(IStructuredSelection selection_p) {
                return DiagramViewer.this.containsOnlyRepresentations(selection_p);
            }
        };
        this._deleteRepresentationAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this._deleteRepresentationAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._deleteRepresentationAction, selectionProvider);
        contextMenuManager_p.add((IAction)this._deleteRepresentationAction);
        contextMenuManager_p.add((IContributionItem)new Separator(GROUP_MOVE));
        this._moveDiagramAction = new MoveRepresentationAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._moveDiagramAction, selectionProvider);
        this._renameRepresentationAction = new RenameRepresentationAction(){

            protected boolean updateSelection(IStructuredSelection selection_p) {
                return DiagramViewer.this.containsOnlyRepresentations(selection_p);
            }
        };
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._renameRepresentationAction, selectionProvider);
        contextMenuManager_p.add((IAction)this._renameRepresentationAction);
    }

    protected boolean containsOnlyRepresentations(IStructuredSelection selection_p) {
        boolean result = true;
        Iterator iterator = selection_p.toList().iterator();
        while (iterator.hasNext() && result) {
            Object representation = iterator.next();
            if (representation instanceof ItemWrapper) {
                representation = ((ItemWrapper)representation).getWrappedObject();
            }
            if (representation instanceof DRepresentation) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    protected ViewerFilter getViewerFilter(final ActivityExplorerSection section) {
        return new ViewerFilter(){

            public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
                boolean selected = true;
                if (element_p instanceof ViewpointItem) {
                    ViewpointItem viewpointItem = (ViewpointItem)element_p;
                    Viewpoint viewpoint = (Viewpoint)viewpointItem.getWrappedObject();
                    if (viewpoint.getName().equals(this.getFilteredViewpoint())) {
                        selected = false;
                    }
                } else if (element_p instanceof RepresentationDescriptionItem) {
                    selected = this.isRepresentationDescriptionItemTypeSelected((RepresentationDescriptionItem)element_p, this.getRetainedRepresentationDescriptions());
                } else if (element_p instanceof DSemanticDiagram) {
                    DSemanticDiagram semanticDiagram = (DSemanticDiagram)element_p;
                    selected = this.isDiagramSelected(semanticDiagram.getTarget(), semanticDiagram.getDescription());
                }
                return selected;
            }

            private Object getFilteredViewpoint() {
                return null;
            }

            protected Set<String> getRetainedRepresentationDescriptions() {
                HashSet<String> representations = new HashSet<String>();
                for (ExplorerActivity activity : section.getActivities()) {
                    IHyperlinkListener listener = activity.getListener();
                    if (!(listener instanceof AbstractNewDiagramHyperlinkAdapter)) continue;
                    try {
                        representations.add(((AbstractNewDiagramHyperlinkAdapter)listener).getRepresentationName());
                    }
                    catch (Throwable e) {
                        StringBuilder message = new StringBuilder();
                        message.append("DiagramViewer.getRetainedRepresentationDescriptions() _ ");
                        message.append("Could not retrieve a representation name from contribution ");
                        message.append(activity.getId());
                        message.append(" See the error stack for more details.");
                        ActivityExplorerLoggerService.getInstance().log(4, message.toString(), e);
                    }
                }
                return representations;
            }

            protected boolean isDiagramSelected(EObject semanticElement_p, DiagramDescription diagramDescription_p) {
                return true;
            }

            protected boolean isRepresentationDescriptionItemTypeSelected(RepresentationDescriptionItem representationDescriptionItem_p, Set<String> retainedDiagramTypeNames_p) {
                boolean selected = true;
                if (retainedDiagramTypeNames_p != null) {
                    RepresentationDescription representationDescription = (RepresentationDescription)representationDescriptionItem_p.getWrappedObject();
                    String diagramTypeName = representationDescription.getName();
                    selected = retainedDiagramTypeNames_p.contains(diagramTypeName);
                }
                return selected;
            }
        };
    }
}

