/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.core.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.m2m.atl.profiler.model.ATLOperation;
import org.eclipse.m2m.atl.profiler.model.ProfilingInstruction;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfilingModelUtils {
    private ProfilingModelUtils() {
    }

    public static double getDuration(ProfilingOperation op) {
        double time = 0.0;
        time = op.getEndTime() - op.getLaunchedTime();
        return time /= 1000.0;
    }

    public static long getLaunchKbytesMemUsage(ProfilingOperation op) {
        return ProfilingModelUtils.divideLongBy1000(op.getLaunchedMemoryUsage());
    }

    public static long getEndKbytesMemUsage(ProfilingOperation op) {
        return ProfilingModelUtils.divideLongBy1000(op.getEndMemoryUsage());
    }

    public static long getMaxKbytesMemUsage(ProfilingOperation op) {
        return ProfilingModelUtils.divideLongBy1000(op.getMaxMemoryUsage());
    }

    private static long divideLongBy1000(long l) {
        long mem = 0L;
        mem = l / 1000L;
        return mem;
    }

    public static double getTotalTime(EList<ProfilingInstruction> profilingInstructions) {
        double total = 0.0;
        for (ProfilingInstruction pi : profilingInstructions) {
            if (!(pi instanceof ProfilingOperation)) continue;
            ProfilingOperation po = (ProfilingOperation)pi;
            total += (double)(po.getEndTime() - po.getLaunchedTime());
        }
        return total /= 1000.0;
    }

    public static int getTotalInstruction(ATLOperation op) {
        EList profilingInstructions = op.getProfilingInstructions();
        int total = 0;
        for (ProfilingInstruction pi : profilingInstructions) {
            if (!(pi instanceof ProfilingOperation)) continue;
            ProfilingOperation po = (ProfilingOperation)pi;
            total += po.getTotalExecutedInstructions();
        }
        return total;
    }

    public static long getTotalMemory(EList<ProfilingInstruction> profilingInstructions) {
        long total = 0L;
        for (ProfilingInstruction pi : profilingInstructions) {
            if (!(pi instanceof ProfilingOperation)) continue;
            ProfilingOperation po = (ProfilingOperation)pi;
            total += po.getEndMemoryUsage() - po.getLaunchedMemoryUsage();
        }
        return total;
    }

    public static long getMinInMemoryUsage(ATLOperation atlOp) {
        long minStartMem = 0L;
        for (ProfilingInstruction pi : atlOp.getProfilingInstructions()) {
            ProfilingOperation pOp;
            if (!(pi instanceof ProfilingOperation) || minStartMem <= (pOp = (ProfilingOperation)pi).getLaunchedMemoryUsage() && minStartMem != 0L) continue;
            minStartMem = pOp.getLaunchedMemoryUsage();
        }
        return minStartMem;
    }

    public static long getMaxOutMemoryUsage(ATLOperation atlOp) {
        long maxEndMem = 0L;
        for (ProfilingInstruction pi : atlOp.getProfilingInstructions()) {
            ProfilingOperation pOp;
            if (!(pi instanceof ProfilingOperation) || maxEndMem >= (pOp = (ProfilingOperation)pi).getEndMemoryUsage() && maxEndMem != 0L) continue;
            maxEndMem = pOp.getEndMemoryUsage();
        }
        return maxEndMem;
    }

    public static long getMaxMaxMemoryUsage(ATLOperation atlOp) {
        long maxMaxMem = 0L;
        for (ProfilingInstruction pi : atlOp.getProfilingInstructions()) {
            ProfilingOperation pOp;
            if (!(pi instanceof ProfilingOperation) || maxMaxMem >= (pOp = (ProfilingOperation)pi).getMaxMemoryUsage() && maxMaxMem != 0L) continue;
            maxMaxMem = pOp.getMaxMemoryUsage();
        }
        return maxMaxMem;
    }
}

