/*******************************************************************************
 * Copyright (c) 2011 Vrije Universiteit Brussel.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Dennis Wagelaar, Vrije Universiteit Brussel - initial API and
 *         implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.m2m.atl.emftvm.tests;

import junit.textui.TestRunner;

import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.Ifte;

/**
 * <!-- begin-user-doc -->
 * A test case for the model object '<em><b>Ifte</b></em>'.
 * @author <a href="mailto:dennis.wagelaar@vub.ac.be">Dennis Wagelaar</a>
 * <!-- end-user-doc -->
 * <p>
 * The following features are tested:
 * <ul>
 *   <li>{@link org.eclipse.m2m.atl.emftvm.Ifte#getThenCbIndex() <em>Then Cb Index</em>}</li>
 *   <li>{@link org.eclipse.m2m.atl.emftvm.Ifte#getElseCbIndex() <em>Else Cb Index</em>}</li>
 *   <li>{@link org.eclipse.m2m.atl.emftvm.Ifte#getThenCb() <em>Then Cb</em>}</li>
 *   <li>{@link org.eclipse.m2m.atl.emftvm.Ifte#getElseCb() <em>Else Cb</em>}</li>
 * </ul>
 * </p>
 * @generated
 */
public class IfteTest extends InstructionTest {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static void main(String[] args) {
		TestRunner.run(IfteTest.class);
	}

	/**
	 * Constructs a new Ifte test case with the given name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IfteTest(String name) {
		super(name);
	}

	/**
	 * Returns the fixture for this Ifte test case.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected Ifte getFixture() {
		return (Ifte)fixture;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see junit.framework.TestCase#setUp()
	 * @generated
	 */
	@Override
	protected void setUp() throws Exception {
		setFixture(EmftvmFactory.eINSTANCE.createIfte());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see junit.framework.TestCase#tearDown()
	 * @generated
	 */
	@Override
	protected void tearDown() throws Exception {
		setFixture(null);
	}

	/**
	 * Tests the '{@link org.eclipse.m2m.atl.emftvm.Ifte#getThenCbIndex() <em>Then Cb Index</em>}' feature getter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.m2m.atl.emftvm.Ifte#getThenCbIndex()
	 * @generated
	 */
	public void testGetThenCbIndex() {
		// TODO: implement this feature getter test method
		// Ensure that you remove @generated or mark it @generated NOT
		fail();
	}

	/**
	 * Tests the '{@link org.eclipse.m2m.atl.emftvm.Ifte#setThenCbIndex(int) <em>Then Cb Index</em>}' feature setter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.m2m.atl.emftvm.Ifte#setThenCbIndex(int)
	 * @generated
	 */
	public void testSetThenCbIndex() {
		// TODO: implement this feature setter test method
		// Ensure that you remove @generated or mark it @generated NOT
		fail();
	}

	/**
	 * Tests the '{@link org.eclipse.m2m.atl.emftvm.Ifte#getElseCbIndex() <em>Else Cb Index</em>}' feature getter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.m2m.atl.emftvm.Ifte#getElseCbIndex()
	 * @generated
	 */
	public void testGetElseCbIndex() {
		// TODO: implement this feature getter test method
		// Ensure that you remove @generated or mark it @generated NOT
		fail();
	}

	/**
	 * Tests the '{@link org.eclipse.m2m.atl.emftvm.Ifte#setElseCbIndex(int) <em>Else Cb Index</em>}' feature setter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.m2m.atl.emftvm.Ifte#setElseCbIndex(int)
	 * @generated
	 */
	public void testSetElseCbIndex() {
		// TODO: implement this feature setter test method
		// Ensure that you remove @generated or mark it @generated NOT
		fail();
	}

	/**
	 * Tests the '{@link org.eclipse.m2m.atl.emftvm.Ifte#getThenCb() <em>Then Cb</em>}' feature getter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.m2m.atl.emftvm.Ifte#getThenCb()
	 * @generated
	 */
	public void testGetThenCb() {
		// TODO: implement this feature getter test method
		// Ensure that you remove @generated or mark it @generated NOT
		fail();
	}

	/**
	 * Tests the '{@link org.eclipse.m2m.atl.emftvm.Ifte#setThenCb(org.eclipse.m2m.atl.emftvm.CodeBlock) <em>Then Cb</em>}' feature setter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.m2m.atl.emftvm.Ifte#setThenCb(org.eclipse.m2m.atl.emftvm.CodeBlock)
	 * @generated
	 */
	public void testSetThenCb() {
		// TODO: implement this feature setter test method
		// Ensure that you remove @generated or mark it @generated NOT
		fail();
	}

	/**
	 * Tests the '{@link org.eclipse.m2m.atl.emftvm.Ifte#getElseCb() <em>Else Cb</em>}' feature getter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.m2m.atl.emftvm.Ifte#getElseCb()
	 * @generated
	 */
	public void testGetElseCb() {
		// TODO: implement this feature getter test method
		// Ensure that you remove @generated or mark it @generated NOT
		fail();
	}

	/**
	 * Tests the '{@link org.eclipse.m2m.atl.emftvm.Ifte#setElseCb(org.eclipse.m2m.atl.emftvm.CodeBlock) <em>Else Cb</em>}' feature setter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.m2m.atl.emftvm.Ifte#setElseCb(org.eclipse.m2m.atl.emftvm.CodeBlock)
	 * @generated
	 */
	public void testSetElseCb() {
		// TODO: implement this feature setter test method
		// Ensure that you remove @generated or mark it @generated NOT
		fail();
	}

} //IfteTest
