/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.ssl;

import jakarta.inject.Inject;
import jakarta.ws.rs.ProcessingException;
import java.security.KeyStore;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.JsonPClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.ssl.ClientWithNonMatchingStore;
import org.eclipse.microprofile.rest.client.tck.interfaces.ssl.ClientWithTruststore;
import org.eclipse.microprofile.rest.client.tck.interfaces.ssl.JsonPClientWithTruststoreFromClasspath;
import org.eclipse.microprofile.rest.client.tck.ssl.AbstractSslTest;
import org.eclipse.microprofile.rest.client.tck.ssl.HttpsServer;
import org.eclipse.microprofile.rest.client.tck.utils.ConfigUtil;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SslTrustStoreTest
extends AbstractSslTest {
    @Inject
    @RestClient
    private JsonPClient clientWithNoSslStores;
    @Inject
    @RestClient
    private ClientWithTruststore clientWithTruststore;
    @Inject
    @RestClient
    private ClientWithNonMatchingStore clientWithNonMatchingTruststore;
    @Inject
    @RestClient
    private JsonPClientWithTruststoreFromClasspath clientWithTruststoreFromClasspath;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(SslTrustStoreTest.class.getSimpleName() + ".war"));
        SslTrustStoreTest.initializeTest(webArchive, server -> server.keyStore(serverKeystore.getAbsolutePath(), "password"));
        String config = ConfigUtil.configLine(JsonPClient.class, "uri", BASE_URI_STRING) + ConfigUtil.configLine(ClientWithTruststore.class, "trustStore", SslTrustStoreTest.filePath(clientTruststore)) + ConfigUtil.configLine(ClientWithTruststore.class, "trustStoreType", "pkcs12") + ConfigUtil.configLine(ClientWithTruststore.class, "trustStorePassword", "password") + ConfigUtil.configLine(ClientWithTruststore.class, "uri", BASE_URI_STRING) + ConfigUtil.configLine(JsonPClientWithTruststoreFromClasspath.class, "trustStore", "classpath:/META-INF/" + clientTruststoreFromClasspath) + ConfigUtil.configLine(JsonPClientWithTruststoreFromClasspath.class, "trustStoreType", "pkcs12") + ConfigUtil.configLine(JsonPClientWithTruststoreFromClasspath.class, "trustStorePassword", "password") + ConfigUtil.configLine(JsonPClientWithTruststoreFromClasspath.class, "uri", BASE_URI_STRING) + ConfigUtil.configLine(ClientWithNonMatchingStore.class, "trustStore", SslTrustStoreTest.filePath(anotherTruststore)) + ConfigUtil.configLine(ClientWithNonMatchingStore.class, "trustStoreType", "pkcs12") + ConfigUtil.configLine(ClientWithNonMatchingStore.class, "trustStorePassword", "password") + ConfigUtil.configLine(ClientWithNonMatchingStore.class, "uri", BASE_URI_STRING);
        ((WebArchive)((WebArchive)((WebArchive)webArchive.addClasses(new Class[]{JsonPClient.class, ClientWithTruststore.class, ClientWithNonMatchingStore.class, JsonPClientWithTruststoreFromClasspath.class, HttpsServer.class, AbstractSslTest.class})).addAsWebInfResource((Asset)new StringAsset(config), "classes/META-INF/microprofile-config.properties")).addAsWebInfResource((Asset)new ClassLoaderAsset("ssl/" + clientTruststoreFromClasspath), "classes/META-INF/" + clientTruststoreFromClasspath)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return webArchive;
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailWithSelfSignedKeystore() {
        ((JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).build(JsonPClient.class)).get("1");
    }

    @Test
    public void shouldSucceedWithRegisteredSelfSignedKeystore() throws Exception {
        KeyStore trustStore = SslTrustStoreTest.getKeyStore(clientTruststore);
        JsonPClient client = (JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).trustStore(trustStore).build(JsonPClient.class);
        Assert.assertEquals((String)"bar", (String)client.get("1").getString("foo"));
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailWithNonMatchingKeystore() throws Exception {
        KeyStore ks = SslTrustStoreTest.getKeyStore(anotherTruststore);
        ((JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).trustStore(ks).build(JsonPClient.class)).get("1");
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailWithSelfSignedKeystoreCDI() {
        this.clientWithNoSslStores.get("1");
    }

    @Test
    public void shouldSucceedWithRegisteredSelfSignedKeystoreCDI() {
        Assert.assertEquals((String)"bar", (String)this.clientWithTruststore.get("1").getString("foo"));
    }

    @Test
    public void shouldSucceedWithRegisteredSelfSignedKeystoreFromResourceCDI() {
        Assert.assertEquals((String)"bar", (String)this.clientWithTruststoreFromClasspath.get("1").getString("foo"));
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailWithNonMatchingKeystoreCDI() {
        this.clientWithNonMatchingTruststore.get("1");
    }
}

