/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck.tracer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.microprofile.opentracing.tck.tracer.ConsumableTree;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpan;

public class TestSpanTree
implements ConsumableTree<TestSpan> {
    private final List<TreeNode<TestSpan>> rootSpans = new ArrayList<TreeNode<TestSpan>>();
    private String nodeName = "span";

    public TestSpanTree() {
    }

    public TestSpanTree(String jsonNodeName) {
        this.nodeName = jsonNodeName;
    }

    @SafeVarargs
    public TestSpanTree(TreeNode<TestSpan> ... newRootSpans) {
        for (TreeNode<TestSpan> rootSpan : newRootSpans) {
            this.rootSpans.add(rootSpan);
        }
    }

    public List<TreeNode<TestSpan>> getRootSpans() {
        return this.rootSpans;
    }

    public TreeNode<TestSpan> addRootNode(TreeNode<TestSpan> node) {
        this.rootSpans.add(node);
        return node;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(System.lineSeparator());
        for (int i = 0; i < this.rootSpans.size(); ++i) {
            TreeNode<TestSpan> node = this.rootSpans.get(i);
            sb.append(node.toJSON(this.nodeName, 1, "  "));
            if (i < this.rootSpans.size() - 1) {
                sb.append(',');
            }
            sb.append(System.lineSeparator());
        }
        sb.append(']');
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public boolean equals(Object obj) {
        TestSpanTree otherTree = (TestSpanTree)obj;
        if (otherTree != null) {
            if (otherTree.rootSpans.size() != this.rootSpans.size()) {
                System.err.println("MISMATCH: Root span counts don't match: " + this.rootSpans.size() + " ; " + otherTree.rootSpans.size());
                return false;
            }
            for (int i = 0; i < this.rootSpans.size(); ++i) {
                TreeNode<TestSpan> y;
                TreeNode<TestSpan> x = this.rootSpans.get(i);
                if (x.equals(y = otherTree.rootSpans.get(i))) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void visitTree(Consumer<? super TestSpan> visitor) {
        for (TreeNode<TestSpan> node : this.rootSpans) {
            node.visitTree(visitor);
        }
    }

    public static class TreeNode<T>
    implements ConsumableTree<T> {
        private final List<TreeNode<T>> children = new ArrayList<TreeNode<T>>();
        private final T data;

        @SafeVarargs
        public TreeNode(T nodeData, TreeNode<T> ... newChildren) {
            this.data = nodeData;
            for (TreeNode<T> child : newChildren) {
                this.children.add(child);
            }
        }

        public T getData() {
            return this.data;
        }

        public List<TreeNode<T>> getChildren() {
            return this.children;
        }

        public TreeNode<T> addChild(TreeNode<T> child) {
            this.children.add(child);
            return child;
        }

        public String toJSON(String nodeName, int indentationLevel, String indentationCharacters) {
            StringBuilder sb = new StringBuilder();
            String indent = String.join((CharSequence)"", Collections.nCopies(indentationLevel, indentationCharacters));
            String indent2 = indent + indentationCharacters;
            sb.append(indent);
            sb.append('{');
            sb.append(System.lineSeparator());
            sb.append(indent2);
            sb.append(nodeName);
            sb.append(": \"");
            sb.append(this.data);
            if (this.children.size() > 0) {
                sb.append("\",");
                sb.append(System.lineSeparator());
                sb.append(indent2);
                sb.append("children: [");
                sb.append(System.lineSeparator());
                for (int i = 0; i < this.children.size(); ++i) {
                    TreeNode<T> child = this.children.get(i);
                    sb.append(child.toJSON(nodeName, indentationLevel + 2, indentationCharacters));
                    if (i < this.children.size() - 1) {
                        sb.append(',');
                    }
                    sb.append(System.lineSeparator());
                }
                sb.append(indent2);
                sb.append(']');
            } else {
                sb.append('\"');
            }
            sb.append(System.lineSeparator());
            sb.append(indent);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object obj) {
            TreeNode otherNode = (TreeNode)obj;
            if (otherNode != null) {
                if (!this.data.equals(otherNode.data)) {
                    return false;
                }
                if (otherNode.children.size() != this.children.size()) {
                    System.err.println("MISMATCH: Child span counts don't match: " + this.children.size() + " ; " + otherNode.children.size());
                    return false;
                }
                for (int i = 0; i < this.children.size(); ++i) {
                    TreeNode<T> y;
                    TreeNode<T> x = this.children.get(i);
                    if (x.equals(y = otherNode.children.get(i))) continue;
                    return false;
                }
                return true;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public void visitTree(Consumer<? super T> visitor) {
            visitor.accept(this.data);
            for (TreeNode<T> child : this.children) {
                child.visitTree(visitor);
            }
        }

        public String toString() {
            return this.toJSON(this.data.getClass().getSimpleName(), 1, "  ");
        }
    }
}

