/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.tags;

import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.tck.tags.GaugeTagMethodBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class GaugeTagMethodBeanTest {
    private static final String GAUGE_NAME = MetricRegistry.name(GaugeTagMethodBean.class, (String[])new String[]{"gaugeMethod"});
    private static final Tag NUMBER_ONE_TAG = new Tag("number", "one");
    private static final Tag NUMBER_TWO_TAG = new Tag("number", "two");
    private static MetricID gaugeOneMID;
    private static MetricID gaugeTwoMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private GaugeTagMethodBean bean;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(GaugeTagMethodBean.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBean() {
        this.bean.getGaugeOne();
        this.bean.getGaugeTwo();
        gaugeOneMID = new MetricID(GAUGE_NAME, new Tag[]{NUMBER_ONE_TAG});
        gaugeTwoMID = new MetricID(GAUGE_NAME, new Tag[]{NUMBER_TWO_TAG});
    }

    @Test
    @InSequence(value=1)
    public void gaugeTagCalledWithDefaultValue() {
        Gauge gaugeOne = this.registry.getGauge(gaugeOneMID);
        Gauge gaugeTwo = this.registry.getGauge(gaugeTwoMID);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)gaugeOne, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)gaugeTwo, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Gauge value is incorrect", (Object)((Long)gaugeOne.getValue()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)((Long)gaugeTwo.getValue()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    @InSequence(value=2)
    public void callGaugeTagAfterSetterCall() {
        Gauge gaugeOne = this.registry.getGauge(gaugeOneMID);
        Gauge gaugeTwo = this.registry.getGauge(gaugeTwoMID);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)gaugeOne, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)gaugeTwo, (Matcher)Matchers.notNullValue());
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.setGaugeOne(value);
        long secondValue = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.setGaugeTwo(secondValue);
        Assert.assertThat((String)"Gauge value is incorrect", (Object)((Long)gaugeOne.getValue()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)((Long)gaugeTwo.getValue()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)secondValue)));
    }
}

