/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql.tck.dynamic;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.graphql.tck.dynamic.DeployableUnit;
import org.eclipse.microprofile.graphql.tck.dynamic.schema.SchemaTestDataProvider;
import org.eclipse.microprofile.graphql.tck.dynamic.schema.TestData;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SchemaDynamicValidityTest
extends Arquillian {
    private static final Logger LOG = Logger.getLogger(SchemaDynamicValidityTest.class.getName());
    private static final String FILENAME = "schema.graphql";
    private static final String PATH = "graphql/schema.graphql";
    private String schema;
    @ArquillianResource
    private URI uri;
    private static final String FS = System.getProperty("file.separator");

    @Deployment
    public static Archive<?> getDeployment() throws Exception {
        return DeployableUnit.getDeployment("tck-schematest");
    }

    @RunAsClient
    @Test(priority=1)
    public void testResponse() throws IOException {
        LOG.log(Level.INFO, "Fetching schema from {0}", this.uri);
        this.schema = this.getSchemaContent();
        this.saveSchemaFile();
        Assert.assertTrue((this.schema.length() > 0 ? 1 : 0) != 0, (String)("No Content in the GraphQL Schema downloaded from [" + this.uri + "]"));
    }

    @RunAsClient
    @Test(priority=2, dataProvider="schemaSnippets", dataProviderClass=SchemaTestDataProvider.class)
    public void testPartsOfSchema(TestData input) {
        Assert.assertNotNull((Object)this.schema, (String)"No schema avalailable to test against");
        String snippet = this.schema;
        if (input.getSnippetSearchTerm() != null) {
            snippet = this.getSchemaSnippet(this.schema, input.getSnippetSearchTerm());
        }
        Assert.assertTrue((boolean)this.matchAtLeastOneOfTheSnippets(input, snippet), (String)("[" + input.getHeader() + "] " + input.getErrorMessage()));
    }

    private boolean matchAtLeastOneOfTheSnippets(TestData input, String snippet) {
        List<String> containsAnyOfString = input.getContainsAnyOfString();
        for (String contains : containsAnyOfString) {
            if (!(contains.startsWith("!") ? !snippet.contains(contains = contains.substring(1)) : snippet.contains(contains))) continue;
            return true;
        }
        return false;
    }

    private void saveSchemaFile() {
        try {
            Path downloadedSchema = Paths.get("target" + FS + FILENAME, new String[0]);
            Path createFile = Files.createFile(downloadedSchema, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(createFile, Charset.forName("UTF-8"), new OpenOption[0]);){
                writer.write(this.schema);
            }
            LOG.log(Level.INFO, "Schema written to {0}", createFile.toUri());
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Could not save schema file to target" + FS + FILENAME + " - {0}", ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSchemaContent() throws MalformedURLException, ProtocolException, IOException {
        URL url = new URL(this.uri + PATH);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "text/plain");
            int responseCode = connection.getResponseCode();
            Assert.assertEquals((int)responseCode, (int)200, (String)("While testing [" + url.toString() + "]"));
            String string = this.getContent(connection);
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String getSchemaSnippet(String schema, String section) {
        int index = schema.indexOf(section);
        Assert.assertTrue((index > -1 ? 1 : 0) != 0, (String)("Cannot find " + section + " in schema"));
        char[] schemaChars = schema.toCharArray();
        int closePos = schema.indexOf("{", index) + 1;
        int counter = 1;
        while (counter > 0 && closePos < schemaChars.length - 1) {
            char c;
            if ((c = schemaChars[++closePos]) == '{') {
                ++counter;
                continue;
            }
            if (c != '}') continue;
            --counter;
        }
        return schema.substring(index, closePos);
    }

    /*
     * Exception decompiling
     */
    private String getContent(HttpURLConnection connection) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

