/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes.oql.contentAssist;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.ContentAssistElement;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.ContextExtractor;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.SuggestionProvider;

public class OQLContentAssistantProcessor
implements IContentAssistProcessor {
    private SuggestionProvider suggestionProvider;
    private IContextInformation[] last;
    private ContextExtractor extractor;

    public OQLContentAssistantProcessor(SuggestionProvider suggestionProvider, ContextExtractor extractor) {
        this.suggestionProvider = suggestionProvider;
        this.extractor = extractor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer arg0, int arg1) {
        String context = this.extractor.getPrefix(arg0, arg1);
        List<ContentAssistElement> suggestions = this.suggestionProvider.getSuggestions(context);
        return this.buildResult(suggestions, arg1, context.length());
    }

    public IContextInformation[] computeContextInformation(ITextViewer arg0, int arg1) {
        int paren;
        String context = this.extractor.getPrefix(arg0, arg1);
        if (context.length() == 0) {
            context = this.extractor.getPrefix(arg0, arg1 - 1);
        }
        if ((paren = context.indexOf(40)) >= 0) {
            context = context.substring(0, paren + 1);
        }
        List<ContentAssistElement> suggestions = this.suggestionProvider.getSuggestions(context);
        if (!context.startsWith("\"") && paren == -1) {
            Iterator<ContentAssistElement> it = suggestions.iterator();
            while (it.hasNext()) {
                ContentAssistElement ce = it.next();
                if (ce.getClassName().equals(context)) continue;
                it.remove();
            }
        }
        IContextInformation[] ret = new IContextInformation[suggestions.size()];
        int c = 0;
        for (ContentAssistElement ce : suggestions) {
            ContextInformation ct = new ContextInformation(ce.getImage(), ce.getDisplayString(), ce.getClassName());
            ret[c++] = ct;
        }
        if (c > 0) {
            this.setLastContextInformation(ret);
        }
        return ret;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '\"'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{' ', '(', '.'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }

    public String getErrorMessage() {
        return null;
    }

    private ICompletionProposal[] buildResult(List<ContentAssistElement> suggestions, int currentCursor, int replaceLength) {
        if (suggestions == null) {
            throw new IllegalArgumentException("Cannot produce a suggestion. List is null");
        }
        ICompletionProposal[] retProposals = new ICompletionProposal[suggestions.size()];
        Iterator<ContentAssistElement> it = suggestions.iterator();
        int c = 0;
        while (it.hasNext()) {
            ContentAssistElement cp = it.next();
            String classname = cp.getClassName();
            CompletionProposal completion = new CompletionProposal(classname, currentCursor - replaceLength, replaceLength, currentCursor - replaceLength + classname.length(), cp.getImage(), cp.getDisplayString(), null, null);
            retProposals[c] = completion;
            ++c;
        }
        return retProposals;
    }

    public IContextInformation[] getLastContextInformation() {
        return this.last;
    }

    public void setLastContextInformation(IContextInformation[] last) {
        this.last = last;
    }
}

