/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.filtering;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.wtp.DomUtils;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.filtering.ResourceFilteringConfiguration;
import org.eclipse.m2e.wtp.internal.filtering.ResourceFilteringConfigurationFactory;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.ThreadBuildContext;

public class ResourceFilteringBuildParticipant
extends AbstractBuildParticipant {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceFilteringBuildParticipant.class);
    private CleanBuildContext forceCopyBuildContext;

    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        IMavenProjectFacade facade = this.getMavenProjectFacade();
        ResourceFilteringConfiguration configuration = ResourceFilteringConfigurationFactory.getConfiguration(facade);
        List<Xpp3Dom> resources = null;
        if (configuration == null || (resources = configuration.getResources()) == null) {
            return null;
        }
        IProject project = facade.getProject();
        IPath targetFolder = configuration.getTargetFolder();
        IResourceDelta delta = this.getDelta(project);
        BuildContext oldBuildContext = ThreadBuildContext.getContext();
        try {
            this.forceCopyBuildContext = null;
            List<String> filters = configuration.getFilters();
            if (!project.getFolder(targetFolder).exists() || this.changeRequiresForcedCopy(facade, filters, delta)) {
                LOG.info(NLS.bind((String)Messages.ResourceFilteringBuildParticipant_Changed_Resources_Require_Clean_Build, (Object)project.getName()));
                this.forceCopyBuildContext = new CleanBuildContext(oldBuildContext);
                ThreadBuildContext.setThreadBuildContext((BuildContext)this.forceCopyBuildContext);
            }
            if (this.forceCopyBuildContext != null || this.hasResourcesChanged(facade, delta, resources)) {
                LOG.info(NLS.bind((String)Messages.ResourceFilteringBuildParticipant_Executing_Resource_Filtering, (Object)project.getName()));
                this.executeCopyResources(facade, configuration, targetFolder, resources, monitor);
                IFolder destFolder = project.getFolder(targetFolder);
                if (destFolder.exists()) {
                    destFolder.refreshLocal(2, monitor);
                }
            }
        }
        finally {
            ThreadBuildContext.setThreadBuildContext((BuildContext)oldBuildContext);
        }
        return null;
    }

    protected BuildContext getBuildContext() {
        return this.forceCopyBuildContext == null ? super.getBuildContext() : this.forceCopyBuildContext;
    }

    private boolean changeRequiresForcedCopy(IMavenProjectFacade facade, List<String> filters, IResourceDelta delta) {
        if (delta == null) {
            return false;
        }
        if (delta.findMember(facade.getPom().getProjectRelativePath()) != null) {
            return true;
        }
        for (String filter : filters) {
            IPath filterPath = facade.getProjectRelativePath(filter);
            if (filterPath == null) {
                filterPath = Path.fromOSString((String)filter);
            }
            if (delta.findMember(filterPath) == null) continue;
            return true;
        }
        return false;
    }

    public void clean(IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = this.getMavenProjectFacade();
        ResourceFilteringConfiguration configuration = ResourceFilteringConfigurationFactory.getConfiguration(facade);
        if (configuration == null) {
            return;
        }
        IProject project = facade.getProject();
        IPath targetFolderPath = configuration.getTargetFolder();
        this.deleteFilteredResources(project, targetFolderPath);
        super.clean(monitor);
    }

    private void deleteFilteredResources(IProject project, IPath targetFolderPath) throws CoreException {
        IFolder targetFolder = project.getFolder(targetFolderPath);
        if (targetFolder.exists()) {
            IContainer parent = targetFolder.getParent();
            LOG.info(NLS.bind((String)Messages.ResourceFilteringBuildParticipant_Cleaning_Filtered_Folder, (Object)project.getName()));
            NullProgressMonitor monitor = new NullProgressMonitor();
            targetFolder.delete(true, (IProgressMonitor)monitor);
            if (parent != null) {
                parent.refreshLocal(2, (IProgressMonitor)monitor);
            }
        }
    }

    private boolean hasResourcesChanged(IMavenProjectFacade facade, IResourceDelta delta, List<Xpp3Dom> resources) {
        if (resources == null || resources.isEmpty()) {
            return false;
        }
        Set<IPath> resourcePaths = this.getResourcePaths(facade, resources);
        if (delta == null) {
            return !resourcePaths.isEmpty();
        }
        for (IPath resourcePath : resourcePaths) {
            IResourceDelta member = delta.findMember(resourcePath);
            if (member == null) continue;
            return true;
        }
        return false;
    }

    private Set<IPath> getResourcePaths(IMavenProjectFacade facade, List<Xpp3Dom> resources) {
        LinkedHashSet<IPath> resourcePaths = new LinkedHashSet<IPath>();
        for (Xpp3Dom resource : resources) {
            String dir;
            IPath folder = null;
            Xpp3Dom xpp3Directory = resource.getChild("directory");
            if (xpp3Directory != null && StringUtils.isNotEmpty((String)(dir = xpp3Directory.getValue()))) {
                folder = WTPProjectsUtil.tryProjectRelativePath(facade.getProject(), dir);
            }
            if (folder == null || folder.isEmpty()) continue;
            resourcePaths.add(folder);
        }
        return resourcePaths;
    }

    private void executeCopyResources(IMavenProjectFacade facade, ResourceFilteringConfiguration filteringConfiguration, IPath targetFolder, List<Xpp3Dom> resources, IProgressMonitor monitor) throws CoreException {
        List<String> filters = filteringConfiguration.getFilters();
        IMavenExecutionContext executionContext = facade.createExecutionContext();
        MavenExecutionRequest request = executionContext.getExecutionRequest();
        request.setRecursive(false);
        request.setOffline(true);
        IMaven maven = MavenPlugin.getMaven();
        MavenProject mavenProject = facade.getMavenProject();
        MavenExecutionPlan executionPlan = maven.calculateExecutionPlan(mavenProject, Collections.singletonList("resources:copy-resources"), true, monitor);
        MojoExecution copyFilteredResourcesMojo = this.getExecution(executionPlan, "maven-resources-plugin");
        if (copyFilteredResourcesMojo == null) {
            return;
        }
        Xpp3Dom originalConfig = copyFilteredResourcesMojo.getConfiguration();
        Xpp3Dom configuration = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)new Xpp3Dom("configuration"), (Xpp3Dom)originalConfig);
        boolean parentHierarchyLoaded = false;
        try {
            this.setupResources(configuration, resources);
            this.setValue(configuration, "overwrite", Boolean.TRUE);
            this.setupDelimiters(configuration);
            this.setValue(configuration, "outputDirectory", targetFolder.toPortableString());
            this.setValue(configuration, "escapeString", filteringConfiguration.getEscapeString());
            this.setNonfilteredExtensions(configuration, filteringConfiguration.getNonfilteredExtensions());
            this.setupFilters(configuration, filters);
            request.setRecursive(false);
            request.setOffline(true);
            copyFilteredResourcesMojo.setConfiguration(configuration);
            copyFilteredResourcesMojo.getMojoDescriptor().setGoal("copy-resources");
            executionContext.execute(facade.getMavenProject(monitor), copyFilteredResourcesMojo, monitor);
        }
        finally {
            copyFilteredResourcesMojo.setConfiguration(originalConfig);
            if (parentHierarchyLoaded) {
                mavenProject.setParent(null);
            }
        }
    }

    private void setNonfilteredExtensions(Xpp3Dom configuration, List<Xpp3Dom> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        Xpp3Dom nonFilteredFileExtensionsNode = configuration.getChild("nonFilteredFileExtensions");
        if (nonFilteredFileExtensionsNode == null) {
            nonFilteredFileExtensionsNode = new Xpp3Dom("nonFilteredFileExtensions");
            configuration.addChild(nonFilteredFileExtensionsNode);
        } else {
            DomUtils.removeChildren(nonFilteredFileExtensionsNode);
        }
        for (Xpp3Dom ext : extensions) {
            nonFilteredFileExtensionsNode.addChild(ext);
        }
    }

    private void setValue(Xpp3Dom configuration, String childName, Object value) {
        Xpp3Dom childNode = configuration.getChild(childName);
        if (childNode == null) {
            childNode = new Xpp3Dom(childName);
            configuration.addChild(childNode);
        }
        childNode.setValue(value == null ? null : value.toString());
    }

    private void setupFilters(Xpp3Dom configuration, List<String> filters) {
        if (!filters.isEmpty()) {
            Xpp3Dom filtersNode = configuration.getChild("filters");
            if (filtersNode == null) {
                filtersNode = new Xpp3Dom("filters");
                configuration.addChild(filtersNode);
            } else {
                DomUtils.removeChildren(filtersNode);
            }
            for (String filter : filters) {
                Xpp3Dom filterNode = new Xpp3Dom("filter");
                Path filterPath = new Path(filter);
                boolean isAbsolute = false;
                if (filter.startsWith("${basedir}") || filter.startsWith("/") || filterPath.getDevice() != null) {
                    isAbsolute = true;
                }
                String filterAbsolutePath = isAbsolute ? filter : "${basedir}/" + filter;
                filterNode.setValue(filterAbsolutePath);
                filtersNode.addChild(filterNode);
            }
        }
    }

    private void setupDelimiters(Xpp3Dom configuration) {
        Xpp3Dom useDefaultDelimitersNode = configuration.getChild("useDefaultDelimiters");
        if (useDefaultDelimitersNode == null) {
            useDefaultDelimitersNode = new Xpp3Dom("useDefaultDelimiters");
            configuration.addChild(useDefaultDelimitersNode);
        }
        useDefaultDelimitersNode.setValue(Boolean.FALSE.toString());
        Xpp3Dom delimitersNode = configuration.getChild("delimiters");
        if (delimitersNode == null) {
            delimitersNode = new Xpp3Dom("delimiters");
            configuration.addChild(delimitersNode);
        } else {
            DomUtils.removeChildren(delimitersNode);
        }
        Xpp3Dom delimiter = new Xpp3Dom("delimiter");
        delimiter.setValue("${*}");
        delimitersNode.addChild(delimiter);
    }

    private void setupResources(Xpp3Dom configuration, List<Xpp3Dom> resources) {
        Xpp3Dom resourcesNode = configuration.getChild("resources");
        if (resourcesNode == null) {
            resourcesNode = new Xpp3Dom("resources");
            configuration.addChild(resourcesNode);
        } else {
            resourcesNode.setAttribute("default-value", "");
            DomUtils.removeChildren(resourcesNode);
        }
        for (Xpp3Dom resource : resources) {
            resourcesNode.addChild(resource);
        }
    }

    private MojoExecution getExecution(MavenExecutionPlan executionPlan, String artifactId) {
        if (executionPlan == null) {
            return null;
        }
        for (MojoExecution execution : executionPlan.getMojoExecutions()) {
            if (!artifactId.equals(execution.getArtifactId())) continue;
            return execution;
        }
        return null;
    }

    private static class CleanBuildContext
    implements BuildContext {
        private BuildContext originalContext;

        CleanBuildContext(BuildContext originalContext) {
            this.originalContext = originalContext;
        }

        public boolean hasDelta(String relpath) {
            return true;
        }

        public boolean hasDelta(File file) {
            return true;
        }

        public boolean hasDelta(List relpaths) {
            return true;
        }

        public void refresh(File file) {
            this.originalContext.refresh(file);
        }

        public OutputStream newFileOutputStream(File file) throws IOException {
            return this.originalContext.newFileOutputStream(file);
        }

        public Scanner newScanner(File basedir) {
            return this.originalContext.newScanner(basedir);
        }

        public Scanner newDeleteScanner(File basedir) {
            return this.originalContext.newDeleteScanner(basedir);
        }

        public Scanner newScanner(File basedir, boolean ignoreDelta) {
            return this.originalContext.newScanner(basedir, ignoreDelta);
        }

        public boolean isIncremental() {
            return false;
        }

        public void setValue(String key, Object value) {
            this.originalContext.setValue(key, value);
        }

        public Object getValue(String key) {
            return this.originalContext.getValue(key);
        }

        public void addWarning(File file, int line, int column, String message, Throwable cause) {
            this.originalContext.addWarning(file, line, column, message, cause);
        }

        public void addError(File file, int line, int column, String message, Throwable cause) {
            this.originalContext.addError(file, line, column, message, cause);
        }

        public void addMessage(File file, int line, int column, String message, int severity, Throwable cause) {
            this.originalContext.addMessage(file, line, column, message, severity, cause);
        }

        public void removeMessages(File file) {
            this.originalContext.removeMessages(file);
        }

        public boolean isUptodate(File target, File source) {
            return false;
        }
    }
}

