/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.jaxrs.java;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.PropertiesManagerForJava;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.junit.Assert;
import org.junit.Test;

public class JaxRsApplicationPathCodeLensTest
extends BasePropertiesManagerTest {
    @Test
    public void urlCodeLensApplicationPath() throws Exception {
        IJavaProject javaProject = JaxRsApplicationPathCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_applicationpath);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/ApplicationPathResource.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        JaxRsApplicationPathCodeLensTest.saveFile("org/acme/MyApplication.java", "package org.acme;\r\nimport javax.ws.rs.ApplicationPath;\r\nimport javax.ws.rs.core.Application;\r\n@ApplicationPath(\"/api\")\r\npublic class MyApplication extends Application {}\r\n", javaProject, true);
        JaxRsApplicationPathCodeLensTest.assertCodeLense(8080, params, utils, "/api/path");
    }

    @Test
    public void urlCodeLensApplicationPathNoSlash() throws Exception {
        IJavaProject javaProject = JaxRsApplicationPathCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_applicationpath);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/ApplicationPathResource.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        JaxRsApplicationPathCodeLensTest.saveFile("org/acme/MyApplication.java", "package org.acme;\r\nimport javax.ws.rs.ApplicationPath;\r\nimport javax.ws.rs.core.Application;\r\n@ApplicationPath(\"api\")\r\npublic class MyApplication extends Application {}\r\n", javaProject, true);
        JaxRsApplicationPathCodeLensTest.assertCodeLense(8080, params, utils, "/api/path");
    }

    @Test
    public void urlCodeLensApplicationPathChange() throws Exception {
        IJavaProject javaProject = JaxRsApplicationPathCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_applicationpath);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/ApplicationPathResource.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        JaxRsApplicationPathCodeLensTest.saveFile("org/acme/MyApplication.java", "package org.acme;\r\nimport javax.ws.rs.ApplicationPath;\r\nimport javax.ws.rs.core.Application;\r\n@ApplicationPath(\"/api\")\r\npublic class MyApplication extends Application {}\r\n", javaProject, true);
        JaxRsApplicationPathCodeLensTest.assertCodeLense(8080, params, utils, "/api/path");
        JaxRsApplicationPathCodeLensTest.saveFile("org/acme/MyApplication.java", "package org.acme;\r\nimport javax.ws.rs.ApplicationPath;\r\nimport javax.ws.rs.core.Application;\r\n@ApplicationPath(\"/ipa\")\r\npublic class MyApplication extends Application {}\r\n", javaProject, true);
        JaxRsApplicationPathCodeLensTest.assertCodeLense(8080, params, utils, "/ipa/path");
    }

    private static void assertCodeLense(int port, MicroProfileJavaCodeLensParams params, IJDTUtils utils, String actualEndpoint) throws JavaModelException {
        List lenses = PropertiesManagerForJava.getInstance().codeLens(params, utils, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)1L, (long)lenses.size());
        CodeLens lenseForEndpoint = (CodeLens)lenses.get(0);
        Assert.assertNotNull((Object)lenseForEndpoint.getCommand());
        Assert.assertEquals((Object)("http://localhost:" + port + actualEndpoint), (Object)lenseForEndpoint.getCommand().getTitle());
    }
}

