/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.jobs.IBackgroundProcessingQueue;

public final class JobHelpers {
    private static final int POLLING_DELAY = 10;
    public static final int MAX_TIME_MILLIS = 300000;

    private JobHelpers() {
    }

    public static void waitForJobsToComplete() {
        try {
            JobHelpers.waitForJobsToComplete((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static void waitForJobsToComplete(IProgressMonitor monitor) throws InterruptedException, CoreException {
        JobHelpers.waitForBuildJobs();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IJobManager jobManager = Job.getJobManager();
        jobManager.suspend();
        try {
            Job[] jobs = jobManager.find(null);
            int i = 0;
            while (i < jobs.length) {
                if (jobs[i] instanceof WorkspaceJob || jobs[i].getClass().getName().endsWith("JREUpdateJob")) {
                    jobs[i].join();
                }
                ++i;
            }
            workspace.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                }
            }, (ISchedulingRule)workspace.getRoot(), 0, monitor);
            boolean processed = JobHelpers.flushProcessingQueues(jobManager, monitor);
            int i2 = 0;
            while (i2 < 10 && processed) {
                processed = JobHelpers.flushProcessingQueues(jobManager, monitor);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                ++i2;
            }
            if (processed) {
                JavaLanguageServerPlugin.logInfo((String)("Could not flush background processing queues: " + JobHelpers.getProcessingQueues(jobManager)));
            }
        }
        finally {
            jobManager.resume();
        }
        JobHelpers.waitForBuildJobs();
    }

    private static boolean flushProcessingQueues(IJobManager jobManager, IProgressMonitor monitor) throws InterruptedException, CoreException {
        boolean processed = false;
        for (IBackgroundProcessingQueue queue : JobHelpers.getProcessingQueues(jobManager)) {
            queue.join();
            if (!queue.isEmpty()) {
                Deque context = MavenExecutionContext.suspend();
                try {
                    IStatus status = queue.run(monitor);
                    if (!status.isOK()) {
                        throw new CoreException(status);
                    }
                    processed = true;
                }
                finally {
                    MavenExecutionContext.resume((Deque)context);
                }
            }
            if (!queue.isEmpty()) continue;
            queue.cancel();
        }
        return processed;
    }

    private static List<IBackgroundProcessingQueue> getProcessingQueues(IJobManager jobManager) {
        ArrayList<IBackgroundProcessingQueue> queues = new ArrayList<IBackgroundProcessingQueue>();
        Job[] jobArray = jobManager.find(null);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job instanceof IBackgroundProcessingQueue) {
                queues.add((IBackgroundProcessingQueue)job);
            }
            ++n2;
        }
        return queues;
    }

    private static void waitForBuildJobs() {
        JobHelpers.waitForBuildJobs(300000);
    }

    public static void waitForBuildJobs(int maxTimeMilis) {
        JobHelpers.waitForJobs(BuildJobMatcher.INSTANCE, maxTimeMilis);
    }

    public static void waitForInitializeJobs() {
        JobHelpers.waitForJobs(InitializeJobMatcher.INSTANCE, 300000);
    }

    public static void waitForDownloadSourcesJobs(int maxTimeMillis) {
        JobHelpers.waitForJobs(DownloadSourcesJobMatcher.INSTANCE, maxTimeMillis);
    }

    public static void waitForJobs(IJobMatcher matcher, int maxWaitMillis) {
        Job job;
        long limit = System.currentTimeMillis() + (long)maxWaitMillis;
        while (true) {
            boolean timeout;
            if ((job = JobHelpers.getJob(matcher)) == null) {
                return;
            }
            boolean bl = timeout = System.currentTimeMillis() > limit;
            if (timeout) break;
            job.wakeUp();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        JavaLanguageServerPlugin.logInfo((String)("Timeout while waiting for completion of job: " + job));
    }

    private static Job getJob(IJobMatcher matcher) {
        Job[] jobs;
        Job[] jobArray = jobs = Job.getJobManager().find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (matcher.matches(job)) {
                return job;
            }
            ++n2;
        }
        return null;
    }

    static class BuildJobMatcher
    implements IJobMatcher {
        public static final IJobMatcher INSTANCE = new BuildJobMatcher();

        BuildJobMatcher() {
        }

        @Override
        public boolean matches(Job job) {
            return job instanceof WorkspaceJob || job.getClass().getName().matches("(.*\\.AutoBuild.*)") || job.getClass().getName().endsWith("JREUpdateJob");
        }
    }

    static class DownloadSourcesJobMatcher
    implements IJobMatcher {
        public static final IJobMatcher INSTANCE = new DownloadSourcesJobMatcher();

        DownloadSourcesJobMatcher() {
        }

        @Override
        public boolean matches(Job job) {
            return "org.eclipse.m2e.jdt.internal.DownloadSourcesJob".equals(job.getClass().getName());
        }
    }

    static interface IJobMatcher {
        public boolean matches(Job var1);
    }

    static class InitializeJobMatcher
    implements IJobMatcher {
        public static final IJobMatcher INSTANCE = new InitializeJobMatcher();

        InitializeJobMatcher() {
        }

        @Override
        public boolean matches(Job job) {
            return job.belongsTo((Object)"java-ls-initialization-jobs");
        }
    }
}

