/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.jax_rs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.jdt.codeAction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.codeAction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.RemoveParamsProposal;
import org.eclipse.lsp4jakarta.jdt.core.jax_rs.Jax_RSConstants;

public class ResourceMethodMultipleEntityParamsQuickFix
implements IJavaCodeActionParticipant {
    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ASTNode node = context.getCoveredNode();
        MethodDeclaration parentNode = (MethodDeclaration)node.getParent();
        IMethodBinding parentMethod = parentNode.resolveBinding();
        if (parentMethod != null) {
            ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
            List params = parentNode.parameters();
            ArrayList<SingleVariableDeclaration> entityParams = new ArrayList<SingleVariableDeclaration>();
            for (SingleVariableDeclaration param : params) {
                if (!this.isEntityParam(param)) continue;
                entityParams.add(param);
            }
            for (SingleVariableDeclaration entityParam : entityParams) {
                String TITLE_MESSAGE = "Remove all entity parameters except " + entityParam.getName().getIdentifier();
                RemoveParamsProposal proposal = new RemoveParamsProposal(TITLE_MESSAGE, context.getCompilationUnit(), context.getASTRoot(), (IBinding)parentMethod, 0, entityParams, entityParam);
                CodeAction codeAction = context.convertToCodeAction(proposal, diagnostic);
                codeAction.setTitle(TITLE_MESSAGE);
                codeActions.add(codeAction);
            }
            return codeActions;
        }
        return null;
    }

    private boolean isEntityParam(SingleVariableDeclaration param) {
        ArrayList<String> nonEntityParamAnnotations = Jax_RSConstants.NON_ENTITY_PARAM_ANNOTATIONS;
        boolean isEntityParam = true;
        for (IExtendedModifier modifier : param.modifiers()) {
            Name typeName;
            if (!modifier.isAnnotation() || !nonEntityParamAnnotations.contains((typeName = ((Annotation)modifier).getTypeName()).toString())) continue;
            isEntityParam = false;
            break;
        }
        return isEntityParam;
    }
}

