/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.utils;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.internal.ArrayUtil;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;

public class TestUtils {
    private static final Set<File> tempFiles = new HashSet<File>();

    private TestUtils() {
    }

    public static ITextViewer openTextViewer(IFile file) throws PartInitException {
        IEditorPart editor = TestUtils.openEditor(file);
        TestUtils.waitForAndAssertCondition(5000, () -> LSPEclipseUtils.getTextViewer((IEditorPart)editor) != null);
        return LSPEclipseUtils.getTextViewer((IEditorPart)editor);
    }

    public static IEditorPart openEditor(IFile file) throws PartInitException {
        FileEditorInput input;
        IWorkbenchWindow workbenchWindow = UI.getActiveWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart part = page.openEditor((IEditorInput)(input = new FileEditorInput(file)), "org.eclipse.ui.genericeditor.GenericEditor", false);
        if (part != null) {
            part.setFocus();
        }
        return part;
    }

    public static List<IEditorReference> splitActiveEditor() {
        IWorkbenchWindow workbenchWindow = UI.getActiveWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart part = page.getActiveEditor();
        MPart editorPart = (MPart)part.getSite().getService(MPart.class);
        if (editorPart != null) {
            editorPart.getTags().add("Split Horizontal");
        }
        return List.of(page.getEditorReferences());
    }

    public static IEditorPart openExternalFileInEditor(File file) throws PartInitException {
        IWorkbenchWindow workbenchWindow = UI.getActiveWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (URI)file.toURI(), (String)"org.eclipse.ui.genericeditor.GenericEditor", (boolean)false);
        if (part != null) {
            part.setFocus();
        }
        return part;
    }

    public static IEditorPart getEditor(IFile file) {
        IWorkbenchWindow workbenchWindow = UI.getActiveWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        FileEditorInput input = new FileEditorInput(file);
        return List.of(page.getEditorReferences()).stream().filter(r -> {
            try {
                return r.getEditorInput().equals(input);
            }
            catch (PartInitException e) {
                return false;
            }
        }).map(r -> r.getEditor(false)).findAny().orElse(null);
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchWindow workbenchWindow = UI.getActiveWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        return page.getActiveEditor();
    }

    public static boolean closeEditor(IEditorPart editor, boolean save) {
        IWorkbenchWindow workbenchWindow = UI.getActiveWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        return page.closeEditor(editor, save);
    }

    public static IProject createProject(String projectName) throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject(projectName);
        if (project.exists() && project.isOpen()) {
            return project;
        }
        ws.run(monitor -> {
            if (!project.exists()) {
                project.create(null);
            }
            project.open(null);
        }, (ISchedulingRule)ws.getRoot(), 1, null);
        return project;
    }

    public static IProject createNestedProject(IProject parent, String projectName) throws CoreException {
        IFolder nestedFolder = parent.getFolder(projectName);
        nestedFolder.create(true, true, null);
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject(projectName);
        if (project.exists() && project.isOpen()) {
            return project;
        }
        ws.run(monitor -> {
            if (!project.exists()) {
                IProjectDescription desc = ws.newProjectDescription(projectName);
                desc.setLocation(nestedFolder.getLocation());
                project.create(desc, null);
            }
            project.open(null);
        }, (ISchedulingRule)ws.getRoot(), 1, null);
        return project;
    }

    public static IFile createUniqueTestFile(IProject p, String content) throws CoreException {
        return TestUtils.createUniqueTestFile(p, "lspt", content);
    }

    public static IFile createUniqueTestFileMultiLS(IProject p, String content) throws CoreException {
        return TestUtils.createUniqueTestFile(p, "lsptmultils", content);
    }

    public static IFile createUniqueTestFileOfUnknownType(IProject p, String content) throws CoreException {
        return TestUtils.createUniqueTestFile(p, "lsptunknown", content);
    }

    public static synchronized IFile createUniqueTestFile(IProject p, String extension, String content) throws CoreException {
        long fileNameSalt = System.currentTimeMillis();
        if (p == null) {
            p = ResourcesPlugin.getWorkspace().getRoot().getProject(Long.toString(fileNameSalt));
            p.create(null);
            p.open(null);
        }
        while (p.getFile("test" + fileNameSalt + "." + extension).exists()) {
            ++fileNameSalt;
        }
        return TestUtils.createFile(p, "test" + fileNameSalt + "." + extension, content);
    }

    public static IFile createFile(IProject p, String name, String content) throws CoreException {
        IFile testFile = p.getFile(name);
        testFile.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
        return testFile;
    }

    public static void delete(IProject project) throws CoreException {
        if (project != null) {
            project.delete(true, null);
        }
    }

    public static void delete(IProject ... projects) throws CoreException {
        ArrayUtil.forEach((Object[])projects, TestUtils::delete);
    }

    public static void delete(Path path) throws IOException {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)path, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }

    public static void delete(Path ... paths) throws IOException {
        ArrayUtil.forEach((Object[])paths, TestUtils::delete);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File tmp = File.createTempFile(prefix, suffix);
        tempFiles.add(tmp);
        return tmp;
    }

    public static void addManagedTempFile(File file) {
        tempFiles.add(file);
    }

    public static void tearDown() {
        tempFiles.forEach(file -> {
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        tempFiles.clear();
    }

    public static ContentTypeToLanguageServerDefinition getDisabledLS() {
        return LanguageServersRegistry.getInstance().getContentTypeToLSPExtensions().stream().filter(definition -> "org.eclipse.lsp4e.test.server.disable".equals(((LanguageServersRegistry.LanguageServerDefinition)definition.getValue()).id) && "org.eclipse.lsp4e.test.content-type-disabled".equals(((IContentType)definition.getKey()).toString())).findFirst().get();
    }

    public static Shell findNewShell(Set<Shell> beforeShells, Display display) {
        Shell[] afterShells = (Shell[])ArrayUtil.filter((Object[])display.getShells(), shell -> shell.isVisible() && !beforeShells.contains(shell));
        return afterShells.length > 0 ? afterShells[0] : null;
    }

    public static Table findCompletionSelectionControl(Widget control) {
        if (control instanceof Table) {
            Table table = (Table)control;
            return table;
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Table res = TestUtils.findCompletionSelectionControl((Widget)child);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IEditorReference[] getEditors() {
        IWorkbenchPage wPage;
        IWorkbenchWindow wWindow = UI.getActiveWindow();
        if (wWindow != null && (wPage = wWindow.getActivePage()) != null) {
            return wPage.getEditorReferences();
        }
        return null;
    }

    public static void waitForAndAssertCondition(int timeout_ms, Runnable condition) {
        TestUtils.waitForAndAssertCondition("Condition not met within expected time.", timeout_ms, condition);
    }

    public static void waitForAndAssertCondition(int timeout_ms, Display display, Runnable condition) {
        TestUtils.waitForAndAssertCondition("Condition not met within expected time.", timeout_ms, display, () -> {
            condition.run();
            return true;
        });
    }

    public static void waitForAndAssertCondition(String errorMessage, int timeout_ms, Runnable condition) {
        TestUtils.waitForAndAssertCondition(errorMessage, timeout_ms, UI.getDisplay(), () -> {
            condition.run();
            return true;
        });
    }

    public static void waitForAndAssertCondition(int timeout_ms, Condition condition) {
        TestUtils.waitForAndAssertCondition("Condition not met within expected time.", timeout_ms, condition);
    }

    public static void waitForAndAssertCondition(int timeout_ms, Display display, Condition condition) {
        TestUtils.waitForAndAssertCondition("Condition not met within expected time.", timeout_ms, display, condition);
    }

    public static void waitForAndAssertCondition(String errorMessage, int timeout_ms, Condition condition) {
        TestUtils.waitForAndAssertCondition(errorMessage, timeout_ms, UI.getDisplay(), condition);
    }

    public static void waitForAndAssertCondition(String errorMessage, int timeout_ms, Display display, final Condition condition) {
        final Throwable[] ex = new Throwable[1];
        boolean isConditionMet = new DisplayHelper(){

            protected boolean condition() {
                try {
                    boolean isMet = condition.isMet();
                    ex[0] = null;
                    return isMet;
                }
                catch (AssertionError | Exception e) {
                    ex[0] = e;
                    return false;
                }
            }
        }.waitForCondition(display, (long)timeout_ms, 50L);
        if (ex[0] != null) {
            Throwable throwable = ex[0];
            if (throwable instanceof AssertionError) {
                AssertionError ae = (AssertionError)((Object)throwable);
                throw ae;
            }
            Throwable throwable2 = ex[0];
            if (throwable2 instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable2;
                throw re;
            }
            throw new AssertionError(errorMessage, ex[0]);
        }
        Assert.assertTrue((String)errorMessage, (boolean)isConditionMet);
    }

    public static boolean waitForCondition(int timeout_ms, Condition condition) {
        return TestUtils.waitForCondition(timeout_ms, UI.getDisplay(), condition);
    }

    public static boolean waitForCondition(int timeout_ms, Display display, final Condition condition) {
        final Throwable[] ex = new Throwable[1];
        boolean isConditionMet = new DisplayHelper(){

            protected boolean condition() {
                try {
                    boolean isMet = condition.isMet();
                    ex[0] = null;
                    return isMet;
                }
                catch (AssertionError | Exception e) {
                    ex[0] = e;
                    return false;
                }
            }
        }.waitForCondition(display, (long)timeout_ms, 50L);
        if (ex[0] != null) {
            ex[0].printStackTrace();
        }
        return isConditionMet;
    }

    public void waitForLanguageServerNotRunning(final MockLanguageServer server) {
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return !server.isRunning();
            }
        }.waitForCondition(UI.getDisplay(), 1000L));
    }

    public static Condition numberOfChangesIs(int changes) {
        return () -> MockLanguageServer.INSTANCE.getDidChangeEvents().size() == changes;
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean isMet() throws Exception;
    }

    public static class JobSynchronizer
    extends NullProgressMonitor {
        private final CountDownLatch latch = new CountDownLatch(1);

        public void done() {
            this.latch.countDown();
        }

        public void setCanceled(boolean cancelled) {
            super.setCanceled(cancelled);
            if (cancelled) {
                this.latch.countDown();
            }
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }

        public void worked(int work) {
            this.latch.countDown();
        }
    }
}

