/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.tests.mock;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.lsp4e.tests.mock.MockTextDocumentService;
import org.eclipse.lsp4e.tests.mock.MockWorkspaceService;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeNotebookDocumentParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseNotebookDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenNotebookDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveNotebookDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkOptions;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeProviderOptions;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.LinkedEditingRangeRegistrationOptions;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.TypeHierarchyRegistrationOptions;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.NotebookDocumentService;

public class MockLanguageServer
implements LanguageServer {
    public static final String SUPPORTED_COMMAND_ID = "mock.command";
    public static MockLanguageServer INSTANCE = new MockLanguageServer(MockLanguageServer::defaultServerCapabilities);
    private volatile MockTextDocumentService textDocumentService = new MockTextDocumentService(this::buildMaybeDelayedFuture);
    private final MockWorkspaceService workspaceService = new MockWorkspaceService(this::buildMaybeDelayedFuture);
    private final InitializeResult initializeResult = new InitializeResult();
    private volatile long delay = 0L;
    private volatile Executor delayedExecutor = null;
    private volatile boolean started;
    private final List<LanguageClient> remoteProxies = new CopyOnWriteArrayList<LanguageClient>();
    private final List<CompletableFuture<?>> inFlight = new CopyOnWriteArrayList();

    public static void reset() {
        INSTANCE = new MockLanguageServer(MockLanguageServer::defaultServerCapabilities);
    }

    public static void reset(Supplier<ServerCapabilities> serverConfigurer) {
        INSTANCE = new MockLanguageServer(serverConfigurer);
    }

    protected MockLanguageServer(Supplier<ServerCapabilities> serverConfigurer) {
        this.resetInitializeResult(serverConfigurer);
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        Launcher l = LSPLauncher.createServerLauncher((LanguageServer)INSTANCE, (InputStream)System.in, (OutputStream)System.out);
        Future f = l.startListening();
        INSTANCE.addRemoteProxy((LanguageClient)l.getRemoteProxy());
        f.get();
    }

    public void waitBeforeTearDown() {
        this.inFlight.forEach(future -> {
            try {
                future.join();
            }
            catch (CancellationException | CompletionException e) {
                Object object;
                String string = e.getClass().getSimpleName();
                Object object2 = e.getMessage() == null ? "<null>" : "\"" + e.getMessage();
                Throwable throwable = e.getCause();
                if (throwable instanceof Throwable) {
                    Throwable cause = throwable;
                    object = " caused by " + cause.getClass().getSimpleName() + " with message " + (String)(cause.getMessage() == null ? "<null>" : "\"" + cause.getMessage());
                } else {
                    object = "";
                }
                System.err.println("Error waiting for in flight requests prior to teardown: " + string + " with message " + (String)object2 + (String)object);
            }
        });
    }

    public void addRemoteProxy(LanguageClient remoteProxy) {
        this.textDocumentService.addRemoteProxy(remoteProxy);
        this.remoteProxies.add(remoteProxy);
        this.started = true;
    }

    private void resetInitializeResult(Supplier<ServerCapabilities> serverConfigurer) {
        this.initializeResult.setCapabilities(serverConfigurer.get());
    }

    public <U> CompletableFuture<U> buildMaybeDelayedFuture(U value) {
        Executor delayedExecutor = this.delayedExecutor;
        if (delayedExecutor != null) {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> value, delayedExecutor);
            this.inFlight.add(future);
            return future;
        }
        return CompletableFuture.completedFuture(value);
    }

    public static ServerCapabilities defaultServerCapabilities() {
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
        CompletionOptions completionProvider = new CompletionOptions(Boolean.valueOf(false), null);
        capabilities.setCompletionProvider(completionProvider);
        capabilities.setHoverProvider(Boolean.valueOf(true));
        capabilities.setDefinitionProvider(Boolean.valueOf(true));
        capabilities.setTypeDefinitionProvider(Boolean.TRUE);
        capabilities.setReferencesProvider(Boolean.valueOf(true));
        capabilities.setDocumentFormattingProvider(Boolean.valueOf(true));
        capabilities.setDocumentRangeFormattingProvider(Boolean.valueOf(true));
        capabilities.setCodeActionProvider(Boolean.TRUE);
        capabilities.setCodeLensProvider(new CodeLensOptions(Boolean.valueOf(true)));
        capabilities.setDocumentLinkProvider(new DocumentLinkOptions());
        capabilities.setSignatureHelpProvider(new SignatureHelpOptions());
        capabilities.setDocumentHighlightProvider(Boolean.TRUE);
        capabilities.setExecuteCommandProvider(new ExecuteCommandOptions(List.of(SUPPORTED_COMMAND_ID)));
        RenameOptions prepareRenameProvider = new RenameOptions();
        prepareRenameProvider.setPrepareProvider(Boolean.valueOf(true));
        Either renameEither = Either.forRight((Object)prepareRenameProvider);
        capabilities.setRenameProvider(renameEither);
        capabilities.setColorProvider(Boolean.TRUE);
        capabilities.setDocumentSymbolProvider(Boolean.TRUE);
        capabilities.setLinkedEditingRangeProvider(new LinkedEditingRangeRegistrationOptions());
        capabilities.setTypeHierarchyProvider(new TypeHierarchyRegistrationOptions());
        capabilities.setFoldingRangeProvider(new FoldingRangeProviderOptions());
        return capabilities;
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        return this.buildMaybeDelayedFuture(this.initializeResult);
    }

    public MockTextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public void setTextDocumentService(MockTextDocumentService custom) {
        this.textDocumentService = custom;
    }

    public MockWorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    public void setCompletionList(CompletionList completionList) {
        this.textDocumentService.setMockCompletionList(completionList);
    }

    public void setHover(Hover hover) {
        this.textDocumentService.setMockHover(hover);
    }

    public void setCodeLens(List<CodeLens> codeLens) {
        this.textDocumentService.setMockCodeLenses(codeLens);
    }

    public void setDefinition(List<? extends Location> definitionLocations) {
        this.textDocumentService.setMockDefinitionLocations(definitionLocations);
    }

    public void setDidOpenCallback(CompletableFuture<DidOpenTextDocumentParams> didOpenExpectation) {
        this.textDocumentService.setDidOpenCallback(didOpenExpectation);
    }

    public List<DidChangeTextDocumentParams> getDidChangeEvents() {
        return this.textDocumentService.getDidChangeEvents();
    }

    public void setDidSaveCallback(CompletableFuture<DidSaveTextDocumentParams> didSaveExpectation) {
        this.textDocumentService.setDidSaveCallback(didSaveExpectation);
    }

    public void setDidCloseCallback(CompletableFuture<DidCloseTextDocumentParams> didCloseExpectation) {
        this.textDocumentService.setDidCloseCallback(didCloseExpectation);
    }

    public void setFormattingTextEdits(List<? extends TextEdit> formattingTextEdits) {
        this.textDocumentService.setMockFormattingTextEdits(formattingTextEdits);
    }

    public void setDocumentHighlights(Map<Position, List<? extends DocumentHighlight>> documentHighlights) {
        this.textDocumentService.setDocumentHighlights(documentHighlights);
    }

    public void setLinkedEditingRanges(LinkedEditingRanges linkedEditingRanges) {
        this.textDocumentService.setLinkedEditingRanges(linkedEditingRanges);
    }

    public void setCompletionTriggerChars(Set<String> chars) {
        if (chars != null) {
            this.initializeResult.getCapabilities().getCompletionProvider().setTriggerCharacters(new ArrayList<String>(chars));
        }
    }

    public void setContextInformationTriggerChars(Set<String> chars) {
        if (chars != null) {
            this.initializeResult.getCapabilities().getSignatureHelpProvider().setTriggerCharacters(new ArrayList<String>(chars));
        }
    }

    public void setWillSaveWaitUntil(List<TextEdit> edits) {
        TextDocumentSyncOptions textDocumentSyncOptions = new TextDocumentSyncOptions();
        textDocumentSyncOptions.setWillSaveWaitUntil(Boolean.valueOf(true));
        textDocumentSyncOptions.setSave(Boolean.valueOf(true));
        textDocumentSyncOptions.setChange(TextDocumentSyncKind.Full);
        this.initializeResult.getCapabilities().setTextDocumentSync(textDocumentSyncOptions);
        this.textDocumentService.setWillSaveWaitUntilCallback(edits);
    }

    public InitializeResult getInitializeResult() {
        return this.initializeResult;
    }

    public CompletableFuture<Object> shutdown() {
        this.started = false;
        return this.buildMaybeDelayedFuture(Collections.emptySet());
    }

    public void exit() {
    }

    public void setTimeToProceedQueries(long delayInMS) {
        this.delay = delayInMS;
        this.delayedExecutor = CompletableFuture.delayedExecutor(delayInMS, TimeUnit.MILLISECONDS);
    }

    public void setDiagnostics(List<Diagnostic> diagnostics) {
        this.textDocumentService.setDiagnostics(diagnostics);
    }

    public void setCodeActions(List<Either<Command, CodeAction>> codeActions) {
        this.textDocumentService.setCodeActions(codeActions);
    }

    public void setSignatureHelp(SignatureHelp signatureHelp) {
        this.textDocumentService.setSignatureHelp(signatureHelp);
    }

    public void setDocumentLinks(List<DocumentLink> documentLinks) {
        this.textDocumentService.setMockDocumentLinks(documentLinks);
    }

    public void setTypeDefinitions(List<LocationLink> locations) {
        this.textDocumentService.setMockTypeDefinitions(locations);
    }

    public boolean isRunning() {
        return this.started;
    }

    public List<LanguageClient> getRemoteProxies() {
        return this.remoteProxies;
    }

    public void setDocumentSymbols(DocumentSymbol documentSymbol) {
        this.textDocumentService.setDocumentSymbols(List.of(documentSymbol));
    }

    public void setDocumentSymbols(DocumentSymbol ... documentSymbols) {
        this.textDocumentService.setDocumentSymbols(List.of(documentSymbols));
    }

    public NotebookDocumentService getNotebookDocumentService() {
        return new NotebookDocumentService(){

            public void didSave(DidSaveNotebookDocumentParams params) {
            }

            public void didOpen(DidOpenNotebookDocumentParams params) {
            }

            public void didClose(DidCloseNotebookDocumentParams params) {
            }

            public void didChange(DidChangeNotebookDocumentParams params) {
            }
        };
    }

    public void setFoldingRanges(List<FoldingRange> foldingRanges) {
        this.textDocumentService.setFoldingRanges(foldingRanges);
    }

    public String toString() {
        return "MockLanguageServer [started=" + this.started + ", delay=" + this.delay + ", remoteProxies=" + this.remoteProxies.size() + ", inFlight=" + this.inFlight.size() + "]";
    }
}

