/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.semanticTokens;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.semanticTokens.SemanticHighlightReconcilerStrategy;
import org.eclipse.lsp4e.test.semanticTokens.SemanticTokensTestUtil;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.junit.Assert;
import org.junit.Test;

public class SemanticTokensLegendProviderTest
extends AbstractTestWithProject {
    @Test
    public void testSemanticTokensLegendProvider() throws CoreException, IOException {
        List<String> tokenTypes = List.of("keyword", "other");
        List<String> tokenModifiers = List.of("obsolete");
        SemanticTokensTestUtil.setSemanticTokensLegend(tokenTypes, tokenModifiers);
        IFile file = TestUtils.createUniqueTestFile(this.project, "lspt", "test content");
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)file, c -> Boolean.TRUE).iterator().next();
        SemanticTokensLegend semanticTokensLegend = new SemanticHighlightReconcilerStrategy().getSemanticTokensLegend(wrapper);
        Assert.assertNotNull((Object)semanticTokensLegend);
        Assert.assertEquals(tokenTypes, (Object)semanticTokensLegend.getTokenTypes());
        Assert.assertEquals(tokenModifiers, (Object)semanticTokensLegend.getTokenModifiers());
    }
}

