/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DocumentRevertAndCloseTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject(String.valueOf(this.getClass().getName()) + System.currentTimeMillis());
    }

    @Test
    public void testShutdownLsp() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "Hello!");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        testFile.setLocalTimeStamp(0L);
        IDocument document = LSPEclipseUtils.getDocument((IResource)testFile);
        Assert.assertNotNull((Object)document);
        LanguageServers.forDocument((IDocument)document).anyMatching();
        viewer.getDocument().replace(0, 0, "Bye!");
        ((AbstractTextEditor)editor).doRevertToSaved();
        ((AbstractTextEditor)editor).getSite().getPage().closeEditor(editor, false);
        TestUtils.waitForAndAssertCondition(3000, () -> !MockLanguageServer.INSTANCE.isRunning());
    }
}

