/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.design;

import activity.Action;
import activity.Activity;
import activity.Dependency;
import activity.EventAction;
import activity.PeripheralAction;
import activity.SyncBar;
import activity.util.ActivityUtil;
import java.util.Collection;
import java.util.Map;
import machine.IResource;
import machine.Peripheral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsat.activity.diagram.services.ActivityServices;
import org.eclipse.lsat.common.graph.directed.editable.Edge;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.sirius.business.api.action.AbstractExternalJavaAction;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteAction
extends AbstractExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> selections) {
        return selections != null && selections.size() == 1;
    }

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        DSemanticDecorator view = (DSemanticDecorator)this.getParameter(parameters, "view", DSemanticDecorator.class);
        Activity activity = ActivityServices.getActivity(view);
        for (EObject eObject : selections) {
            if (eObject instanceof PeripheralAction || eObject instanceof SyncBar || eObject instanceof EventAction) {
                DeleteAction.delete((Node)eObject);
                continue;
            }
            if (eObject instanceof Dependency) {
                DeleteAction.delete((Edge)((Dependency)eObject));
                continue;
            }
            if (eObject instanceof IResource) {
                for (Action action : ActivityServices.getResourceActions(activity, (IResource)eObject)) {
                    DeleteAction.delete((Node)action);
                }
                continue;
            }
            if (eObject instanceof Peripheral) {
                IResource resource = ActivityServices.getResource(view);
                for (PeripheralAction peripheralAction : ActivityServices.getPeripheralActions((EObject)view)) {
                    DeleteAction.delete((Node)peripheralAction);
                }
                if (!ActivityServices.getPeripherals(activity, resource).isEmpty()) continue;
                for (Action action : ActivityServices.getResourceActions(activity, resource)) {
                    DeleteAction.delete((Node)action);
                }
                continue;
            }
            final String type = eObject.eClass().getName();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)("Delete " + type), (String)("Not allowed to delete " + type + ". Please delete the resource in stead."));
                }
            });
        }
    }

    private static void delete(Node node) {
        ActivityUtil.delete((Node)node);
    }

    private static void delete(Edge edge) {
        ActivityUtil.delete((Edge)edge);
    }
}

