/*
 * Decompiled with CFR 0.152.
 */
package distributions.math;

import distributions.math.ModeDistribution;
import distributions.math.ModeNotSupportedException;
import org.apache.commons.math3.distribution.EnumeratedRealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.Pair;

public class EnumeratedModeDistribution
extends EnumeratedRealDistribution
implements ModeDistribution {
    private static final long serialVersionUID = -5796357692875297528L;
    private final Double itsDefault;

    public EnumeratedModeDistribution(RandomGenerator rng, double[] data, Double _default) {
        super(rng, data);
        this.itsDefault = _default;
    }

    @Override
    public double getMode() throws ModeNotSupportedException {
        Double mode = null;
        double maxProb = Double.NEGATIVE_INFINITY;
        for (Pair sample : this.innerDistribution.getPmf()) {
            double prob = (Double)sample.getSecond();
            if (prob > maxProb) {
                maxProb = prob;
                mode = (Double)sample.getFirst();
                continue;
            }
            if (prob != maxProb) continue;
            mode = null;
        }
        if (mode == null) {
            throw new ModeNotSupportedException("The distribution has no mode");
        }
        return mode;
    }

    @Override
    public double getDefault() {
        if (this.itsDefault != null) {
            return this.itsDefault;
        }
        return this.getNumericalMean();
    }

    @Override
    public double getLowerBound() {
        return this.getSupportLowerBound();
    }

    @Override
    public double getUpperBound() {
        return this.getSupportUpperBound();
    }

    @Override
    public double nextSample() {
        return this.sample();
    }

    @Override
    public double[] nextSamples(int sampleSize) {
        return this.sample(sampleSize);
    }
}

