/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersComparator;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class STDataViewersSortDialog
extends TrayDialog {
    private final STDataViewersComparator sorter;
    private Combo[] priorityCombos;
    private Button[] ascendingButtons;
    private Button[] descendingButtons;
    private boolean dirty;

    public STDataViewersSortDialog(Shell parentShell, STDataViewersComparator sorter) {
        super(parentShell);
        this.sorter = sorter;
        this.dirty = false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(STDataViewersMessages.sortDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.sorter == null) {
            return composite;
        }
        this.initializeDialogUnits((Control)composite);
        this.createPrioritiesArea(composite);
        this.createRestoreDefaultsButton(composite);
        this.createSeparatorLine(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createPrioritiesArea(Composite parent) {
        Composite prioritiesArea = new Composite(parent, 0);
        prioritiesArea.setLayout((Layout)new GridLayout(3, false));
        int[] priorities = this.sorter.getPriorities();
        this.ascendingButtons = new Button[priorities.length];
        this.descendingButtons = new Button[priorities.length];
        this.priorityCombos = new Combo[Math.min(priorities.length, 4)];
        Label sortByLabel = new Label(prioritiesArea, 0);
        sortByLabel.setText(STDataViewersMessages.sortDialog_label);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        sortByLabel.setLayoutData((Object)data);
        for (int i = 0; i < this.priorityCombos.length; ++i) {
            final int index = i;
            Label numberLabel = new Label(prioritiesArea, 0);
            numberLabel.setText(NLS.bind((String)STDataViewersMessages.sortDialog_columnLabel, (Object)(i + 1)));
            this.priorityCombos[i] = new Combo(prioritiesArea, 8);
            this.priorityCombos[i].setLayoutData((Object)new GridData(768));
            Composite directionGroup = new Composite(prioritiesArea, 0);
            directionGroup.setLayout((Layout)new GridLayout(2, false));
            this.ascendingButtons[i] = new Button(directionGroup, 16);
            this.ascendingButtons[i].setText(this.getAscendingText(i));
            this.ascendingButtons[i].addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.markDirty()));
            this.descendingButtons[i] = new Button(directionGroup, 16);
            this.descendingButtons[i].setText(this.getDescendingText(i));
            this.descendingButtons[i].addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.markDirty()));
            if (i < this.priorityCombos.length - 1) {
                this.priorityCombos[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ArrayList<String> allItems = new ArrayList<String>(Arrays.asList(STDataViewersSortDialog.this.priorityCombos[index].getItems()));
                        this.computeSelectionItems(index, allItems);
                        STDataViewersSortDialog.this.markDirty();
                    }

                    private void computeSelectionItems(int index2, List<String> allItems) {
                        if (index2 < STDataViewersSortDialog.this.priorityCombos.length) {
                            Combo priorityCombo = STDataViewersSortDialog.this.priorityCombos[index2];
                            String oldSelection = priorityCombo.getItem(priorityCombo.getSelectionIndex());
                            priorityCombo.setItems(allItems.toArray(new String[allItems.size()]));
                            if (allItems.contains(oldSelection)) {
                                String newSelection = oldSelection;
                                priorityCombo.select(allItems.indexOf(oldSelection));
                                allItems.remove(newSelection);
                            } else {
                                String newSelection = allItems.get(0);
                                priorityCombo.select(0);
                                allItems.remove(newSelection);
                            }
                            this.computeSelectionItems(index2 + 1, allItems);
                        }
                    }
                });
                continue;
            }
            this.priorityCombos[i].addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.markDirty()));
        }
        this.updateUIFromSorter();
    }

    private String getDescendingText(int index) {
        switch (index) {
            case 1: {
                return STDataViewersMessages.sortDirectionDescending_text2;
            }
            case 2: {
                return STDataViewersMessages.sortDirectionDescending_text3;
            }
            case 3: {
                return STDataViewersMessages.sortDirectionDescending_text4;
            }
        }
        return STDataViewersMessages.sortDirectionDescending_text;
    }

    private String getAscendingText(int index) {
        switch (index) {
            case 1: {
                return STDataViewersMessages.sortDirectionAscending_text2;
            }
            case 2: {
                return STDataViewersMessages.sortDirectionAscending_text3;
            }
            case 3: {
                return STDataViewersMessages.sortDirectionAscending_text4;
            }
        }
        return STDataViewersMessages.sortDirectionAscending_text;
    }

    private void createRestoreDefaultsButton(Composite parent) {
        Button defaultsButton = new Button(parent, 8);
        defaultsButton.setText(STDataViewersMessages.restoreDefaults_text);
        this.setButtonSize(defaultsButton, new GridData(896));
        defaultsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.restoreDefaults();
            this.markDirty();
        }));
    }

    private void createSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(772));
    }

    private void restoreDefaults() {
        this.updateUI(null, null);
    }

    private void updateUIFromSorter() {
        this.updateUI(this.sorter.getPriorities(), this.sorter.getDirections());
    }

    private void updateUI(int[] priorities, int[] directions) {
        int i;
        Item[] columns = this.sorter.getColumns();
        ArrayList<String> allItems = new ArrayList<String>();
        ArrayList<Integer> allDirections = new ArrayList<Integer>();
        for (i = 0; i < columns.length; ++i) {
            if (priorities == null || directions == null) {
                allItems.add(columns[i].getText());
                ISTDataViewersField field = (ISTDataViewersField)columns[i].getData();
                allDirections.add(field.getDefaultDirection());
                continue;
            }
            allItems.add(columns[priorities[i]].getText());
            allDirections.add(directions[priorities[i]]);
        }
        for (i = 0; i < this.priorityCombos.length; ++i) {
            this.priorityCombos[i].removeAll();
            this.priorityCombos[i].setItems(allItems.toArray(new String[allItems.size()]));
            this.priorityCombos[i].select(0);
            allItems.remove(0);
            this.ascendingButtons[i].setSelection((Integer)allDirections.get(0) == 1);
            this.descendingButtons[i].setSelection((Integer)allDirections.get(0) == -1);
            allDirections.remove(0);
        }
    }

    public int open() {
        this.dirty = false;
        return super.open();
    }

    protected void okPressed() {
        if (this.isDirty()) {
            for (int i = this.priorityCombos.length - 1; i >= 0; --i) {
                int direction;
                block4: {
                    Item[] columns;
                    Combo combo = this.priorityCombos[i];
                    int index = combo.getSelectionIndex();
                    String item = combo.getItem(index);
                    for (Item column : columns = this.sorter.getColumns()) {
                        if (!item.equals(column.getText())) continue;
                        ISTDataViewersField field = (ISTDataViewersField)column.getData();
                        this.sorter.setTopPriority(column, field);
                        direction = 1;
                        if (this.descendingButtons[i].getSelection()) {
                            direction = -1;
                        }
                        break block4;
                    }
                    this.sorter.resetState();
                    return;
                }
                this.sorter.setTopPriorityDirection(direction);
            }
        }
        super.okPressed();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    private void setButtonSize(Button button, GridData buttonData) {
        button.setFont(button.getParent().getFont());
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        buttonData.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)buttonData);
    }

    public STDataViewersComparator getSorter() {
        return new STDataViewersComparator(this.sorter);
    }
}

