package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link NodeInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNodeInfo.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableNodeInfo implements NodeInfo {
  private final String id;
  private final Version version;
  private final Date createdAt;
  private final Date updatedAt;
  private final NodeSpec spec;
  private final NodeDescription description;
  private final NodeStatus status;
  private final @Nullable ManagerStatus managerStatus;

  private ImmutableNodeInfo(
      String id,
      Version version,
      Date createdAt,
      Date updatedAt,
      NodeSpec spec,
      NodeDescription description,
      NodeStatus status,
      @Nullable ManagerStatus managerStatus) {
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.spec = spec;
    this.description = description;
    this.status = status;
    this.managerStatus = managerStatus;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("Version")
  @Override
  public Version version() {
    return version;
  }

  /**
   * @return The value of the {@code createdAt} attribute
   */
  @JsonProperty("CreatedAt")
  @Override
  public Date createdAt() {
    return createdAt;
  }

  /**
   * @return The value of the {@code updatedAt} attribute
   */
  @JsonProperty("UpdatedAt")
  @Override
  public Date updatedAt() {
    return updatedAt;
  }

  /**
   * @return The value of the {@code spec} attribute
   */
  @JsonProperty("Spec")
  @Override
  public NodeSpec spec() {
    return spec;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("Description")
  @Override
  public NodeDescription description() {
    return description;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("Status")
  @Override
  public NodeStatus status() {
    return status;
  }

  /**
   * @return The value of the {@code managerStatus} attribute
   */
  @JsonProperty("ManagerStatus")
  @Override
  public @Nullable ManagerStatus managerStatus() {
    return managerStatus;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NodeInfo#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNodeInfo withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableNodeInfo(
        newValue,
        this.version,
        this.createdAt,
        this.updatedAt,
        this.spec,
        this.description,
        this.status,
        this.managerStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NodeInfo#version() version} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNodeInfo withVersion(Version value) {
    if (this.version == value) return this;
    Version newValue = Objects.requireNonNull(value, "version");
    return new ImmutableNodeInfo(
        this.id,
        newValue,
        this.createdAt,
        this.updatedAt,
        this.spec,
        this.description,
        this.status,
        this.managerStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NodeInfo#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNodeInfo withCreatedAt(Date value) {
    if (this.createdAt == value) return this;
    Date newValue = Objects.requireNonNull(value, "createdAt");
    return new ImmutableNodeInfo(
        this.id,
        this.version,
        newValue,
        this.updatedAt,
        this.spec,
        this.description,
        this.status,
        this.managerStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NodeInfo#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNodeInfo withUpdatedAt(Date value) {
    if (this.updatedAt == value) return this;
    Date newValue = Objects.requireNonNull(value, "updatedAt");
    return new ImmutableNodeInfo(
        this.id,
        this.version,
        this.createdAt,
        newValue,
        this.spec,
        this.description,
        this.status,
        this.managerStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NodeInfo#spec() spec} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for spec
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNodeInfo withSpec(NodeSpec value) {
    if (this.spec == value) return this;
    NodeSpec newValue = Objects.requireNonNull(value, "spec");
    return new ImmutableNodeInfo(
        this.id,
        this.version,
        this.createdAt,
        this.updatedAt,
        newValue,
        this.description,
        this.status,
        this.managerStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NodeInfo#description() description} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNodeInfo withDescription(NodeDescription value) {
    if (this.description == value) return this;
    NodeDescription newValue = Objects.requireNonNull(value, "description");
    return new ImmutableNodeInfo(
        this.id,
        this.version,
        this.createdAt,
        this.updatedAt,
        this.spec,
        newValue,
        this.status,
        this.managerStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NodeInfo#status() status} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNodeInfo withStatus(NodeStatus value) {
    if (this.status == value) return this;
    NodeStatus newValue = Objects.requireNonNull(value, "status");
    return new ImmutableNodeInfo(
        this.id,
        this.version,
        this.createdAt,
        this.updatedAt,
        this.spec,
        this.description,
        newValue,
        this.managerStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NodeInfo#managerStatus() managerStatus} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for managerStatus (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNodeInfo withManagerStatus(@Nullable ManagerStatus value) {
    if (this.managerStatus == value) return this;
    return new ImmutableNodeInfo(
        this.id,
        this.version,
        this.createdAt,
        this.updatedAt,
        this.spec,
        this.description,
        this.status,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNodeInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNodeInfo
        && equalTo(0, (ImmutableNodeInfo) another);
  }

  private boolean equalTo(int synthetic, ImmutableNodeInfo another) {
    return id.equals(another.id)
        && version.equals(another.version)
        && createdAt.equals(another.createdAt)
        && updatedAt.equals(another.updatedAt)
        && spec.equals(another.spec)
        && description.equals(another.description)
        && status.equals(another.status)
        && Objects.equals(managerStatus, another.managerStatus);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code version}, {@code createdAt}, {@code updatedAt}, {@code spec}, {@code description}, {@code status}, {@code managerStatus}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + updatedAt.hashCode();
    h += (h << 5) + spec.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + Objects.hashCode(managerStatus);
    return h;
  }

  /**
   * Prints the immutable value {@code NodeInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NodeInfo{"
        + "id=" + id
        + ", version=" + version
        + ", createdAt=" + createdAt
        + ", updatedAt=" + updatedAt
        + ", spec=" + spec
        + ", description=" + description
        + ", status=" + status
        + ", managerStatus=" + managerStatus
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link NodeInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NodeInfo instance
   */
  public static ImmutableNodeInfo copyOf(NodeInfo instance) {
    if (instance instanceof ImmutableNodeInfo) {
      return (ImmutableNodeInfo) instance;
    }
    return ImmutableNodeInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNodeInfo ImmutableNodeInfo}.
   * <pre>
   * ImmutableNodeInfo.builder()
   *    .id(String) // required {@link NodeInfo#id() id}
   *    .version(org.mandas.docker.client.messages.swarm.Version) // required {@link NodeInfo#version() version}
   *    .createdAt(Date) // required {@link NodeInfo#createdAt() createdAt}
   *    .updatedAt(Date) // required {@link NodeInfo#updatedAt() updatedAt}
   *    .spec(org.mandas.docker.client.messages.swarm.NodeSpec) // required {@link NodeInfo#spec() spec}
   *    .description(org.mandas.docker.client.messages.swarm.NodeDescription) // required {@link NodeInfo#description() description}
   *    .status(org.mandas.docker.client.messages.swarm.NodeStatus) // required {@link NodeInfo#status() status}
   *    .managerStatus(org.mandas.docker.client.messages.swarm.ManagerStatus | null) // nullable {@link NodeInfo#managerStatus() managerStatus}
   *    .build();
   * </pre>
   * @return A new ImmutableNodeInfo builder
   */
  public static ImmutableNodeInfo.Builder builder() {
    return new ImmutableNodeInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNodeInfo ImmutableNodeInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_VERSION = 0x2L;
    private static final long INIT_BIT_CREATED_AT = 0x4L;
    private static final long INIT_BIT_UPDATED_AT = 0x8L;
    private static final long INIT_BIT_SPEC = 0x10L;
    private static final long INIT_BIT_DESCRIPTION = 0x20L;
    private static final long INIT_BIT_STATUS = 0x40L;
    private long initBits = 0x7fL;

    private String id;
    private Version version;
    private Date createdAt;
    private Date updatedAt;
    private NodeSpec spec;
    private NodeDescription description;
    private NodeStatus status;
    private ManagerStatus managerStatus;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NodeInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(NodeInfo instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.id());
      this.version(instance.version());
      this.createdAt(instance.createdAt());
      this.updatedAt(instance.updatedAt());
      this.spec(instance.spec());
      this.description(instance.description());
      this.status(instance.status());
      @Nullable ManagerStatus managerStatusValue = instance.managerStatus();
      if (managerStatusValue != null) {
        managerStatus(managerStatusValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NodeInfo#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link NodeInfo#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Version")
    public final Builder version(Version version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link NodeInfo#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CreatedAt")
    public final Builder createdAt(Date createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link NodeInfo#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("UpdatedAt")
    public final Builder updatedAt(Date updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
      initBits &= ~INIT_BIT_UPDATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link NodeInfo#spec() spec} attribute.
     * @param spec The value for spec 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Spec")
    public final Builder spec(NodeSpec spec) {
      this.spec = Objects.requireNonNull(spec, "spec");
      initBits &= ~INIT_BIT_SPEC;
      return this;
    }

    /**
     * Initializes the value for the {@link NodeInfo#description() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Description")
    public final Builder description(NodeDescription description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link NodeInfo#status() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Status")
    public final Builder status(NodeStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the value for the {@link NodeInfo#managerStatus() managerStatus} attribute.
     * @param managerStatus The value for managerStatus (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ManagerStatus")
    public final Builder managerStatus(@Nullable ManagerStatus managerStatus) {
      this.managerStatus = managerStatus;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNodeInfo ImmutableNodeInfo}.
     * @return An immutable instance of NodeInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNodeInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNodeInfo(id, version, createdAt, updatedAt, spec, description, status, managerStatus);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_UPDATED_AT) != 0) attributes.add("updatedAt");
      if ((initBits & INIT_BIT_SPEC) != 0) attributes.add("spec");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build NodeInfo, some of required attributes are not set " + attributes;
    }
  }
}
