/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.mandas.docker.client.auth.RegistryAuthSupplier;
import org.mandas.docker.client.exceptions.DockerException;
import org.mandas.docker.client.messages.RegistryAuth;
import org.mandas.docker.client.messages.RegistryConfigs;

public class MultiRegistryAuthSupplier
implements RegistryAuthSupplier {
    private final List<RegistryAuthSupplier> suppliers;

    public MultiRegistryAuthSupplier(List<RegistryAuthSupplier> suppliers) {
        this.suppliers = suppliers;
    }

    @Override
    public RegistryAuth authFor(String imageName) throws DockerException {
        for (RegistryAuthSupplier supplier : this.suppliers) {
            RegistryAuth auth = supplier.authFor(imageName);
            if (auth == null) continue;
            return auth;
        }
        return null;
    }

    @Override
    public RegistryAuth authForSwarm() throws DockerException {
        for (RegistryAuthSupplier supplier : this.suppliers) {
            RegistryAuth auth = supplier.authForSwarm();
            if (auth == null) continue;
            return auth;
        }
        return null;
    }

    @Override
    public RegistryConfigs authForBuild() throws DockerException {
        HashMap<String, RegistryAuth> allConfigs = new HashMap<String, RegistryAuth>();
        ArrayList<RegistryAuthSupplier> reversedSuppliers = new ArrayList<RegistryAuthSupplier>(this.suppliers);
        Collections.reverse(reversedSuppliers);
        for (RegistryAuthSupplier supplier : reversedSuppliers) {
            RegistryConfigs configs = supplier.authForBuild();
            if (configs == null || configs.configs() == null) continue;
            allConfigs.putAll(configs.configs());
        }
        return RegistryConfigs.create(allConfigs);
    }
}

