/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.client.messages.RegistryAuth;
import org.mandas.docker.client.messages.RegistryConfigs;

final class ImmutableRegistryConfigs
implements RegistryConfigs {
    private final Map<String, RegistryAuth> configs;

    private ImmutableRegistryConfigs(Map<String, RegistryAuth> configs) {
        this.configs = configs;
    }

    @Override
    public Map<String, RegistryAuth> configs() {
        return this.configs;
    }

    public final ImmutableRegistryConfigs withConfigs(Map<String, ? extends RegistryAuth> entries) {
        if (this.configs == entries) {
            return this;
        }
        Map<String, RegistryAuth> newValue = ImmutableRegistryConfigs.createUnmodifiableMap(true, false, entries);
        return new ImmutableRegistryConfigs(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRegistryConfigs && this.equalTo(0, (ImmutableRegistryConfigs)another);
    }

    private boolean equalTo(int synthetic, ImmutableRegistryConfigs another) {
        return this.configs.equals(another.configs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.configs.hashCode();
        return h;
    }

    public String toString() {
        return "RegistryConfigs{configs=" + String.valueOf(this.configs) + "}";
    }

    public static ImmutableRegistryConfigs copyOf(RegistryConfigs instance) {
        if (instance instanceof ImmutableRegistryConfigs) {
            return (ImmutableRegistryConfigs)instance;
        }
        return ImmutableRegistryConfigs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements RegistryConfigs.Builder {
        private Map<String, RegistryAuth> configs = new LinkedHashMap<String, RegistryAuth>();

        private Builder() {
        }

        public final Builder from(RegistryConfigs instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllConfigs(instance.configs());
            return this;
        }

        @Override
        public final Builder addConfig(String key, RegistryAuth value) {
            this.configs.put(Objects.requireNonNull(key, "configs key"), Objects.requireNonNull(value, value == null ? "configs value for key: " + key : null));
            return this;
        }

        public final Builder addConfig(Map.Entry<String, ? extends RegistryAuth> entry) {
            RegistryAuth v;
            String k = entry.getKey();
            this.configs.put(Objects.requireNonNull(k, "configs key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "configs value for key: " + k : null));
            return this;
        }

        @Override
        public final Builder configs(Map<String, ? extends RegistryAuth> entries) {
            this.configs.clear();
            return this.putAllConfigs(entries);
        }

        public final Builder putAllConfigs(Map<String, ? extends RegistryAuth> entries) {
            for (Map.Entry<String, ? extends RegistryAuth> e : entries.entrySet()) {
                RegistryAuth v;
                String k = e.getKey();
                this.configs.put(Objects.requireNonNull(k, "configs key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "configs value for key: " + k : null));
            }
            return this;
        }

        @Override
        public ImmutableRegistryConfigs build() {
            return new ImmutableRegistryConfigs(ImmutableRegistryConfigs.createUnmodifiableMap(false, false, this.configs));
        }
    }
}

