/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.DockerConfig;
import org.mandas.docker.client.messages.RegistryAuth;

final class ImmutableDockerConfig
implements DockerConfig {
    private final Map<String, String> credHelpers;
    private final Map<String, RegistryAuth> auths;
    private final Map<String, String> httpHeaders;
    @Nullable
    private final String credsStore;
    @Nullable
    private final String detachKeys;
    @Nullable
    private final String stackOrchestrator;
    @Nullable
    private final String psFormat;
    @Nullable
    private final String imagesFormat;

    private ImmutableDockerConfig(Map<String, String> credHelpers, Map<String, RegistryAuth> auths, Map<String, String> httpHeaders, @Nullable String credsStore, @Nullable String detachKeys, @Nullable String stackOrchestrator, @Nullable String psFormat, @Nullable String imagesFormat) {
        this.credHelpers = credHelpers;
        this.auths = auths;
        this.httpHeaders = httpHeaders;
        this.credsStore = credsStore;
        this.detachKeys = detachKeys;
        this.stackOrchestrator = stackOrchestrator;
        this.psFormat = psFormat;
        this.imagesFormat = imagesFormat;
    }

    @Override
    @JsonProperty(value="credHelpers")
    public Map<String, String> credHelpers() {
        return this.credHelpers;
    }

    @Override
    @JsonProperty(value="auths")
    public Map<String, RegistryAuth> auths() {
        return this.auths;
    }

    @Override
    @JsonProperty(value="HttpHeaders")
    public Map<String, String> httpHeaders() {
        return this.httpHeaders;
    }

    @Override
    @JsonProperty(value="credsStore")
    @Nullable
    public String credsStore() {
        return this.credsStore;
    }

    @Override
    @JsonProperty(value="detachKeys")
    @Nullable
    public String detachKeys() {
        return this.detachKeys;
    }

    @Override
    @JsonProperty(value="stackOrchestrator")
    @Nullable
    public String stackOrchestrator() {
        return this.stackOrchestrator;
    }

    @Override
    @JsonProperty(value="psFormat")
    @Nullable
    public String psFormat() {
        return this.psFormat;
    }

    @Override
    @JsonProperty(value="imagesFormat")
    @Nullable
    public String imagesFormat() {
        return this.imagesFormat;
    }

    public final ImmutableDockerConfig withCredHelpers(Map<String, ? extends String> entries) {
        if (this.credHelpers == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableDockerConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableDockerConfig(newValue, this.auths, this.httpHeaders, this.credsStore, this.detachKeys, this.stackOrchestrator, this.psFormat, this.imagesFormat);
    }

    public final ImmutableDockerConfig withAuths(Map<String, ? extends RegistryAuth> entries) {
        if (this.auths == entries) {
            return this;
        }
        Map<String, RegistryAuth> newValue = ImmutableDockerConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableDockerConfig(this.credHelpers, newValue, this.httpHeaders, this.credsStore, this.detachKeys, this.stackOrchestrator, this.psFormat, this.imagesFormat);
    }

    public final ImmutableDockerConfig withHttpHeaders(Map<String, ? extends String> entries) {
        if (this.httpHeaders == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableDockerConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableDockerConfig(this.credHelpers, this.auths, newValue, this.credsStore, this.detachKeys, this.stackOrchestrator, this.psFormat, this.imagesFormat);
    }

    public final ImmutableDockerConfig withCredsStore(@Nullable String value) {
        if (Objects.equals(this.credsStore, value)) {
            return this;
        }
        return new ImmutableDockerConfig(this.credHelpers, this.auths, this.httpHeaders, value, this.detachKeys, this.stackOrchestrator, this.psFormat, this.imagesFormat);
    }

    public final ImmutableDockerConfig withDetachKeys(@Nullable String value) {
        if (Objects.equals(this.detachKeys, value)) {
            return this;
        }
        return new ImmutableDockerConfig(this.credHelpers, this.auths, this.httpHeaders, this.credsStore, value, this.stackOrchestrator, this.psFormat, this.imagesFormat);
    }

    public final ImmutableDockerConfig withStackOrchestrator(@Nullable String value) {
        if (Objects.equals(this.stackOrchestrator, value)) {
            return this;
        }
        return new ImmutableDockerConfig(this.credHelpers, this.auths, this.httpHeaders, this.credsStore, this.detachKeys, value, this.psFormat, this.imagesFormat);
    }

    public final ImmutableDockerConfig withPsFormat(@Nullable String value) {
        if (Objects.equals(this.psFormat, value)) {
            return this;
        }
        return new ImmutableDockerConfig(this.credHelpers, this.auths, this.httpHeaders, this.credsStore, this.detachKeys, this.stackOrchestrator, value, this.imagesFormat);
    }

    public final ImmutableDockerConfig withImagesFormat(@Nullable String value) {
        if (Objects.equals(this.imagesFormat, value)) {
            return this;
        }
        return new ImmutableDockerConfig(this.credHelpers, this.auths, this.httpHeaders, this.credsStore, this.detachKeys, this.stackOrchestrator, this.psFormat, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDockerConfig && this.equalsByValue((ImmutableDockerConfig)another);
    }

    private boolean equalsByValue(ImmutableDockerConfig another) {
        return this.credHelpers.equals(another.credHelpers) && this.auths.equals(another.auths) && this.httpHeaders.equals(another.httpHeaders) && Objects.equals(this.credsStore, another.credsStore) && Objects.equals(this.detachKeys, another.detachKeys) && Objects.equals(this.stackOrchestrator, another.stackOrchestrator) && Objects.equals(this.psFormat, another.psFormat) && Objects.equals(this.imagesFormat, another.imagesFormat);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.credHelpers.hashCode();
        h += (h << 5) + this.auths.hashCode();
        h += (h << 5) + this.httpHeaders.hashCode();
        h += (h << 5) + Objects.hashCode(this.credsStore);
        h += (h << 5) + Objects.hashCode(this.detachKeys);
        h += (h << 5) + Objects.hashCode(this.stackOrchestrator);
        h += (h << 5) + Objects.hashCode(this.psFormat);
        h += (h << 5) + Objects.hashCode(this.imagesFormat);
        return h;
    }

    public String toString() {
        return "DockerConfig{credHelpers=" + String.valueOf(this.credHelpers) + ", auths=" + String.valueOf(this.auths) + ", httpHeaders=" + String.valueOf(this.httpHeaders) + ", credsStore=" + this.credsStore + ", detachKeys=" + this.detachKeys + ", stackOrchestrator=" + this.stackOrchestrator + ", psFormat=" + this.psFormat + ", imagesFormat=" + this.imagesFormat + "}";
    }

    public static ImmutableDockerConfig copyOf(DockerConfig instance) {
        if (instance instanceof ImmutableDockerConfig) {
            return (ImmutableDockerConfig)instance;
        }
        return ImmutableDockerConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder {
        private Map<String, String> credHelpers = new LinkedHashMap<String, String>();
        private Map<String, RegistryAuth> auths = new LinkedHashMap<String, RegistryAuth>();
        private Map<String, String> httpHeaders = new LinkedHashMap<String, String>();
        private String credsStore;
        private String detachKeys;
        private String stackOrchestrator;
        private String psFormat;
        private String imagesFormat;

        private Builder() {
        }

        public final Builder from(DockerConfig instance) {
            String imagesFormatValue;
            String psFormatValue;
            String stackOrchestratorValue;
            String detachKeysValue;
            Objects.requireNonNull(instance, "instance");
            this.putAllCredHelpers(instance.credHelpers());
            this.putAllAuths(instance.auths());
            this.putAllHttpHeaders(instance.httpHeaders());
            String credsStoreValue = instance.credsStore();
            if (credsStoreValue != null) {
                this.credsStore(credsStoreValue);
            }
            if ((detachKeysValue = instance.detachKeys()) != null) {
                this.detachKeys(detachKeysValue);
            }
            if ((stackOrchestratorValue = instance.stackOrchestrator()) != null) {
                this.stackOrchestrator(stackOrchestratorValue);
            }
            if ((psFormatValue = instance.psFormat()) != null) {
                this.psFormat(psFormatValue);
            }
            if ((imagesFormatValue = instance.imagesFormat()) != null) {
                this.imagesFormat(imagesFormatValue);
            }
            return this;
        }

        public final Builder addCredHelper(String key, String value) {
            this.credHelpers.put(Objects.requireNonNull(key, "credHelpers key"), Objects.requireNonNull(value, value == null ? "credHelpers value for key: " + key : null));
            return this;
        }

        public final Builder addCredHelper(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.credHelpers.put(Objects.requireNonNull(k, "credHelpers key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "credHelpers value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="credHelpers")
        public final Builder credHelpers(Map<String, ? extends String> entries) {
            this.credHelpers.clear();
            return this.putAllCredHelpers(entries);
        }

        public final Builder putAllCredHelpers(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.credHelpers.put(Objects.requireNonNull(k, "credHelpers key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "credHelpers value for key: " + k : null));
            }
            return this;
        }

        public final Builder addAuth(String key, RegistryAuth value) {
            this.auths.put(Objects.requireNonNull(key, "auths key"), Objects.requireNonNull(value, value == null ? "auths value for key: " + key : null));
            return this;
        }

        public final Builder addAuth(Map.Entry<String, ? extends RegistryAuth> entry) {
            RegistryAuth v;
            String k = entry.getKey();
            this.auths.put(Objects.requireNonNull(k, "auths key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "auths value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="auths")
        public final Builder auths(Map<String, ? extends RegistryAuth> entries) {
            this.auths.clear();
            return this.putAllAuths(entries);
        }

        public final Builder putAllAuths(Map<String, ? extends RegistryAuth> entries) {
            for (Map.Entry<String, ? extends RegistryAuth> e : entries.entrySet()) {
                RegistryAuth v;
                String k = e.getKey();
                this.auths.put(Objects.requireNonNull(k, "auths key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "auths value for key: " + k : null));
            }
            return this;
        }

        public final Builder addHttpHeader(String key, String value) {
            this.httpHeaders.put(Objects.requireNonNull(key, "httpHeaders key"), Objects.requireNonNull(value, value == null ? "httpHeaders value for key: " + key : null));
            return this;
        }

        public final Builder addHttpHeader(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.httpHeaders.put(Objects.requireNonNull(k, "httpHeaders key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "httpHeaders value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="HttpHeaders")
        public final Builder httpHeaders(Map<String, ? extends String> entries) {
            this.httpHeaders.clear();
            return this.putAllHttpHeaders(entries);
        }

        public final Builder putAllHttpHeaders(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.httpHeaders.put(Objects.requireNonNull(k, "httpHeaders key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "httpHeaders value for key: " + k : null));
            }
            return this;
        }

        @JsonProperty(value="credsStore")
        public final Builder credsStore(@Nullable String credsStore) {
            this.credsStore = credsStore;
            return this;
        }

        @JsonProperty(value="detachKeys")
        public final Builder detachKeys(@Nullable String detachKeys) {
            this.detachKeys = detachKeys;
            return this;
        }

        @JsonProperty(value="stackOrchestrator")
        public final Builder stackOrchestrator(@Nullable String stackOrchestrator) {
            this.stackOrchestrator = stackOrchestrator;
            return this;
        }

        @JsonProperty(value="psFormat")
        public final Builder psFormat(@Nullable String psFormat) {
            this.psFormat = psFormat;
            return this;
        }

        @JsonProperty(value="imagesFormat")
        public final Builder imagesFormat(@Nullable String imagesFormat) {
            this.imagesFormat = imagesFormat;
            return this;
        }

        public ImmutableDockerConfig build() {
            return new ImmutableDockerConfig(ImmutableDockerConfig.createUnmodifiableMap(false, false, this.credHelpers), ImmutableDockerConfig.createUnmodifiableMap(false, false, this.auths), ImmutableDockerConfig.createUnmodifiableMap(false, false, this.httpHeaders), this.credsStore, this.detachKeys, this.stackOrchestrator, this.psFormat, this.imagesFormat);
        }
    }
}

