/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.IOUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DOMUtils {
    private static final String XSD_EXTENSION = ".xsd";
    private static final String DTD_EXTENSION = ".dtd";
    private static final String ENT_EXTENSION = ".ent";
    private static final String MOD_EXTENSION = ".mod";
    private static final String HTTP_WWW_W3_ORG_2001_XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String URN_OASIS_NAMES_TC_ENTITY_XMLNS_XML_CATALOG_NS = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    private static final String RELAXNG_GRAMMAR_NS = "http://relaxng.org/ns/structure/1.0";
    private static final String RNG_EXTENSION = ".rng";
    private static final String RNC_EXTENSION = ".rnc";

    private DOMUtils() {
    }

    public static boolean isXSD(DOMDocument document) {
        if (document == null) {
            return false;
        }
        String uri = document.getDocumentURI();
        if (DOMUtils.isXSD(uri)) {
            return true;
        }
        return DOMUtils.checkRootNamespace(document, HTTP_WWW_W3_ORG_2001_XML_SCHEMA_NS);
    }

    public static boolean isXSD(String uri) {
        return uri != null && uri.endsWith(XSD_EXTENSION);
    }

    public static boolean isRelaxNG(DOMDocument document) {
        if (DOMUtils.isRelaxNGXMLSyntax(document)) {
            return true;
        }
        if (document == null) {
            return false;
        }
        String uri = document.getDocumentURI();
        return DOMUtils.isRelaxNGUri(uri);
    }

    public static boolean isRelaxNGXMLSyntax(DOMDocument document) {
        if (document == null) {
            return false;
        }
        String uri = document.getDocumentURI();
        if (DOMUtils.isRelaxNGUriXMLSyntax(uri)) {
            return true;
        }
        return DOMUtils.checkRootNamespace(document, RELAXNG_GRAMMAR_NS);
    }

    public static boolean isRelaxNGUriXMLSyntax(String uri) {
        return uri != null && uri.endsWith(RNG_EXTENSION);
    }

    public static boolean isRelaxNGUri(String uri) {
        return DOMUtils.isRelaxNGUriXMLSyntax(uri) || DOMUtils.isRelaxNGUriCompactSyntax(uri);
    }

    public static boolean isRelaxNGUriCompactSyntax(String uri) {
        return uri != null && uri.endsWith(RNC_EXTENSION);
    }

    public static boolean isCatalog(DOMDocument document) {
        return DOMUtils.checkRootNamespace(document, URN_OASIS_NAMES_TC_ENTITY_XMLNS_XML_CATALOG_NS);
    }

    private static boolean checkRootNamespace(DOMDocument document, String namespace) {
        DOMElement documentElement = document.getDocumentElement();
        return documentElement != null && namespace.equals(documentElement.getNamespaceURI());
    }

    public static boolean isDTD(String uri) {
        return uri != null && (uri.endsWith(DTD_EXTENSION) || uri.endsWith(ENT_EXTENSION) || uri.endsWith(MOD_EXTENSION));
    }

    public static boolean containsTextOnly(DOMElement element) {
        return element.getChildNodes().getLength() == 1 && element.getFirstChild().isText();
    }

    public static DOMDocument loadDocument(String documentURI, URIResolverExtensionManager resolverExtensionManager) {
        try {
            return DOMParser.getInstance().parse(IOUtils.convertStreamToString(new URL(documentURI).openStream()), documentURI, resolverExtensionManager);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static SAXParserFactory newSAXParserFactory() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return factory;
    }

    public static DOMElement findFirstChildElementByTagName(DOMElement element, String tagName) {
        for (DOMNode child : element.getChildren()) {
            if (!DOMUtils.isDOMElement(child, tagName)) continue;
            return (DOMElement)child;
        }
        return null;
    }

    public static boolean isDOMElement(DOMNode node, String tagName) {
        return node != null && node.isElement() && tagName.equals(node.getLocalName());
    }

    public static InputSource createInputSource(DOMDocument document) {
        String content = document.getText();
        String uri = document.getDocumentURI();
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(content));
        inputSource.setSystemId(uri);
        return inputSource;
    }
}

