/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class XSDCompletionExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void completion() throws BadLocationException {
        String xml = "<?xml version=\"1.1\"?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">   \r\n|";
        this.testCompletionFor(xml, XMLAssert.c("xs:annotation", XMLAssert.te(2, 0, 2, 0, "<xs:annotation></xs:annotation>"), "xs:annotation"), XMLAssert.c("xs:attribute", XMLAssert.te(2, 0, 2, 0, "<xs:attribute name=\"\"></xs:attribute>"), "xs:attribute"));
    }

    @Test
    public void completionWithSourceDocumentation() throws BadLocationException {
        String xml = "<?xml version=\"1.1\"?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">   \r\n|";
        this.testCompletionFor(xml, XMLAssert.c("xs:annotation", XMLAssert.te(2, 0, 2, 0, "<xs:annotation></xs:annotation>"), "xs:annotation", null, null), XMLAssert.c("xs:attribute", XMLAssert.te(2, 0, 2, 0, "<xs:attribute name=\"\"></xs:attribute>"), "xs:attribute", null, null));
    }

    @Test
    public void completionWithSourceDescriptionAndDocumentation() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:schemaLocation=\"http://invoice xsd/invoice.xsd \">\r\n  <|";
        String lineSeparator = System.getProperty("line.separator");
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/invoice.xml", null, XMLAssert.c("date", XMLAssert.te(3, 2, 3, 3, "<date></date>"), "<date", "Date Description" + lineSeparator + lineSeparator + "Source: invoice.xsd", "plaintext"));
    }

    @Test
    public void completionOnElementType() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"elt\" type=\"|\" />\r\n\t<xs:complexType name=\"aComplexType\" />\r\n\t<xs:simpleType name=\"aSimpleType\" />\r\n</xs:schema>";
        this.testCompletionFor(xml, XMLAssert.c("xs:aComplexType", XMLAssert.te(2, 30, 2, 30, "xs:aComplexType"), "xs:aComplexType"), XMLAssert.c("xs:aSimpleType", XMLAssert.te(2, 30, 2, 30, "xs:aSimpleType"), "xs:aSimpleType"), XMLAssert.c("xs:string", XMLAssert.te(2, 30, 2, 30, "xs:string"), "xs:string"));
    }

    @Test
    public void completionOnAttributeType() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:attribute name=\"attr\" type=\"|\" />\r\n\t<xs:complexType name=\"aComplexType\" />\r\n\t<xs:simpleType name=\"aSimpleType\" />\r\n</xs:schema>";
        this.testCompletionFor(xml, XMLAssert.c("xs:aSimpleType", XMLAssert.te(2, 33, 2, 33, "xs:aSimpleType"), "xs:aSimpleType"), XMLAssert.c("xs:string", XMLAssert.te(2, 33, 2, 33, "xs:string"), "xs:string"));
    }

    @Test
    public void completionOnElementRef() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\" version=\"1.0\">\r\n\t\r\n\t<xs:group name=\"schemaTop\">\r\n\t\t<xs:choice>\r\n\t\t\t<xs:group ref=\"xs:redefinable\" />\r\n\t\t\t<xs:element ref=\"xs:element\" />\r\n\t\t\t<xs:element ref=\"xs:attribute\" />\r\n\t\t\t<xs:element ref=\"|\" />\r\n\t\t</xs:choice>\r\n\t</xs:group>\r\n\t\r\n\t<xs:group name=\"redefinable\">\r\n\t\t<xs:choice></xs:choice>\r\n\t</xs:group>\r\n\t\r\n\t<xs:element name=\"element\" />\r\n\t<xs:element name=\"attribute\" />\r\n\t<xs:element name=\"notation\" />\r\n</xs:schema>";
        XMLAssert.testCompletionFor(xml, 3, XMLAssert.c("xs:element", XMLAssert.te(8, 20, 8, 20, "xs:element"), "xs:element"), XMLAssert.c("xs:attribute", XMLAssert.te(8, 20, 8, 20, "xs:attribute"), "xs:attribute"), XMLAssert.c("xs:notation", XMLAssert.te(8, 20, 8, 20, "xs:notation"), "xs:notation"));
    }

    @Test
    public void completionOnGroupRef() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\" version=\"1.0\">\r\n\t\r\n\t<xs:group name=\"schemaTop\">\r\n\t\t<xs:choice>\r\n\t\t\t<xs:group ref=\"|\" />\r\n\t\t\t<xs:element ref=\"xs:element\" />\r\n\t\t\t<xs:element ref=\"xs:attribute\" />\r\n\t\t\t<xs:element ref=\"xs:notation\" />\r\n\t\t</xs:choice>\r\n\t</xs:group>\r\n\t\r\n\t<xs:group name=\"redefinable\">\r\n\t\t<xs:choice></xs:choice>\r\n\t</xs:group>\r\n\t\r\n\t<xs:element name=\"element\" />\r\n\t<xs:element name=\"attribute\" />\r\n\t<xs:element name=\"notation\" />\r\n</xs:schema>";
        XMLAssert.testCompletionFor(xml, 2, XMLAssert.c("xs:redefinable", XMLAssert.te(5, 18, 5, 18, "xs:redefinable"), "xs:redefinable"), XMLAssert.c("xs:schemaTop", XMLAssert.te(5, 18, 5, 18, "xs:schemaTop"), "xs:schemaTop"));
    }

    @Test
    public void complectionWithXSInclude() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema id=\"tns\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:include schemaLocation=\"src/test/resources/xsd/SchemaB.xsd\" />\r\n  \r\n\t<xs:complexType name=\"Bar\">\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element ref=\"|\" />\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>";
        XMLAssert.testCompletionFor(xml, null, "test.xml", 2, XMLAssert.c("TypeFromB", XMLAssert.te(6, 20, 6, 20, "TypeFromB"), "TypeFromB"), XMLAssert.c("TypeFromC", XMLAssert.te(6, 20, 6, 20, "TypeFromC"), "TypeFromC"));
    }

    private void testCompletionFor(String xml, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(xml, null, expectedItems);
    }
}

