/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.concurrent.TimeUnit;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.ExternalResourceErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.DownloadDisabledResourceCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationRootSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.jupiter.api.Test;

public class XMLValidationExternalResourcesBasedOnXSDTest
extends AbstractCacheBasedTest {
    @Test
    public void noNamespaceSchemaLocationDownloadDisabled() throws Exception {
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        ls.initializeIfNeeded();
        ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
        contentModelManager.setDownloadExternalResources(false);
        String xml = "<root-element\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"http://localhost:8080/sample.xsd\">\r\n\t\r\n</root-element>";
        String fileURI = "test.xml";
        Diagnostic d = new Diagnostic(XMLAssert.r(2, 32, 2, 64), "Downloading external resources is disabled.", DiagnosticSeverity.Error, "xml", ExternalResourceErrorCode.DownloadResourceDisabled.getCode());
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, d, new Diagnostic(XMLAssert.r(0, 1, 0, 13), "cvc-elt.1.a: Cannot find the declaration of element 'root-element'.", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_elt_1_a.getCode())));
        XMLAssert.testCodeActionsFor(xml, fileURI, d, XMLAssert.ca(d, DownloadDisabledResourceCodeAction.createDownloadCommand((String)"Force download of 'http://localhost:8080/sample.xsd'.", (String)"http://localhost:8080/sample.xsd", (String)fileURI)));
    }

    @Test
    public void noNamespaceSchemaLocationDownloadProblem() throws Exception {
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        String xml = "<root-element\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"http://localhost:8080/sample.xsd\">\r\n\t\r\n</root-element>";
        String xsdCachePath = CacheResourcesManager.getResourceCachePath((String)"http://localhost:8080/sample.xsd").toString();
        String fileURI = "test.xml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(2, 32, 2, 64), "The resource 'http://localhost:8080/sample.xsd' is downloading in the cache path '" + xsdCachePath + "'.", DiagnosticSeverity.Information, "xml", ExternalResourceErrorCode.DownloadingResource.getCode()), new Diagnostic(XMLAssert.r(0, 1, 0, 13), "cvc-elt.1.a: Cannot find the declaration of element 'root-element'.", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_elt_1_a.getCode())));
        TimeUnit.SECONDS.sleep(5L);
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(2, 32, 2, 64), "Error while downloading 'http://localhost:8080/sample.xsd' to '" + xsdCachePath + "' : '[java.net.ConnectException] Connection refused'.", DiagnosticSeverity.Error, "xml", ExternalResourceErrorCode.DownloadProblem.getCode()), new Diagnostic(XMLAssert.r(0, 1, 0, 13), "cvc-elt.1.a: Cannot find the declaration of element 'root-element'.", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_elt_1_a.getCode())));
    }

    @Test
    public void schemaLocationDownloadDisabled() throws Exception {
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        ls.initializeIfNeeded();
        ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
        contentModelManager.setDownloadExternalResources(false);
        String xml = "<root-element xmlns=\"https://github.com/eclipse/lemminx\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"\r\n\t\thttps://github.com/eclipse/lemminx http://localhost:8080/sample.xsd\">\r\n\t\r\n</root-element>";
        String fileURI = "test.xml";
        Diagnostic d = new Diagnostic(XMLAssert.r(3, 37, 3, 69), "Downloading external resources is disabled.", DiagnosticSeverity.Error, "xml", ExternalResourceErrorCode.DownloadResourceDisabled.getCode());
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, d, new Diagnostic(XMLAssert.r(0, 1, 0, 13), "cvc-elt.1.a: Cannot find the declaration of element 'root-element'.", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_elt_1_a.getCode())));
        XMLAssert.testCodeActionsFor(xml, fileURI, d, XMLAssert.ca(d, DownloadDisabledResourceCodeAction.createDownloadCommand((String)"Force download of 'http://localhost:8080/sample.xsd'.", (String)"http://localhost:8080/sample.xsd", (String)fileURI)));
    }

    @Test
    public void schemaLocationDownloadProblem() throws Exception {
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        String xml = "<root-element xmlns=\"https://github.com/eclipse/lemminx\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"\r\n\t\thttps://github.com/eclipse/lemminx http://localhost:8080/sample.xsd\">\r\n\t\r\n</root-element>";
        String xsdCachePath = CacheResourcesManager.getResourceCachePath((String)"http://localhost:8080/sample.xsd").toString();
        String fileURI = "test.xml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(3, 37, 3, 69), "The resource 'http://localhost:8080/sample.xsd' is downloading in the cache path '" + xsdCachePath + "'.", DiagnosticSeverity.Information, "xml", ExternalResourceErrorCode.DownloadingResource.getCode()), new Diagnostic(XMLAssert.r(0, 1, 0, 13), "cvc-elt.1.a: Cannot find the declaration of element 'root-element'.", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_elt_1_a.getCode())));
        TimeUnit.SECONDS.sleep(5L);
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(3, 37, 3, 69), "Error while downloading 'http://localhost:8080/sample.xsd' to '" + xsdCachePath + "' : '[java.net.ConnectException] Connection refused'.", DiagnosticSeverity.Error, "xml", ExternalResourceErrorCode.DownloadProblem.getCode()), new Diagnostic(XMLAssert.r(0, 1, 0, 13), "cvc-elt.1.a: Cannot find the declaration of element 'root-element'.", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_elt_1_a.getCode())));
    }
}

